/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.nbimpl.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.profiler.api.java.SourceClassInfo;
import org.netbeans.modules.profiler.api.java.SourcePackageInfo;
import org.netbeans.modules.profiler.nbimpl.javac.ElementUtilitiesEx;
import org.netbeans.modules.profiler.nbimpl.javac.JavacClassInfo;
import org.netbeans.modules.profiler.nbimpl.javac.JavacPackageInfo;
import org.netbeans.modules.profiler.nbimpl.javac.ParsingUtils;
import org.netbeans.modules.profiler.nbimpl.javac.ScanSensitiveTask;
import org.netbeans.modules.profiler.spi.java.ProfilerTypeUtilsProvider;

public abstract class BaseProfilerTypeUtilsImpl
extends ProfilerTypeUtilsProvider {
    private static final Logger LOG = Logger.getLogger(BaseProfilerTypeUtilsImpl.class.getName());

    public final Collection<SourcePackageInfo> getPackages(boolean subprojects, final SourcePackageInfo.Scope scope) {
        final ArrayList<SourcePackageInfo> pkgs = new ArrayList<SourcePackageInfo>();
        final ClasspathInfo cpInfo = this.getClasspathInfo(subprojects, scope == SourcePackageInfo.Scope.SOURCE, scope == SourcePackageInfo.Scope.DEPENDENCIES);
        final ClasspathInfo indexInfo = this.getClasspathInfo(subprojects, true, true);
        if (cpInfo != null) {
            ParsingUtils.invokeScanSensitiveTask(cpInfo, new ScanSensitiveTask<CompilationController>(true){

                public void run(CompilationController cc) {
                    for (String pkgName : cpInfo.getClassIndex().getPackageNames("", true, BaseProfilerTypeUtilsImpl.this.toSearchScope(Collections.singleton(scope)))) {
                        pkgs.add(new JavacPackageInfo(cpInfo, indexInfo, pkgName, pkgName, scope));
                    }
                }
            });
        }
        return pkgs;
    }

    public final SourceClassInfo resolveClass(String className) {
        ClasspathInfo cpInfo = this.getClasspathInfo();
        if (cpInfo != null) {
            ElementHandle<TypeElement> eh = ElementUtilitiesEx.resolveClassByName(className, cpInfo, false);
            return eh != null ? new JavacClassInfo(eh, cpInfo) : null;
        }
        return null;
    }

    public Collection<SourceClassInfo> findClasses(final String pattern, final Set<SourcePackageInfo.Scope> scope) {
        final ArrayList<SourceClassInfo> clzs = new ArrayList<SourceClassInfo>();
        final ClasspathInfo cpInfo = this.getClasspathInfo();
        if (cpInfo != null) {
            ParsingUtils.invokeScanSensitiveTask(cpInfo, new ScanSensitiveTask<CompilationController>(true){

                public void run(CompilationController cc) {
                    for (ElementHandle eh : cpInfo.getClassIndex().getDeclaredTypes(pattern, ClassIndex.NameKind.CASE_INSENSITIVE_REGEXP, BaseProfilerTypeUtilsImpl.this.toSearchScope(scope))) {
                        clzs.add(new JavacClassInfo((ElementHandle<TypeElement>)eh, cpInfo));
                    }
                }
            });
        }
        return clzs;
    }

    protected abstract ClasspathInfo getClasspathInfo();

    protected abstract ClasspathInfo getClasspathInfo(boolean var1, boolean var2, boolean var3);

    private Set<ClassIndex.SearchScope> toSearchScope(Set<SourcePackageInfo.Scope> scope) {
        EnumSet<ClassIndex.SearchScope> sScope = EnumSet.noneOf(ClassIndex.SearchScope.class);
        for (SourcePackageInfo.Scope s : scope) {
            switch (s) {
                case DEPENDENCIES: {
                    sScope.add(ClassIndex.SearchScope.DEPENDENCIES);
                    break;
                }
                case SOURCE: {
                    sScope.add(ClassIndex.SearchScope.SOURCE);
                }
            }
        }
        return sScope;
    }
}

