/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.nbimpl.actions;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.modules.profiler.HeapDumpWatch;
import org.netbeans.modules.profiler.actions.ProfilingSupport;
import org.netbeans.modules.profiler.api.JavaPlatform;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.api.project.ProjectProfilingSupport;
import org.netbeans.modules.profiler.nbimpl.NetBeansProfiler;
import org.netbeans.modules.profiler.nbimpl.actions.Bundle;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.netbeans.spi.project.ActionProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class ProfilerLauncher {
    private static final Logger LOG = Logger.getLogger(ProfilerLauncher.class.getName());
    private static final String AGENT_ARGS = "agent.jvmargs";
    private static final String LINUX_THREAD_TIMER_KEY = "-XX:+UseLinuxPosixThreadCPUClocks";
    private static Session lastSession;

    public static Session newSession(@NonNull String command, @NonNull Lookup context) {
        return Session.createSession(command, context);
    }

    public static Session getLastSession() {
        return lastSession;
    }

    public static void clearLastSession() {
        lastSession = null;
    }

    public static boolean canRelaunch() {
        return lastSession != null;
    }

    private static void config(Session session) {
        String javaFile;
        Project project = null;
        if (session.project == null) {
            if (session.fo != null) {
                project = FileOwnerQuery.getOwner((FileObject)session.fo);
            }
        } else {
            project = session.project;
        }
        if (project == null) {
            return;
        }
        if (ProfilingSupport.getDefault().checkProfilingInProgress()) {
            return;
        }
        ProjectProfilingSupport pSupport = ProjectProfilingSupport.get((Lookup.Provider)project);
        if (pSupport == null) {
            return;
        }
        JavaPlatform platform = pSupport.getProjectJavaPlatform();
        String string = javaFile = platform != null ? platform.getPlatformJavaFile() : null;
        if (javaFile == null) {
            if (ProfilerIDESettings.getInstance().getJavaPlatformForProfiling() == null) {
                ProfilerDialogs.displayError((String)Bundle.InvalidPlatformProjectMsg(platform != null ? platform.getDisplayName() : Bundle.LBL_Unknown()));
            } else {
                ProfilerDialogs.displayError((String)Bundle.InvalidPlatformProfilerMsg(platform != null ? platform.getDisplayName() : Bundle.LBL_Unknown()));
            }
            return;
        }
        SessionSettings ss = new SessionSettings();
        pSupport.setupProjectSessionSettings(ss);
        ProfilerIDESettings gps = ProfilerIDESettings.getInstance();
        ss.setPortNo(gps.getPortNo());
        String javaVersion = platform.getPlatformJDKVersion();
        if (javaVersion == null) {
            ProfilerDialogs.displayError((String)Bundle.FailedDetermineJavaPlatformMsg(platform.getDisplayName()));
            return;
        }
        session.ss = ss;
        session.platform = platform;
    }

    private static void setupAgentEnv(JavaPlatform platform, SessionSettings ss, ProfilerIDESettings gps, ProfilingSettings pSettings, Project project, Map<String, String> props) {
        String javaVersion = platform.getPlatformJDKVersion();
        if (javaVersion.equals("jdk15")) {
            props.put(AGENT_ARGS, IDEUtils.getAntProfilerStartArgument15((int)ss.getPortNo(), (int)ss.getSystemArchitecture()));
            if (platform.getPlatformJDKMinor() >= 7) {
                ProfilerLauncher.activateOOMProtection(gps, props, project);
            } else {
                ProfilerLogger.log((String)"Profiler.OutOfMemoryDetection: Disabled. Not supported JVM. Use at least 1.4.2_12 or 1.5.0_07");
            }
        } else if (javaVersion.equals("jdk16")) {
            props.put(AGENT_ARGS, IDEUtils.getAntProfilerStartArgument16((int)ss.getPortNo(), (int)ss.getSystemArchitecture()));
            ProfilerLauncher.activateOOMProtection(gps, props, project);
        } else if (javaVersion.equals("jdk17")) {
            props.put(AGENT_ARGS, IDEUtils.getAntProfilerStartArgument17((int)ss.getPortNo(), (int)ss.getSystemArchitecture()));
            ProfilerLauncher.activateOOMProtection(gps, props, project);
        } else if (javaVersion.equals("jdk18")) {
            props.put(AGENT_ARGS, IDEUtils.getAntProfilerStartArgument18((int)ss.getPortNo(), (int)ss.getSystemArchitecture()));
            ProfilerLauncher.activateOOMProtection(gps, props, project);
        } else {
            throw new IllegalArgumentException("Unsupported JDK " + javaVersion);
        }
        if (Platform.isLinux() && javaVersion.equals("jdk16")) {
            ProfilerLauncher.activateLinuxPosixThreadTime(pSettings, props);
        }
        props.put("profiler.info.project.dir", project.getProjectDirectory().getPath());
    }

    private static void activateLinuxPosixThreadTime(ProfilingSettings ps, Map<String, String> props) {
        if (ps.getThreadCPUTimerOn()) {
            props.put("profiler.info.jvmargs", "-XX:+UseLinuxPosixThreadCPUClocks " + props.get("profiler.info.jvmargs"));
            ProfilerLogger.log((String)"Profiler.UseLinuxPosixThreadCPUClocks: Enabled");
        }
    }

    private static void activateOOMProtection(ProfilerIDESettings gps, Map<String, String> props, Project project) {
        if (gps.isOOMDetectionEnabled()) {
            String oldArgs = props.get("profiler.info.jvmargs");
            oldArgs = oldArgs != null ? oldArgs : "";
            StringBuilder oomArgsBuffer = new StringBuilder(oldArgs);
            String heapDumpPath = HeapDumpWatch.getHeapDumpPath((Lookup.Provider)project);
            if (heapDumpPath != null && heapDumpPath.length() > 0) {
                if (heapDumpPath.contains(" ")) {
                    heapDumpPath = "\"" + heapDumpPath + "\"";
                }
                oomArgsBuffer.append(" -XX:+HeapDumpOnOutOfMemoryError");
                oomArgsBuffer.append(" -XX:HeapDumpPath=").append(heapDumpPath).append(" ");
                ProfilerLogger.log((String)"Profiler.OutOfMemoryDetection: Enabled");
            }
            props.put("profiler.info.jvmargs", oomArgsBuffer.toString());
        }
    }

    private static final class AntLauncher
    implements Launcher {
        private ActionProvider ap;
        private String command;
        private Lookup context;

        public AntLauncher(ActionProvider ap, String command, Lookup context) {
            this.ap = ap;
            this.command = command;
            this.context = context;
        }

        @Override
        public void launch(boolean rerun) {
            this.ap.invokeAction(this.command, this.context);
        }
    }

    public static final class AntLauncherFactory
    implements LauncherFactory {
        private final Project prj;

        public AntLauncherFactory(Project prj) {
            this.prj = prj;
        }

        @Override
        public Launcher createLauncher(Session session) {
            ActionProvider ap = (ActionProvider)this.prj.getLookup().lookup(ActionProvider.class);
            if (ap != null) {
                return new AntLauncher(ap, session.command, session.context);
            }
            return null;
        }
    }

    public static interface Launcher {
        public void launch(boolean var1);
    }

    public static interface LauncherFactory {
        public Launcher createLauncher(Session var1);
    }

    public static final class Session {
        private SessionSettings ss;
        private ProfilingSettings ps;
        private Map<String, String> props;
        private Launcher launcher;
        private Project project;
        private FileObject fo;
        private JavaPlatform platform;
        private String command;
        private Lookup context;
        private final Map<String, Object> customProps = new HashMap<String, Object>();
        private boolean configured = false;
        private boolean rerun;

        public static Session createSession(String command, Lookup context) {
            Session s = new Session(command, context);
            ProfilerLauncher.config(s);
            lastSession = s;
            return s;
        }

        public static Session createSession(Project p) {
            Session s = new Session(p);
            ProfilerLauncher.config(s);
            return s;
        }

        private Session(Project p) {
            this.props = new HashMap<String, String>();
            this.launcher = null;
            this.project = p;
        }

        private Session(String command, Lookup context) {
            assert (command != null);
            assert (context != null);
            this.project = (Project)context.lookup(Project.class);
            this.fo = (FileObject)context.lookup(FileObject.class);
            this.command = command;
            this.props = new HashMap<String, String>();
            this.context = context;
            this.initLauncher();
        }

        public ProfilingSettings getProfilingSettings() {
            return this.ps;
        }

        public void setProfilingSettings(ProfilingSettings ps) {
            this.ps = ps;
        }

        public SessionSettings getSessionSettings() {
            return this.ss;
        }

        public void setSessionSettings(SessionSettings ss) {
            this.ss = ss;
            this.ss.store(this.props);
        }

        public Map<String, String> getProperties() {
            if (!this.configured) {
                if (this.configure()) {
                    return this.props;
                }
                return null;
            }
            return this.props;
        }

        public Project getProject() {
            return this.project;
        }

        public JavaPlatform getPlatform() {
            return this.platform;
        }

        public Lookup getContext() {
            return this.context;
        }

        public FileObject getFile() {
            return this.fo;
        }

        public String getCommand() {
            return this.command;
        }

        public Object getAttribute(String name) {
            return this.customProps.get(name);
        }

        public void setAttribute(String name, Object value) {
            this.customProps.put(name, value);
        }

        public boolean hasAttribute(String name) {
            return this.customProps.containsKey(name);
        }

        public boolean isConfigured() {
            return this.configured;
        }

        public boolean configure() {
            if (this.ss == null || this.ss.getJavaExecutable() == null) {
                return false;
            }
            ProjectProfilingSupport pSupport = ProjectProfilingSupport.get((Lookup.Provider)this.project);
            NetBeansProfiler.getDefaultNB().setProfiledProject((Lookup.Provider)this.project, this.fo);
            ProfilingSettings ps = ProfilingSupport.getDefault().selectTaskForProfiling((Lookup.Provider)this.project, this.ss, this.fo, true);
            if (ps != null) {
                this.ps = ps;
                this.ps.store(this.props);
                ProfilerLauncher.setupAgentEnv(this.platform, this.ss, ProfilerIDESettings.getInstance(), ps, this.project, this.props);
                pSupport.configurePropertiesForProfiling(this.props, this.fo);
                this.rerun = false;
                this.configured = true;
            }
            return this.configured;
        }

        public void run() {
            if (this.launcher != null) {
                this.launcher.launch(this.rerun);
                this.rerun = true;
            }
        }

        private void initLauncher() {
            LauncherFactory f;
            Project p = null;
            if (this.project != null) {
                p = this.project;
            } else if (this.fo != null) {
                p = FileOwnerQuery.getOwner((FileObject)this.fo);
            }
            if (p != null && (f = (LauncherFactory)p.getLookup().lookup(LauncherFactory.class)) != null) {
                this.launcher = f.createLauncher(this);
            }
        }
    }
}

