/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.nbimpl.actions;

import javax.swing.SwingUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.profiler.api.project.ProjectProfilingSupport;
import org.netbeans.modules.profiler.nbimpl.actions.ProfilerLauncher;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.FileActionPerformer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class FileSensitivePerformer
implements FileActionPerformer {
    private final String command;

    public FileSensitivePerformer(String command) {
        this.command = command;
    }

    public boolean enable(FileObject file) {
        if (file == null) {
            return false;
        }
        Project p = FileOwnerQuery.getOwner((FileObject)file);
        if (p == null) {
            return false;
        }
        ActionProvider ap = (ActionProvider)p.getLookup().lookup(ActionProvider.class);
        try {
            if (ap != null && FileSensitivePerformer.contains(ap.getSupportedActions(), this.command)) {
                ProjectProfilingSupport ppp = ProjectProfilingSupport.get((Lookup.Provider)p);
                if (ppp == null) {
                    return false;
                }
                return ppp.isProfilingSupported() && ap.isActionEnabled(this.command, this.getContext(file));
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        return false;
    }

    public void perform(final FileObject file) {
        Project p = FileOwnerQuery.getOwner((FileObject)file);
        ActionProvider ap = (ActionProvider)p.getLookup().lookup(ActionProvider.class);
        if (ap != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProfilerLauncher.Session s = ProfilerLauncher.newSession(FileSensitivePerformer.this.command, FileSensitivePerformer.this.getContext(file));
                    if (s != null) {
                        s.run();
                    }
                }
            });
        }
    }

    private Lookup getContext(FileObject file) {
        Project p = FileOwnerQuery.getOwner((FileObject)file);
        try {
            return Lookups.fixed((Object[])new Object[]{file, p, DataObject.find((FileObject)file)});
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return Lookups.fixed((Object[])new Object[]{file, p});
        }
    }

    private static boolean contains(String[] actions, String action) {
        for (String a : actions) {
            if (!a.equals(action)) continue;
            return true;
        }
        return false;
    }
}

