/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public final class URLCache {
    private static URLCache instance = null;
    private final Map<URI, Reference<FileObject>> cache = Collections.synchronizedMap(new WeakHashMap());

    public static synchronized URLCache getInstance() {
        if (instance == null) {
            instance = new URLCache();
        }
        return instance;
    }

    @CheckForNull
    public FileObject findFileObject(@NonNull URL url) {
        URI uri = null;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        FileObject f = null;
        if (uri != null) {
            Reference<FileObject> ref = this.cache.get(uri);
            if (ref != null) {
                f = ref.get();
            }
            if (f != null && f.isValid() && url.equals(f.toURL())) {
                return f;
            }
        }
        f = URLMapper.findFileObject((URL)url);
        if (uri != null && f != null && f.isValid()) {
            this.cache.put(uri, new CleanReference(f, uri));
        }
        return f;
    }

    private URLCache() {
    }

    private final class CleanReference
    extends WeakReference<FileObject>
    implements Runnable {
        private final URI uri;

        CleanReference(@NonNull FileObject referent, URI uri) {
            super(referent, Utilities.activeReferenceQueue());
            assert (referent != null);
            assert (uri != null);
            this.uri = uri;
        }

        @Override
        public void run() {
            URLCache.this.cache.remove(this.uri);
        }
    }
}

