/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.BeanProp;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.DOMBinding;
import org.netbeans.modules.schema2beans.GraphManager;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.schema2beans.Schema2BeansRuntimeException;
import org.netbeans.modules.schema2beans.TraceLogger;
import org.netbeans.modules.schema2beans.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Schema2BeansUtil {
    public static void write(BaseBean bean, Writer writer) throws IOException {
        GraphManager graphManager = bean.graphManager();
        if (graphManager == null) {
            throw new IllegalStateException(Common.getMessage("CantWriteBeanNotInDOMTree_msg"));
        }
        graphManager.write(writer);
    }

    public static void write(BaseBean bean, OutputStream outputStream) throws IOException {
        try {
            GraphManager graphManager = bean.graphManager();
            if (graphManager == null) {
                throw new IllegalStateException(Common.getMessage("CantWriteBeanNotInDOMTree_msg"));
            }
            graphManager.write(outputStream);
        }
        catch (Schema2BeansException e) {
            throw new Schema2BeansRuntimeException(e);
        }
    }

    public static void mergeUnsupportedElements(BaseBean bean, BaseBean patternBean) {
        HashMap<Node, BaseBean> nodeMap = new HashMap<Node, BaseBean>();
        LinkedList<BaseBean> l = new LinkedList<BaseBean>();
        l.add(bean);
        bean.childBeans(true, l);
        l.add(patternBean);
        patternBean.childBeans(true, l);
        for (BaseBean baseBean : l) {
            DOMBinding binding = baseBean.binding;
            if (binding == null) continue;
            nodeMap.put(binding.getNode(), baseBean);
        }
        Schema2BeansUtil.mergeNode(nodeMap, Schema2BeansUtil.getOwnerDocument(bean.binding.getNode()), Schema2BeansUtil.getOwnerDocument(patternBean.binding.getNode()));
    }

    private static void mergeBeans(Map nodeMap, BaseBean bean, BaseBean patternBean) {
        if (bean.binding != null && patternBean.binding != null) {
            Node node = bean.binding.getNode();
            Node otherNode = patternBean.binding.getNode();
            if (node != null && otherNode != null) {
                Schema2BeansUtil.mergeNode(nodeMap, node, otherNode);
            }
        }
    }

    private static Document getOwnerDocument(Node node) {
        return node instanceof Document ? (Document)node : node.getOwnerDocument();
    }

    private static void mergeNode(Map nodeMap, Node node, Node patternNode) {
        Schema2BeansUtil.mergeAttributes(node, patternNode);
        NodeList childNodes = node.getChildNodes();
        List children = Schema2BeansUtil.relevantNodes(childNodes);
        Document document = Schema2BeansUtil.getOwnerDocument(node);
        for (int i = childNodes.getLength() - 1; i >= 0; --i) {
            Node childNode = childNodes.item(i);
            if (Schema2BeansUtil.isRelevantNode(childNode)) continue;
            node.removeChild(childNode);
        }
        NodeList patternChildNodes = patternNode.getChildNodes();
        for (int i = 0; i < patternChildNodes.getLength(); ++i) {
            Node patternChild = patternChildNodes.item(i);
            Node currentChild = childNodes.item(i);
            if (Schema2BeansUtil.isRelevantNode(patternChild)) {
                Node foundChild;
                BaseBean foundBean;
                BaseBean patternBean = (BaseBean)nodeMap.get(patternChild);
                if (patternBean != null) {
                    foundBean = Schema2BeansUtil.takeEqualBean(nodeMap, children, patternBean);
                    foundChild = foundBean == null ? null : foundBean.binding.getNode();
                } else {
                    foundBean = null;
                    foundChild = null;
                }
                if (foundChild == null) {
                    foundChild = Schema2BeansUtil.takeEqualNode(children, patternChild);
                }
                if (foundChild != null) {
                    if (foundChild != currentChild) {
                        node.removeChild(foundChild);
                        node.insertBefore(foundChild, currentChild);
                    }
                    if (foundBean != null) {
                        Schema2BeansUtil.mergeBeans(nodeMap, foundBean, patternBean);
                        continue;
                    }
                    if (Schema2BeansUtil.isRelevantNode(foundChild)) {
                        Schema2BeansUtil.mergeNode(nodeMap, foundChild, patternChild);
                        continue;
                    }
                    foundChild.setNodeValue(patternChild.getNodeValue());
                    continue;
                }
                Node child = document.importNode(patternChild, true);
                node.insertBefore(child, currentChild);
                continue;
            }
            Node child = document.importNode(patternChild, true);
            node.insertBefore(child, currentChild);
        }
    }

    private static void mergeAttributes(Node node, Node otherNode) {
        NamedNodeMap attributes = node.getAttributes();
        NamedNodeMap otherAttributes = otherNode.getAttributes();
        if (attributes == null) {
            if (otherAttributes == null) {
                return;
            }
            TraceLogger.error("Attributes merge error: " + node.getClass().getName() + "  " + otherNode.getClass().getName());
            return;
        }
        if (otherAttributes == null) {
            TraceLogger.error("Attributes merge error: " + node.getClass().getName() + "  " + otherNode.getClass().getName());
            return;
        }
        LinkedList<String> names = new LinkedList<String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            names.add(attributes.item(i).getNodeName());
        }
        for (String name : names) {
            if (otherAttributes.getNamedItem(name) != null) continue;
            attributes.removeNamedItem(name);
        }
        Document document = Schema2BeansUtil.getOwnerDocument(node);
        for (int i = 0; i < otherAttributes.getLength(); ++i) {
            Node newAttribute = otherAttributes.item(i);
            String name = newAttribute.getNodeName();
            String value = newAttribute.getNodeValue();
            Node currentAttribute = attributes.getNamedItem(name);
            if (currentAttribute == null) {
                currentAttribute = document.createAttribute(name);
                attributes.setNamedItem(currentAttribute);
            }
            currentAttribute.setNodeValue(value);
        }
    }

    private static BaseBean takeEqualBean(Map nodeMap, List nodes, BaseBean patternBean) {
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            BaseBean bean = (BaseBean)nodeMap.get(node);
            if (bean == null || !bean.isEqualTo(patternBean)) continue;
            it.remove();
            return bean;
        }
        return null;
    }

    private static Node takeEqualNode(List nodes, Node patternNode) {
        List result = Schema2BeansUtil.filterNodes(nodes, patternNode);
        if (result.size() == 0) {
            return null;
        }
        Node node = (Node)result.get(0);
        nodes.remove(node);
        return node;
    }

    private static List filterNodes(List nodes, Node patternNode) {
        LinkedList<Node> trueList = new LinkedList<Node>();
        String name = patternNode.getNodeName();
        for (Node node : nodes) {
            if (!name.equals(node.getNodeName())) continue;
            trueList.add(node);
        }
        if (trueList.size() <= 1) {
            return trueList;
        }
        LinkedList<Node> falseList = new LinkedList<Node>();
        Iterator it = trueList.iterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            if (!patternNode.equals(node)) continue;
            it.remove();
            falseList.add(node);
        }
        if (trueList.size() == 1) {
            return trueList;
        }
        if (trueList.size() == 0) {
            trueList = falseList;
        }
        falseList = new LinkedList();
        String value = patternNode.getNodeValue();
        Iterator it2 = trueList.iterator();
        while (it2.hasNext()) {
            Node node = (Node)it2.next();
            if (Schema2BeansUtil.equals(value, node.getNodeValue())) continue;
            it2.remove();
            falseList.add(node);
        }
        if (trueList.size() == 1) {
            return trueList;
        }
        if (trueList.size() == 0) {
            trueList = falseList;
        }
        falseList = new LinkedList();
        NamedNodeMap attributes = patternNode.getAttributes();
        Iterator it3 = trueList.iterator();
        while (it3.hasNext()) {
            Node node = (Node)it3.next();
            if (Schema2BeansUtil.equals(attributes, node.getAttributes())) continue;
            it3.remove();
            falseList.add(node);
        }
        if (trueList.size() == 0) {
            return falseList;
        }
        return trueList;
    }

    private static boolean equals(String s1, String s2) {
        return s1 == null ? s2 == null : s2 != null && s1.trim().equals(s2.trim());
    }

    private static boolean equals(NamedNodeMap attributes1, NamedNodeMap attributes2) {
        if (attributes1 == null || attributes2 == null) {
            return attributes1 == attributes2;
        }
        int n = attributes1.getLength();
        if (n != attributes2.getLength()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Node attr1 = attributes1.item(i);
            Node attr2 = attributes2.getNamedItem(attr1.getNodeName());
            if (attr2 != null && attr2.getNodeValue().equals(attr2.getNodeValue())) continue;
            return false;
        }
        return true;
    }

    private static List relevantNodes(NodeList nodeList) {
        LinkedList<Node> list = new LinkedList<Node>();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!Schema2BeansUtil.isRelevantNode(node)) continue;
                list.add(node);
            }
        }
        return list;
    }

    private static boolean isRelevantNode(Node node) {
        short type = node.getNodeType();
        return type != 8 && !Schema2BeansUtil.isWhiteSpaceNode(node);
    }

    private static boolean isWhiteSpaceNode(Node node) {
        short type = node.getNodeType();
        return type == 3 && node.getNodeValue().trim().length() == 0;
    }

    private static Node findNode(BaseBean bean, String path) {
        if (path.startsWith(bean.fullName())) {
            BaseBean matchingChild;
            while ((matchingChild = Schema2BeansUtil.getMatchingChild(bean, path)) != null) {
                bean = matchingChild;
            }
            if (path.equals(bean.fullName())) {
                return bean.binding.node;
            }
            BeanProp[] beanProps = bean.beanProps();
            for (int i = 0; i < beanProps.length; ++i) {
                BeanProp prop = beanProps[i];
                int n = prop.bindingsSize();
                for (int j = 0; j < n; ++j) {
                    if (!path.equals(prop.getFullName(j))) continue;
                    return prop.getBinding((int)j).node;
                }
            }
        }
        return null;
    }

    private static BaseBean getMatchingChild(BaseBean bean, String path) {
        BaseBean[] beans = bean.childBeans(false);
        for (int i = 0; i < beans.length; ++i) {
            BaseBean baseBean = beans[i];
            if (!path.startsWith(baseBean.fullName())) continue;
            return baseBean;
        }
        return null;
    }

    public static class ReindentationListener
    implements PropertyChangeListener {
        String indent = "    ";

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object oldValue = evt.getOldValue();
            Object newValue = evt.getNewValue();
            if (oldValue == null && newValue != null) {
                String path = evt.getPropertyName();
                BaseBean bean = (BaseBean)evt.getSource();
                Node node = Schema2BeansUtil.findNode(bean, path);
                if (node != null) {
                    this.reindentNode(node);
                }
            }
        }

        private void reindentNode(Node node) {
            Document document = node.getOwnerDocument();
            int level = 0;
            StringBuffer sb = new StringBuffer("\n");
            for (Node parent = node.getParentNode(); parent != document; parent = parent.getParentNode()) {
                ++level;
                sb.append(this.indent);
            }
            String indentString = sb.toString();
            Node parentNode = node.getParentNode();
            Node previousNode = node.getPreviousSibling();
            if (previousNode != null && Schema2BeansUtil.isWhiteSpaceNode(previousNode)) {
                String s = previousNode.getNodeValue();
                int i = s.lastIndexOf(10);
                s = i > 0 ? s.substring(0, i) + indentString : indentString;
                previousNode.setNodeValue(s);
            } else {
                parentNode.insertBefore(document.createTextNode(indentString), node);
            }
            Node nextNode = node.getNextSibling();
            if (nextNode != null && Schema2BeansUtil.isWhiteSpaceNode(nextNode)) {
                String s = nextNode.getNodeValue();
                int i = s.indexOf(10);
                if (i == -1) {
                    nextNode.setNodeValue(indentString);
                }
            } else {
                parentNode.insertBefore(document.createTextNode(indentString), nextNode);
            }
            XMLUtil.reindent(document, node, level, this.indent);
        }

        public String getIndent() {
            return this.indent;
        }

        public void setIndent(String indent) {
            this.indent = indent;
        }
    }
}

