/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.image.navigation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class ImagePreviewPanel
extends JPanel {
    BufferedImage image;
    private final int stringGapSize = 10;

    public void setImage(BufferedImage image) {
        this.image = image;
        this.setBackground(Color.WHITE);
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(Color.BLACK);
        if (this.image != null) {
            int width = this.image.getWidth();
            int height = this.image.getHeight();
            String sizes = "Dimensions: " + width + " x " + height;
            g.drawString(sizes, (int)((double)this.getWidth() * 0.05), this.getHeight() - 10);
            double widthRatio = (double)this.image.getWidth() / ((double)this.getWidth() * 0.9);
            double heightRatio = (double)this.image.getHeight() / ((double)this.getHeight() * 0.9 - 10.0 - 20.0);
            if (widthRatio > 1.0 || heightRatio > 1.0) {
                double ratio = widthRatio > heightRatio ? widthRatio : heightRatio;
                width = (int)((double)this.image.getWidth() / ratio);
                height = (int)((double)this.image.getHeight() / ratio);
            }
            g.drawImage(this.image, (this.getWidth() - width) / 2, (this.getHeight() - height) / 2, width, height, this);
        }
    }
}

