/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.declarative.debugging;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaParserResultTask;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.hints.declarative.Condition;
import org.netbeans.modules.java.hints.declarative.DeclarativeHintsParser;
import org.netbeans.modules.java.hints.declarative.conditionapi.Context;
import org.netbeans.modules.java.hints.declarative.conditionapi.Matcher;
import org.netbeans.modules.java.hints.declarative.debugging.DebugTopComponent;
import org.netbeans.modules.java.hints.declarative.debugging.DebuggingHighlightsLayerFactory;
import org.netbeans.modules.java.hints.declarative.debugging.HintWrapper;
import org.netbeans.modules.java.hints.declarative.test.TestTokenId;
import org.netbeans.modules.java.hints.spiimpl.SPIAccessor;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.CursorMovedSchedulerEvent;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.netbeans.modules.parsing.spi.TaskIndexingMode;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class EvaluationSpanTask
extends JavaParserResultTask<Parser.Result> {
    private static final AttributeSet PASSED = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, Color.GREEN});
    private static final AttributeSet FAILED = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, Color.RED});
    private static final Set<JavaTokenId> WHITESPACES = EnumSet.of(JavaTokenId.BLOCK_COMMENT, JavaTokenId.JAVADOC_COMMENT, JavaTokenId.LINE_COMMENT, JavaTokenId.WHITESPACE);

    public EvaluationSpanTask() {
        super(JavaSource.Phase.RESOLVED, TaskIndexingMode.ALLOWED_DURING_SCAN);
    }

    public void run(Parser.Result result, SchedulerEvent event) {
        if (!(event instanceof CursorMovedSchedulerEvent)) {
            return;
        }
        CursorMovedSchedulerEvent evt = (CursorMovedSchedulerEvent)event;
        final CompilationInfo[] info = new CompilationInfo[]{CompilationInfo.get((Parser.Result)result)};
        int start = evt.getMarkOffset();
        int end = evt.getCaretOffset();
        if (info[0] == null) {
            TokenSequence ts = result.getSnapshot().getTokenHierarchy().tokenSequence(TestTokenId.language());
            if (ts == null) {
                return;
            }
            ts.move(evt.getCaretOffset());
            if (!ts.moveNext() || ts.token().id() != TestTokenId.JAVA_CODE) {
                return;
            }
            int tokenStart = ts.offset();
            int tokenEnd = ts.offset() + ts.token().length();
            if (evt.getCaretOffset() < tokenStart || tokenEnd < evt.getCaretOffset()) {
                return;
            }
            if (evt.getMarkOffset() < tokenStart || tokenEnd < evt.getMarkOffset()) {
                return;
            }
            start -= ts.offset();
            end -= ts.offset();
            try {
                FileObject file = FileUtil.createMemoryFileSystem().getRoot().createData("Test.java");
                OutputStreamWriter out = new OutputStreamWriter(file.getOutputStream(), "UTF-8");
                out.write(((Object)ts.token().text()).toString());
                ((Writer)out).close();
                ClasspathInfo cpInfo = ClasspathInfo.create((FileObject)file);
                JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[]{file}).runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController parameter) throws Exception {
                        parameter.toPhase(JavaSource.Phase.RESOLVED);
                        info[0] = parameter;
                    }
                }, true);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return;
            }
        }
        if (info[0] == null) {
            return;
        }
        DebugTopComponent c = DebugTopComponent.getExistingInstance();
        if (c == null) {
            return;
        }
        Document doc = c.getDocument();
        assert (doc != null);
        LinkedList<int[]> passed = new LinkedList<int[]>();
        LinkedList<int[]> failed = new LinkedList<int[]>();
        EvaluationSpanTask.computeHighlights(info[0], start, end, c.getHints(), passed, failed);
        OffsetsBag bag = new OffsetsBag(doc);
        for (int[] span : passed) {
            bag.addHighlight(span[0], span[1], PASSED);
        }
        for (int[] span : failed) {
            bag.addHighlight(span[0], span[1], FAILED);
        }
        DebuggingHighlightsLayerFactory.getBag(doc).setHighlights(bag);
    }

    static void computeHighlights(CompilationInfo info, int selectionStart, int selectionEnd, Collection<? extends HintWrapper> hints, List<int[]> passed, List<int[]> failed) {
        if (hints.isEmpty()) {
            return;
        }
        if (selectionStart == selectionEnd) {
            return;
        }
        int t = Math.min(selectionStart, selectionEnd);
        selectionEnd = EvaluationSpanTask.skipWhitespaces(info, Math.max(selectionStart, selectionEnd), false);
        selectionStart = EvaluationSpanTask.skipWhitespaces(info, t, true);
        TreePath tp = EvaluationSpanTask.validateSelection(info, selectionStart, selectionEnd);
        if (tp == null) {
            return;
        }
        for (HintWrapper hintWrapper : hints) {
            HashMap<String, TreePath> variables = new HashMap<String, TreePath>();
            HashMap multiVariables = new HashMap();
            HashMap variableNames = new HashMap();
            variables.put("$_", tp);
            HintContext ctx = SPIAccessor.getINSTANCE().createHintContext(info, null, tp, variables, multiVariables, variableNames);
            String pattern = hintWrapper.spec.substring(hintWrapper.desc.textStart, hintWrapper.desc.textEnd);
            Context context = new Context(ctx);
            context.enterScope();
            boolean matches = new Matcher(context).matchesWithBind(context.variableForName("$_"), pattern);
            List<int[]> target = matches ? passed : failed;
            target.add(EvaluationSpanTask.trim(hintWrapper.spec, new int[]{hintWrapper.desc.textStart, hintWrapper.desc.textEnd}));
            if (!matches) continue;
            EvaluationSpanTask.evaluateConditions(hintWrapper.desc.conditions, hintWrapper.desc.conditionSpans, context, passed, failed, hintWrapper);
            context.enterScope();
            for (DeclarativeHintsParser.FixTextDescription f : hintWrapper.desc.fixes) {
                EvaluationSpanTask.evaluateConditions(f.conditions, f.conditionSpans, context, passed, failed, hintWrapper);
            }
            context.leaveScope();
        }
    }

    private static void evaluateConditions(Iterable<Condition> conditions, Iterable<int[]> conditionSpans, Context ctx, List<int[]> passed, List<int[]> failed, HintWrapper d) {
        Iterator<Condition> cond = conditions.iterator();
        Iterator<int[]> span = conditionSpans.iterator();
        while (cond.hasNext() && span.hasNext()) {
            boolean holds = cond.next().holds(ctx, true);
            List<int[]> condTarget = holds ? passed : failed;
            condTarget.add(EvaluationSpanTask.trim(d.spec, span.next()));
        }
    }

    private static int[] trim(String spec, int[] span) {
        while (Character.isWhitespace(spec.charAt(span[0]))) {
            span[0] = span[0] + 1;
        }
        while (Character.isWhitespace(spec.charAt(span[1] - 1))) {
            span[1] = span[1] - 1;
        }
        return span;
    }

    private static int skipWhitespaces(CompilationInfo info, int pos, boolean forward) {
        TokenSequence ts = info.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        ts.move(pos);
        boolean moveSucceeded = false;
        while (forward ? ts.moveNext() : ts.movePrevious()) {
            moveSucceeded = true;
            if (WHITESPACES.contains(ts.token().id())) continue;
        }
        if (moveSucceeded) {
            return forward ? ts.offset() : ts.offset() + ts.token().length();
        }
        return pos;
    }

    private static TreePath validateSelection(CompilationInfo ci, int start, int end) {
        for (TreePath tp = ci.getTreeUtilities().pathFor((start + end) / 2 + 1); tp != null; tp = tp.getParentPath()) {
            Tree leaf = tp.getLeaf();
            long treeStart = ci.getTrees().getSourcePositions().getStartPosition(ci.getCompilationUnit(), leaf);
            long treeEnd = ci.getTrees().getSourcePositions().getEndPosition(ci.getCompilationUnit(), leaf);
            if (treeStart != (long)start || treeEnd != (long)end) continue;
            return tp;
        }
        return null;
    }

    public void cancel() {
    }

    public int getPriority() {
        return 1000;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.CURSOR_SENSITIVE_TASK_SCHEDULER;
    }

    public static final class FactoryImpl
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            return Collections.singleton(new EvaluationSpanTask());
        }
    }
}

