/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.declarative.debugging;

import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.modules.java.hints.declarative.DeclarativeHintRegistry;
import org.netbeans.modules.java.hints.declarative.Utilities;
import org.netbeans.modules.java.hints.declarative.debugging.Bundle;
import org.netbeans.modules.java.hints.declarative.debugging.HintWrapper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class DebugTopComponent
extends TopComponent {
    private static final RequestProcessor WORKER = new RequestProcessor(DebugTopComponent.class.getName(), 1, false, false);
    private static DebugTopComponent instance;
    private static final String PREFERRED_ID = "DebugTopComponent";
    private JEditorPane code;
    private boolean initialized;
    private JScrollPane editorHolder;
    private JComboBox files;
    private Collection<? extends HintWrapper> hints = Collections.emptyList();
    private long openCount = 0L;

    public DebugTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(DebugTopComponent.class, (String)"CTL_DebugTopComponent"));
        this.setToolTipText(NbBundle.getMessage(DebugTopComponent.class, (String)"HINT_DebugTopComponent"));
        WORKER.post(new Runnable(){

            @Override
            public void run() {
                final EditorKit kit = (EditorKit)MimeLookup.getLookup((String)"text/x-javahints").lookup(EditorKit.class);
                if (kit instanceof Callable) {
                    try {
                        ((Callable)((Object)kit)).call();
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        DebugTopComponent.this.code = new JEditorPane();
                        DebugTopComponent.this.code.setContentType("text/x-javahints");
                        DebugTopComponent.this.code.setEditorKit(kit);
                        Document doc = DebugTopComponent.this.code.getEditorKit().createDefaultDocument();
                        doc.putProperty("mimeType", "text/x-javahints");
                        DebugTopComponent.this.code.setDocument(doc);
                        DebugTopComponent.this.editorHolder.setViewportView(DebugTopComponent.this.code);
                        DebugTopComponent.this.initialized = true;
                        DebugTopComponent debugTopComponent = DebugTopComponent.this;
                        synchronized (debugTopComponent) {
                            ((Object)((Object)DebugTopComponent.this)).notifyAll();
                        }
                    }
                });
            }
        });
    }

    private void initComponents() {
        this.files = new JComboBox();
        this.editorHolder = new JScrollPane();
        this.files.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.files.setRenderer(new FileRenderer());
        this.files.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebugTopComponent.this.filesActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.editorHolder).addComponent(this.files, 0, 376, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.files, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editorHolder, -1, 246, Short.MAX_VALUE).addContainerGap()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filesActionPerformed(ActionEvent evt) {
        DebugTopComponent debugTopComponent = this;
        synchronized (debugTopComponent) {
            Object selectedObj = this.files.getSelectedItem();
            if (!(selectedObj instanceof FileObject)) {
                return;
            }
            FileObject selected = (FileObject)selectedObj;
            String spec = Utilities.readFile(selected);
            this.code.setText(spec);
            try {
                Rectangle r = this.code.modelToView(0);
                if (r != null) {
                    this.code.scrollRectToVisible(r);
                }
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.hints = HintWrapper.parse(selected, spec);
        }
    }

    @NonNull
    public synchronized Collection<? extends HintWrapper> getHints() {
        return this.hints;
    }

    public synchronized Document getDocument() {
        while (!this.initialized) {
            try {
                ((Object)((Object)this)).wait();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DebugTopComponent.class.getName()).log(Level.FINE, null, ex);
            }
        }
        return this.code.getDocument();
    }

    public static synchronized DebugTopComponent getDefault() {
        if (instance == null) {
            instance = new DebugTopComponent();
        }
        return instance;
    }

    public static synchronized DebugTopComponent getExistingInstance() {
        return instance;
    }

    public static synchronized DebugTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(DebugTopComponent.class.getName()).warning("Cannot find DebugTopComponent component. It will not be located properly in the window system.");
            return DebugTopComponent.getDefault();
        }
        if (win instanceof DebugTopComponent) {
            return (DebugTopComponent)win;
        }
        Logger.getLogger(DebugTopComponent.class.getName()).warning("There seem to be multiple components with the 'DebugTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return DebugTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
        DefaultComboBoxModel<String> loadingModel = new DefaultComboBoxModel<String>();
        loadingModel.addElement(Bundle.DN_Loading());
        this.files.setModel(loadingModel);
        this.files.setSelectedIndex(0);
        final long startingCount = ++this.openCount;
        WORKER.post(new Runnable(){

            @Override
            public void run() {
                final DefaultComboBoxModel<FileObject> dlm = new DefaultComboBoxModel<FileObject>();
                for (FileObject fileObject : DeclarativeHintRegistry.findAllFiles()) {
                    dlm.addElement(fileObject);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (startingCount != DebugTopComponent.this.openCount) {
                            return;
                        }
                        DebugTopComponent.this.files.setModel(dlm);
                        if (dlm.getSize() > 0) {
                            DebugTopComponent.this.files.setSelectedIndex(0);
                        }
                    }
                });
            }
        });
    }

    public synchronized void componentClosed() {
        this.files.setModel(new DefaultComboBoxModel());
        if (this.code != null) {
            this.code.setText("");
        }
        this.hints = Collections.emptyList();
        this.initialized = false;
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    Object readProperties(Properties p) {
        if (instance == null) {
            instance = this;
        }
        instance.readPropertiesImpl(p);
        return instance;
    }

    private void readPropertiesImpl(Properties p) {
        String version = p.getProperty("version");
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    private static final class FileRenderer
    extends DefaultListCellRenderer {
        private FileRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof FileObject) {
                value = FileUtil.getFileDisplayName((FileObject)((FileObject)value));
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

