/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.declarative;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.hints.declarative.DeclarativeFix;
import org.netbeans.modules.java.hints.declarative.DeclarativeHintTokenId;
import org.netbeans.modules.java.hints.declarative.DeclarativeHintsParser;
import org.netbeans.modules.java.hints.declarative.DeclarativeHintsWorker;
import org.netbeans.modules.java.hints.declarative.Utilities;
import org.netbeans.modules.java.hints.providers.spi.ClassPathBasedHintProvider;
import org.netbeans.modules.java.hints.providers.spi.HintDescription;
import org.netbeans.modules.java.hints.providers.spi.HintDescriptionFactory;
import org.netbeans.modules.java.hints.providers.spi.HintMetadata;
import org.netbeans.modules.java.hints.providers.spi.HintProvider;
import org.netbeans.modules.java.hints.providers.spi.Trigger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class DeclarativeHintRegistry
implements HintProvider,
ClassPathBasedHintProvider {
    public Map<HintMetadata, Collection<? extends HintDescription>> computeHints() {
        return this.readHints(DeclarativeHintRegistry.findGlobalFiles());
    }

    public Collection<? extends HintDescription> computeHints(ClassPath cp) {
        return DeclarativeHintRegistry.join(this.readHints(DeclarativeHintRegistry.findFiles(cp)));
    }

    public static Collection<? extends HintDescription> join(Map<HintMetadata, Collection<? extends HintDescription>> hints) {
        LinkedList<? extends HintDescription> descs = new LinkedList<HintDescription>();
        for (Collection<? extends HintDescription> c : hints.values()) {
            descs.addAll(c);
        }
        return descs;
    }

    private Map<HintMetadata, Collection<? extends HintDescription>> readHints(Iterable<? extends FileObject> files) {
        HashMap<HintMetadata, Collection<? extends HintDescription>> result = new HashMap<HintMetadata, Collection<? extends HintDescription>>();
        for (FileObject fileObject : files) {
            result.putAll(DeclarativeHintRegistry.parseHintFile(fileObject));
        }
        return result;
    }

    public static Collection<? extends FileObject> findAllFiles() {
        LinkedList<Object> files = new LinkedList<Object>();
        files.addAll(DeclarativeHintRegistry.findGlobalFiles());
        files.addAll(DeclarativeHintRegistry.findFiles(GlobalPathRegistry.getDefault().getPaths("classpath/boot")));
        files.addAll(DeclarativeHintRegistry.findFiles(GlobalPathRegistry.getDefault().getPaths("classpath/compile")));
        files.addAll(DeclarativeHintRegistry.findFiles(GlobalPathRegistry.getDefault().getPaths("classpath/source")));
        return files;
    }

    private static Collection<? extends FileObject> findFiles(Iterable<? extends ClassPath> cps) {
        LinkedList<? extends FileObject> result = new LinkedList<FileObject>();
        for (ClassPath classPath : cps) {
            result.addAll(DeclarativeHintRegistry.findFiles(classPath));
        }
        return result;
    }

    private static Collection<? extends FileObject> findFiles(ClassPath cp) {
        LinkedList<? extends FileObject> result = new LinkedList<FileObject>();
        for (FileObject folder : cp.findAllResources("META-INF/upgrade")) {
            result.addAll(DeclarativeHintRegistry.findFiles(folder));
        }
        return result;
    }

    private static Collection<? extends FileObject> findGlobalFiles() {
        ArrayList<Object> result = new ArrayList<Object>();
        FileObject folder = FileUtil.getConfigFile((String)"org-netbeans-modules-java-hints/declarative");
        if (folder != null) {
            result.addAll(DeclarativeHintRegistry.findFilesRecursive(folder));
        }
        if ((folder = FileUtil.getConfigFile((String)"rules")) != null) {
            result.addAll(DeclarativeHintRegistry.findFilesRecursive(folder));
        }
        return result;
    }

    private static Collection<? extends FileObject> findFiles(FileObject folder) {
        LinkedList<FileObject> result = new LinkedList<FileObject>();
        for (FileObject f : folder.getChildren()) {
            if (!"hint".equals(f.getExt())) continue;
            result.add(f);
        }
        return result;
    }

    private static Collection<? extends FileObject> findFilesRecursive(FileObject folder) {
        LinkedList<FileObject> todo = new LinkedList<FileObject>();
        LinkedList<FileObject> result = new LinkedList<FileObject>();
        todo.add(folder);
        while (!todo.isEmpty()) {
            FileObject f = (FileObject)todo.remove(0);
            if (f.isFolder()) {
                todo.addAll(Arrays.asList(f.getChildren()));
                continue;
            }
            if (!"hint".equals(f.getExt())) continue;
            result.add(f);
        }
        return result;
    }

    public static Map<HintMetadata, Collection<? extends HintDescription>> parseHintFile(@NonNull FileObject file) {
        String spec = Utilities.readFile(file);
        return spec != null ? DeclarativeHintRegistry.parseHints(file, spec) : Collections.emptyMap();
    }

    public static Map<HintMetadata, Collection<? extends HintDescription>> parseHints(@NullAllowed FileObject file, String spec) {
        String primarySuppressWarningsKey;
        HintMetadata meta;
        ResourceBundle bundle;
        try {
            if (file != null) {
                URLClassLoader l = new URLClassLoader(new URL[]{file.getParent().getURL()});
                bundle = NbBundle.getBundle((String)"Bundle", (Locale)Locale.getDefault(), (ClassLoader)l);
            } else {
                bundle = null;
            }
        }
        catch (FileStateInvalidException ex) {
            bundle = null;
        }
        catch (MissingResourceException ex) {
            bundle = null;
        }
        TokenHierarchy h = TokenHierarchy.create((CharSequence)spec, DeclarativeHintTokenId.language());
        TokenSequence ts = h.tokenSequence(DeclarativeHintTokenId.language());
        LinkedHashMap<HintMetadata, List<Object>> result = new LinkedHashMap<HintMetadata, List<Object>>();
        DeclarativeHintsParser.Result parsed = new DeclarativeHintsParser().parse(file, spec, (TokenSequence<DeclarativeHintTokenId>)ts);
        String id = parsed.options.get("hint");
        String fallbackDisplayName = file != null ? file.getName() : null;
        String description = parsed.options.get("description");
        if (description == null) {
            description = fallbackDisplayName;
        }
        if (id == null && file != null) {
            id = file.getNameExt();
        }
        if (id != null) {
            String cat = parsed.options.get("hint-category");
            if (cat == null) {
                cat = "rules".equals(file.getParent().getName()) ? "custom" : "classpathbased";
            }
            String[] w = DeclarativeHintRegistry.suppressWarnings(parsed.options);
            meta = HintMetadata.Builder.create((String)id).setBundle(bundle, fallbackDisplayName, description).setCategory(cat).addSuppressWarnings(w).build();
            primarySuppressWarningsKey = w.length > 0 ? w[0] : null;
        } else {
            meta = null;
            primarySuppressWarningsKey = null;
        }
        int count = 0;
        for (DeclarativeHintsParser.HintTextDescription hint : parsed.hints) {
            String[] stringArray;
            String imports;
            HintDescriptionFactory f = HintDescriptionFactory.create();
            String displayName = DeclarativeHintRegistry.resolveDisplayName(file, bundle, hint.displayName, true, "TODO: No display name");
            Map<String, String> constraints = Utilities.conditions2Constraints(hint.conditions);
            String string = imports = parsed.importsBlock != null ? spec.substring(parsed.importsBlock[0], parsed.importsBlock[1]) : "";
            if (parsed.importsBlock != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = spec.substring(parsed.importsBlock[0], parsed.importsBlock[1]);
            } else {
                stringArray = new String[]{};
            }
            String[] importsArray = stringArray;
            f = f.setTrigger((Trigger)Trigger.PatternDescription.create((String)spec.substring(hint.textStart, hint.textEnd), constraints, (String[])importsArray));
            LinkedList<DeclarativeFix> fixes = new LinkedList<DeclarativeFix>();
            for (DeclarativeHintsParser.FixTextDescription fix : hint.fixes) {
                int[] fixRange = fix.fixSpan;
                String fixDisplayName = DeclarativeHintRegistry.resolveDisplayName(file, bundle, fix.displayName, false, null);
                HashMap<String, String> options = new HashMap<String, String>(parsed.options);
                options.putAll(fix.options);
                fixes.add(DeclarativeFix.create(fixDisplayName, spec.substring(fixRange[0], fixRange[1]), fix.conditions, options));
            }
            HintMetadata currentMeta = meta;
            if (currentMeta == null || hint.options.get("hint") != null) {
                String[] w = DeclarativeHintRegistry.suppressWarnings(hint.options);
                String currentId = hint.options.get("hint");
                String cat = parsed.options.get("hint-category");
                if (cat == null) {
                    cat = file != null && "rules".equals(file.getParent().getName()) ? "custom" : "general";
                }
                if (currentId != null) {
                    currentMeta = HintMetadata.Builder.create((String)currentId).setBundle(bundle).setCategory(cat).addSuppressWarnings(w).build();
                } else {
                    currentId = file != null ? file.getNameExt() + "-" + count : String.valueOf(count);
                    currentMeta = HintMetadata.Builder.create((String)currentId).setDescription(displayName, "No Description").setCategory(cat).addSuppressWarnings(w).build();
                }
                primarySuppressWarningsKey = w.length > 0 ? w[0] : null;
            }
            HashMap<String, String> options = new HashMap<String, String>(parsed.options);
            options.putAll(hint.options);
            f = f.setWorker((HintDescription.Worker)new DeclarativeHintsWorker(displayName, hint.conditions, imports, fixes, options, primarySuppressWarningsKey));
            f = f.setMetadata(currentMeta);
            f = f.setAdditionalConstraints(new HintDescription.AdditionalQueryConstraints(new HashSet<String>(constraints.values())));
            f = f.setHintText(spec.substring(hint.textStart, hint.hintEnd));
            LinkedList<HintDescription> hints = (LinkedList<HintDescription>)result.get(currentMeta);
            if (hints == null) {
                hints = new LinkedList<HintDescription>();
                result.put(currentMeta, hints);
            }
            if (fixes.isEmpty()) {
                f.addOptions(new HintMetadata.Options[]{HintMetadata.Options.QUERY});
            }
            hints.add(f.produce());
            ++count;
        }
        if (meta != null && result.isEmpty()) {
            result.put(meta, Collections.emptyList());
        }
        return new LinkedHashMap<HintMetadata, Collection<? extends HintDescription>>(result);
    }

    private static String[] suppressWarnings(Map<String, String> options) {
        String suppressWarnings = options.get("suppress-warnings");
        if (suppressWarnings != null) {
            return suppressWarnings.split(",");
        }
        return new String[0];
    }

    @NonNull
    private static String resolveDisplayName(@NonNull FileObject hintFile, @NullAllowed ResourceBundle bundle, String displayNameSpec, boolean fallbackToFileName, String def) {
        if (bundle != null) {
            if (displayNameSpec == null) {
                if (!fallbackToFileName) {
                    return def;
                }
                String dnKey = "DN_" + hintFile.getName();
                try {
                    return bundle.getString(dnKey);
                }
                catch (MissingResourceException e) {
                    Logger.getLogger(DeclarativeHintRegistry.class.getName()).log(Level.FINE, null, e);
                    return DeclarativeHintRegistry.fileDefaultDisplayName(hintFile, def);
                }
            }
            if (displayNameSpec.startsWith("#")) {
                String dnKey = "DN_" + displayNameSpec.substring(1);
                try {
                    return bundle.getString(dnKey);
                }
                catch (MissingResourceException e) {
                    Logger.getLogger(DeclarativeHintRegistry.class.getName()).log(Level.FINE, null, e);
                    return "XXX: missing display name key in the bundle (key=" + dnKey + ")";
                }
            }
        }
        return displayNameSpec != null ? displayNameSpec : (fallbackToFileName ? DeclarativeHintRegistry.fileDefaultDisplayName(hintFile, def) : def);
    }

    @NonNull
    private static String fileDefaultDisplayName(@NullAllowed FileObject hintFile, String def) {
        if (hintFile == null) {
            return def;
        }
        return hintFile.getName();
    }
}

