/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.declarative;

import com.sun.source.util.TreePath;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.declarative.APIAccessor;
import org.netbeans.modules.java.hints.declarative.Hacks;
import org.netbeans.modules.java.hints.declarative.MethodInvocationContext;
import org.netbeans.modules.java.hints.declarative.conditionapi.Context;

public abstract class Condition {
    public final boolean not;

    private Condition(boolean not) {
        this.not = not;
    }

    public abstract boolean holds(Context var1, boolean var2);

    public abstract String toString();

    public static final class False
    extends Condition {
        public False() {
            super(false);
        }

        @Override
        public boolean holds(Context ctx, boolean global) {
            return false;
        }

        @Override
        public String toString() {
            return "(FALSE)";
        }
    }

    public static final class Instanceof
    extends Condition {
        public final String variable;
        public final String constraint;
        public final int[] constraintSpan;

        public Instanceof(boolean not, String variable, String constraint, int[] constraintSpan) {
            super(not);
            this.variable = variable;
            this.constraint = constraint;
            this.constraintSpan = constraintSpan;
        }

        @Override
        public boolean holds(Context ctx, boolean global) {
            if (global && !this.not) {
                return true;
            }
            TreePath boundTo = APIAccessor.IMPL.getSingleVariable(ctx, ctx.variableForName(this.variable));
            CompilationInfo info = APIAccessor.IMPL.getHintContext(ctx).getInfo();
            TypeMirror realType = info.getTrees().getTypeMirror(boundTo);
            TypeMirror designedType = Hacks.parseFQNType(info, this.constraint);
            return this.not ^ info.getTypes().isSubtype(realType, designedType);
        }

        @Override
        public String toString() {
            return "(INSTANCEOF " + (this.not ? "!" : "") + this.variable + "/" + this.constraint + ")";
        }
    }

    public static final class MethodInvocation
    extends Condition {
        private final String methodName;
        private final Map<? extends String, ? extends ParameterKind> params;
        private final MethodInvocationContext mic;
        private final AtomicReference<Method> toCall = new AtomicReference();

        public MethodInvocation(boolean not, String methodName, Map<? extends String, ? extends ParameterKind> params, MethodInvocationContext mic) {
            super(not);
            this.methodName = methodName;
            this.params = params;
            this.mic = mic;
        }

        @Override
        public boolean holds(Context ctx, boolean global) {
            if (this.toCall.get() == null && !this.link()) {
                throw new IllegalStateException();
            }
            return this.mic.invokeMethod(ctx, this.toCall.get(), this.params) ^ this.not;
        }

        boolean link() {
            Method m = this.mic.linkMethod(this.methodName, this.params);
            this.toCall.set(m);
            return m != null;
        }

        @Override
        public String toString() {
            return "(METHOD_INVOCATION " + (this.not ? "!" : "") + ":" + this.methodName + "(" + this.params.toString() + "))";
        }

        public static enum ParameterKind {
            VARIABLE,
            STRING_LITERAL,
            ENUM_CONSTANT;

        }
    }

    public static final class Otherwise
    extends Condition {
        public Otherwise() {
            super(false);
        }

        @Override
        public boolean holds(Context ctx, boolean global) {
            return false;
        }

        @Override
        public String toString() {
            return "(OTHERWISE)";
        }
    }
}

