/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.legacy.spi;

import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.netbeans.modules.java.hints.providers.spi.HintDescription;
import org.netbeans.modules.java.hints.providers.spi.HintDescriptionFactory;
import org.netbeans.modules.java.hints.providers.spi.HintMetadata;
import org.netbeans.modules.java.hints.providers.spi.HintProvider;
import org.netbeans.modules.java.hints.providers.spi.Trigger;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.modules.java.hints.spi.Rule;
import org.netbeans.modules.java.hints.spi.TreeRule;
import org.netbeans.modules.java.hints.spiimpl.JavaFixImpl;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.java.hints.CustomizerProvider;
import org.netbeans.spi.java.hints.Hint;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.PositionBounds;
import org.openide.util.RequestProcessor;

public class RulesManager
implements FileChangeListener {
    public static Logger LOG = Logger.getLogger("org.netbeans.modules.java.hints");
    private static final String INSTANCE_EXT = ".instance";
    private static final String NON_GUI = "nonGUI";
    private static final String RULES_FOLDER = "org-netbeans-modules-java-hints/rules/";
    private static final String ERRORS = "errors";
    private static final String HINTS = "hints";
    private static final String SUGGESTIONS = "suggestions";
    private final Map<String, Map<String, List<ErrorRule>>> mimeType2Errors = new HashMap<String, Map<String, List<ErrorRule>>>();
    private final Map<HintMetadata, Collection<? extends HintDescription>> metadata = new HashMap<HintMetadata, Collection<? extends HintDescription>>();
    private static RulesManager INSTANCE;
    private final RequestProcessor.Task refreshHints = new RequestProcessor(RulesManager.class.getName()).create(new Runnable(){

        @Override
        public void run() {
            RulesManager.this.doInit();
        }
    });
    public static APIAccessor ACCESSOR;

    private RulesManager() {
        this.doInit();
    }

    public static synchronized RulesManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RulesManager();
        }
        return INSTANCE;
    }

    public synchronized Map<String, List<ErrorRule>> getErrors(String mimeType) {
        Map<String, List<ErrorRule<Object>>> res = this.mimeType2Errors.get(mimeType);
        if (res == null) {
            res = Collections.emptyMap();
        }
        return res;
    }

    private synchronized void doInit() {
        this.initErrors();
        this.initHints();
        this.initSuggestions();
    }

    private void initErrors() {
        FileObject folder = FileUtil.getConfigFile((String)"org-netbeans-modules-java-hints/rules/errors");
        List<Pair<Rule, FileObject>> rules = this.readRules(folder);
        RulesManager.categorizeErrorRules(rules, this.mimeType2Errors, folder);
    }

    private void initHints() {
        FileObject folder = FileUtil.getConfigFile((String)"org-netbeans-modules-java-hints/rules/hints");
        List<Pair<Rule, FileObject>> rules = this.readRules(folder);
        RulesManager.categorizeTreeRules(rules, Hint.Kind.INSPECTION, this.metadata);
    }

    private void initSuggestions() {
        FileObject folder = FileUtil.getConfigFile((String)"org-netbeans-modules-java-hints/rules/suggestions");
        List<Pair<Rule, FileObject>> rules = this.readRules(folder);
        RulesManager.categorizeTreeRules(rules, Hint.Kind.ACTION, this.metadata);
    }

    private List<Pair<Rule, FileObject>> readRules(FileObject folder) {
        LinkedList<Pair<Rule, FileObject>> rules = new LinkedList<Pair<Rule, FileObject>>();
        if (folder == null) {
            return rules;
        }
        LinkedList<FileObject> q = new LinkedList<FileObject>();
        q.offer(folder);
        while (!q.isEmpty()) {
            FileObject o = (FileObject)q.poll();
            o.removeFileChangeListener((FileChangeListener)this);
            o.addFileChangeListener((FileChangeListener)this);
            if (o.isFolder()) {
                q.addAll(Arrays.asList(o.getChildren()));
                continue;
            }
            if (!o.isData()) continue;
            String name = o.getNameExt().toLowerCase();
            if (!o.canRead()) continue;
            Rule r = null;
            if (name.endsWith(INSTANCE_EXT)) {
                r = RulesManager.instantiateRule(o);
            }
            if (r == null) continue;
            rules.add(new Pair<Rule, FileObject>(r, o));
        }
        return rules;
    }

    private static void categorizeErrorRules(List<Pair<Rule, FileObject>> rules, Map<String, Map<String, List<ErrorRule>>> dest, FileObject rootFolder) {
        dest.clear();
        for (Pair<Rule, FileObject> pair : rules) {
            Rule rule = pair.getA();
            FileObject fo = pair.getB();
            String mime = FileUtil.getRelativePath((FileObject)rootFolder, (FileObject)fo.getParent());
            if (mime.length() == 0) {
                mime = "text/x-java";
            }
            if (rule instanceof ErrorRule) {
                Map<String, List<ErrorRule>> map = dest.get(mime);
                if (map == null) {
                    map = new HashMap<String, List<ErrorRule>>();
                    dest.put(mime, map);
                }
                RulesManager.addRule((ErrorRule)rule, map);
                continue;
            }
            LOG.log(Level.WARNING, "The rule defined in " + fo.getPath() + "is not instance of ErrorRule");
        }
    }

    private static void categorizeTreeRules(List<Pair<Rule, FileObject>> rules, Hint.Kind kind, Map<HintMetadata, Collection<? extends HintDescription>> metadata) {
        for (Pair<Rule, FileObject> pair : rules) {
            Rule rule = pair.getA();
            FileObject fo = pair.getB();
            if (rule instanceof TreeRule) {
                TreeRule tr = (TreeRule)rule;
                Object nonGuiObject = fo.getAttribute(NON_GUI);
                boolean toGui = true;
                if (nonGuiObject != null && nonGuiObject instanceof Boolean && ((Boolean)nonGuiObject).booleanValue()) {
                    toGui = false;
                }
                FileObject parent = fo.getParent();
                HintMetadata.Builder hmb = HintMetadata.Builder.create((String)tr.getId()).setCategory(parent.getName()).setKind(kind);
                if (!toGui) {
                    hmb = hmb.addOptions(new HintMetadata.Options[]{HintMetadata.Options.NON_GUI});
                }
                if (rule instanceof AbstractHint) {
                    AbstractHint h = (AbstractHint)rule;
                    hmb = hmb.setDescription(toGui ? h.getDisplayName() : "", toGui ? h.getDescription() : "");
                    hmb = hmb.setEnabled(ACCESSOR.isEnabledDefault(h));
                    hmb = hmb.setSeverity(ACCESSOR.severiryDefault(h).toOfficialSeverity());
                    hmb = hmb.setCustomizerProvider((CustomizerProvider)new CustomizerProviderImpl(h));
                    hmb = hmb.addSuppressWarnings(ACCESSOR.getSuppressBy(h));
                    if (!ACCESSOR.isShowInTaskListDefault(h)) {
                        hmb = hmb.addOptions(new HintMetadata.Options[]{HintMetadata.Options.NO_BATCH});
                    } else if (h.getClass().getClassLoader() != RulesManager.class.getClassLoader()) {
                        hmb = hmb.addOptions(new HintMetadata.Options[]{HintMetadata.Options.QUERY});
                    }
                } else {
                    hmb = hmb.setDescription(toGui ? tr.getDisplayName() : "", toGui ? tr.getDisplayName() : "");
                    hmb = hmb.setSeverity(Severity.VERIFIER);
                }
                HintMetadata hm = hmb.build();
                LinkedList<HintDescription> hd = new LinkedList<HintDescription>();
                hd.add(HintDescriptionFactory.create().setTrigger((Trigger)new Trigger.Kinds(tr.getTreeKinds())).setMetadata(hm).setWorker((HintDescription.Worker)new WorkerImpl(tr)).produce());
                metadata.put(hm, hd);
                continue;
            }
            LOG.log(Level.WARNING, "The rule defined in " + fo.getPath() + "is not instance of TreeRule");
        }
    }

    private static void addRule(TreeRule rule, Map<Tree.Kind, List<TreeRule>> dest) {
        for (Tree.Kind kind : rule.getTreeKinds()) {
            List<TreeRule> l = dest.get((Object)kind);
            if (l == null) {
                l = new LinkedList<TreeRule>();
                dest.put(kind, l);
            }
            l.add(rule);
        }
    }

    private static void addRule(ErrorRule rule, Map<String, List<ErrorRule>> dest) {
        for (String code : rule.getCodes()) {
            List<ErrorRule> l = dest.get(code);
            if (l == null) {
                l = new LinkedList<ErrorRule>();
                dest.put(code, l);
            }
            l.add(rule);
        }
    }

    private static Rule instantiateRule(FileObject fileObject) {
        try {
            DataObject dobj = DataObject.find((FileObject)fileObject);
            InstanceCookie ic = (InstanceCookie)dobj.getCookie(InstanceCookie.class);
            Object instance = ic.instanceCreate();
            if (instance instanceof Rule) {
                return (Rule)instance;
            }
            return null;
        }
        catch (IOException e) {
            LOG.log(Level.INFO, null, e);
        }
        catch (ClassNotFoundException e) {
            LOG.log(Level.INFO, null, e);
        }
        return null;
    }

    public void fileFolderCreated(FileEvent fe) {
        this.hintsChanged();
    }

    public void fileDataCreated(FileEvent fe) {
        this.hintsChanged();
    }

    public void fileChanged(FileEvent fe) {
        this.hintsChanged();
    }

    public void fileDeleted(FileEvent fe) {
        this.hintsChanged();
    }

    public void fileRenamed(FileRenameEvent fe) {
        this.hintsChanged();
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
        this.hintsChanged();
    }

    private void hintsChanged() {
        this.refreshHints.cancel();
        this.refreshHints.schedule(50);
    }

    public static interface APIAccessor {
        public boolean isEnabledDefault(AbstractHint var1);

        public boolean isShowInTaskListDefault(AbstractHint var1);

        public AbstractHint.HintSeverity severiryDefault(AbstractHint var1);

        public String[] getSuppressBy(AbstractHint var1);
    }

    private static final class CustomizerProviderImpl
    implements CustomizerProvider {
        private final AbstractHint hint;

        public CustomizerProviderImpl(AbstractHint hint) {
            this.hint = hint;
        }

        public JComponent getCustomizer(Preferences prefs) {
            return this.hint.getCustomizer(prefs);
        }
    }

    public static final class HintProviderImpl
    implements HintProvider {
        public Map<HintMetadata, Collection<? extends HintDescription>> computeHints() {
            return RulesManager.getInstance().metadata;
        }
    }

    public static final class Pair<A, B> {
        private A a;
        private B b;

        public Pair(A a, B b) {
            this.a = a;
            this.b = b;
        }

        public A getA() {
            return this.a;
        }

        public B getB() {
            return this.b;
        }

        public String toString() {
            return "[" + String.valueOf(this.a) + "/" + String.valueOf(this.b) + "]";
        }
    }

    private static class WorkerImpl
    implements HintDescription.Worker {
        private final TreeRule tr;

        public WorkerImpl(TreeRule tr) {
            this.tr = tr;
        }

        public Collection<? extends ErrorDescription> createErrors(HintContext ctx) {
            List<ErrorDescription> result = this.tr.run(ctx.getInfo(), ctx.getPath());
            if (result == null) {
                return result;
            }
            LinkedList<ErrorDescription> wrapped = new LinkedList<ErrorDescription>();
            String id = this.tr instanceof AbstractHint ? ((AbstractHint)this.tr).getId() : "no-id";
            String description = this.tr instanceof AbstractHint ? ((AbstractHint)this.tr).getDescription() : null;
            for (ErrorDescription ed : result) {
                if (ed == null || ed.getRange() == null) continue;
                if (!ctx.getInfo().getFileObject().equals(ed.getFile())) {
                    LOG.log(Level.SEVERE, "Got an ErrorDescription for different file, current file: {0}, error's file: {1}", new Object[]{ctx.getInfo().getFileObject().toURI(), ed.getFile().toURI()});
                    continue;
                }
                List fixesForED = JavaFixImpl.Accessor.INSTANCE.resolveDefaultFixes(ctx, ed.getFixes().getFixes().toArray(new Fix[0]));
                ErrorDescription nue = ErrorDescriptionFactory.createErrorDescription((String)("text/x-java:" + id), (Severity)ed.getSeverity(), (String)ed.getDescription(), (CharSequence)description, (LazyFixList)ErrorDescriptionFactory.lazyListForFixes((List)fixesForED), (FileObject)ed.getFile(), (PositionBounds)ed.getRange());
                wrapped.add(nue);
            }
            return wrapped;
        }
    }
}

