/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.util.cache;

import com.sun.appserv.util.cache.CacheListener;
import com.sun.ejb.base.stats.StatefulSessionStoreMonitor;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.containers.util.cache.BaseCache;
import com.sun.ejb.containers.util.cache.LruCache;
import com.sun.ejb.spi.container.SFSBContainerCallback;
import com.sun.ejb.spi.container.StatefulEJBContext;
import com.sun.ejb.spi.stats.EJBCacheStatsProvider;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import javax.ejb.EJBException;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.util.SimpleMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LruSessionCache
extends LruCache
implements EJBCacheStatsProvider {
    protected int numActivated;
    protected int cacheIdleTimeoutInSeconds;
    protected int removalTimeoutInSeconds;
    protected Object loadCountLock = new Object();
    protected int loadFromBackupCount;
    protected boolean removeIfIdle = false;
    public int passivationCount = 0;
    protected Object passivationCountLock = new Object();
    private int numVictimsAccessed = 0;
    protected SFSBContainerCallback container;
    protected BackingStore<Serializable, SimpleMetadata> backingStore;
    private static final byte CACHE_ITEM_VALID = 0;
    private static final byte CACHE_ITEM_LOADING = 1;
    private static final byte CACHE_ITEM_REMOVED = 2;
    protected String configData;
    private static final int STATE_RUNNING = 0;
    private static final int STATE_SHUTTING_DOWN = 1;
    private static final int STATE_UNDEPLOYING = 2;
    private static final int STATE_DESTROYED = 3;
    private int currentCacheState = 0;
    protected int confMaxCacheSize = Integer.MAX_VALUE;

    @Override
    public void destroy() {
        this.currentCacheState = 3;
        this.container = null;
        super.destroy();
    }

    public LruSessionCache(String cacheName, SFSBContainerCallback container, int cacheIdleTime, int removalTime) {
        super.setCacheName(cacheName);
        this.container = container;
        this.cacheIdleTimeoutInSeconds = cacheIdleTime <= 0 ? 0 : cacheIdleTime;
        int n = this.removalTimeoutInSeconds = removalTime <= 0 ? 0 : removalTime;
        if (this.cacheIdleTimeoutInSeconds > 0) {
            this.timeout = (long)this.cacheIdleTimeoutInSeconds * 1000L;
        }
        this.removeIfIdle = this.removalTimeoutInSeconds > 0 && this.removalTimeoutInSeconds <= this.cacheIdleTimeoutInSeconds;
    }

    public void setBackingStore(BackingStore<Serializable, SimpleMetadata> store) {
        this.backingStore = store;
    }

    public void setStatefulSessionStoreMonitor(StatefulSessionStoreMonitor storeMonitor) {
    }

    @Override
    protected void trimItem(BaseCache.CacheItem item) {
        LruCache.LruCacheItem removed = (LruCache.LruCacheItem)item;
        if (this.removeIfIdle) {
            StatefulEJBContext ctx = (StatefulEJBContext)item.value;
            long idleThreshold = System.currentTimeMillis() - (long)this.removalTimeoutInSeconds * 1000L;
            if (ctx.getLastAccessTime() <= idleThreshold) {
                this.container.passivateEJB(ctx);
                return;
            }
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            CacheListener listener = (CacheListener)this.listeners.get(i);
            listener.trimEvent(removed.key, removed.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void itemAccessed(BaseCache.CacheItem item) {
        LruCache.LruCacheItem lc = (LruCache.LruCacheItem)item;
        LruSessionCache lruSessionCache = this;
        synchronized (lruSessionCache) {
            if (lc.isTrimmed) {
                lc.isTrimmed = false;
                ++this.numVictimsAccessed;
                BaseCache.CacheItem overflow = super.itemAdded(item);
                if (overflow != null) {
                    this.trimItem(overflow);
                }
            } else {
                super.itemAccessed(item);
            }
        }
    }

    public int getLoadFromBackupCount() {
        return this.loadFromBackupCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementLoadFromBackupCount() {
        Object object = this.loadCountLock;
        synchronized (object) {
            ++this.loadFromBackupCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public StatefulEJBContext lookupEJB(Serializable sessionKey, SFSBContainerCallback container, Object cookie) {
        Object value;
        block46: {
            LruSessionCacheItem lruSessionCacheItem;
            int hashCode = this.hash(sessionKey);
            int index = this.getIndex(hashCode);
            BaseCache.CacheItem item = null;
            LruSessionCacheItem newItem = null;
            value = null;
            Object object = this.bucketLocks[index];
            synchronized (object) {
                item = this.buckets[index];
                while (item != null) {
                    if (hashCode == item.hashCode && item.key.equals(sessionKey)) {
                        value = item.value;
                        break;
                    }
                    item = item.next;
                }
                if (value != null) {
                    this.itemAccessed(item);
                } else if (item == null) {
                    newItem = new LruSessionCacheItem(hashCode, sessionKey, null, -1, 1);
                    newItem.next = this.buckets[index];
                    this.buckets[index] = newItem;
                }
            }
            if (value != null) {
                this.incrementHitCount();
                return (StatefulEJBContext)value;
            }
            this.incrementMissCount();
            if (item != null) {
                object = item;
                synchronized (object) {
                    LruSessionCacheItem lruItem = (LruSessionCacheItem)item;
                    if (lruItem.value == null && lruItem.cacheItemState == 1) {
                        lruItem.waitCount = (byte)(lruItem.waitCount + 1);
                        try {
                            item.wait();
                        }
                        catch (InterruptedException inEx) {
                            // empty catch block
                        }
                    }
                    return (StatefulEJBContext)item.value;
                }
            }
            long activationStartTime = -1L;
            try {
                newItem.value = value = this.getStateFromStore(sessionKey, container);
                BaseCache.CacheItem inEx = this.buckets[index];
                synchronized (inEx) {
                    if (value == null) {
                        BaseCache.CacheItem prev = null;
                        BaseCache.CacheItem current = this.buckets[index];
                        while (current != null) {
                            if (current == newItem) {
                                if (prev == null) {
                                    this.buckets[index] = current.next;
                                } else {
                                    prev.next = current.next;
                                }
                                current.next = null;
                                break;
                            }
                            prev = current;
                            current = current.next;
                        }
                    } else {
                        container.activateEJB(sessionKey, (StatefulEJBContext)value, cookie);
                        BaseCache.CacheItem overflow = this.itemAdded(newItem);
                        this.incrementEntryCount();
                        if (overflow != null) {
                            this.trimItem(overflow);
                        }
                    }
                }
                Object var16_21 = null;
                lruSessionCacheItem = newItem;
            }
            catch (Throwable throwable) {
                Object var16_23 = null;
                LruSessionCacheItem lruSessionCacheItem2 = newItem;
                synchronized (lruSessionCacheItem2) {
                    newItem.cacheItemState = 0;
                    if (newItem.waitCount > 0) {
                        newItem.notifyAll();
                    }
                }
                if (activationStartTime != -1L) {
                    long timeSpent = System.currentTimeMillis() - activationStartTime;
                }
                throw throwable;
            }
            synchronized (lruSessionCacheItem) {
                newItem.cacheItemState = 0;
                if (newItem.waitCount > 0) {
                    newItem.notifyAll();
                }
            }
            if (activationStartTime != -1L) {
                long timeSpent = System.currentTimeMillis() - activationStartTime;
            }
            break block46;
            {
                catch (EJBException ejbEx) {
                    this.remove(sessionKey);
                    value = null;
                    Object var16_22 = null;
                    LruSessionCacheItem lruSessionCacheItem3 = newItem;
                    synchronized (lruSessionCacheItem3) {
                        newItem.cacheItemState = 0;
                        if (newItem.waitCount > 0) {
                            newItem.notifyAll();
                        }
                    }
                    if (activationStartTime != -1L) {
                        long timeSpent = System.currentTimeMillis() - activationStartTime;
                    }
                }
            }
        }
        return (StatefulEJBContext)value;
    }

    @Override
    public Object remove(Object sessionKey) {
        return this.remove(sessionKey, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object sessionKey, boolean removeFromStore) {
        int hashCode = this.hash(sessionKey);
        int index = this.getIndex(hashCode);
        BaseCache.CacheItem prev = null;
        BaseCache.CacheItem item = null;
        Object object = this.bucketLocks[index];
        synchronized (object) {
            item = this.buckets[index];
            while (item != null) {
                if (hashCode == item.hashCode && sessionKey.equals(item.key)) {
                    if (prev == null) {
                        this.buckets[index] = item.next;
                    } else {
                        prev.next = item.next;
                    }
                    item.next = null;
                    this.itemRemoved(item);
                    ((LruSessionCacheItem)item).cacheItemState = (byte)2;
                    break;
                }
                prev = item;
                item = item.next;
            }
            if (removeFromStore) {
                try {
                    this.backingStore.remove((Serializable)sessionKey);
                }
                catch (BackingStoreException sfsbEx) {
                    _logger.log(Level.WARNING, "[" + this.cacheName + "]: Exception in " + "backingStore.remove(" + sessionKey + ")", sfsbEx);
                }
            }
        }
        if (item != null) {
            this.decrementEntryCount();
            this.incrementRemovalCount();
            this.incrementHitCount();
        } else {
            this.incrementMissCount();
        }
        return null;
    }

    public boolean eligibleForRemovalFromCache(StatefulEJBContext ctx, Serializable sessionKey) {
        if (this.removeIfIdle) {
            long idleThreshold = System.currentTimeMillis() - (long)this.removalTimeoutInSeconds * 1000L;
            if (ctx.getLastAccessTime() <= idleThreshold) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, this.cacheName + ": Removing session " + " instead of passivating for key: " + sessionKey);
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean passivateEJB(StatefulEJBContext ctx, Serializable sessionKey) throws NotSerializableException {
        try {
            LruCache.LruCacheItem lruSCItem;
            int hashCode = this.hash(sessionKey);
            int index = this.getIndex(hashCode);
            BaseCache.CacheItem prev = null;
            BaseCache.CacheItem item = null;
            Object object = this.bucketLocks[index];
            synchronized (object) {
                item = this.buckets[index];
                while (item != null) {
                    if (item.value == ctx) {
                        lruSCItem = (LruCache.LruCacheItem)item;
                        if (lruSCItem.isTrimmed) break;
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, this.cacheName + ": session accessed after marked for passivation: " + sessionKey);
                        }
                        return false;
                    }
                    prev = item;
                    item = item.next;
                }
                if (item == null) {
                    return true;
                }
            }
            if (!this.saveStateToStore(sessionKey, ctx)) {
                return false;
            }
            object = this.bucketLocks[index];
            synchronized (object) {
                prev = null;
                item = this.buckets[index];
                while (item != null) {
                    if (item.value == ctx) {
                        lruSCItem = (LruCache.LruCacheItem)item;
                        if (!lruSCItem.isTrimmed) {
                            return false;
                        }
                        if (prev == null) {
                            this.buckets[index] = item.next;
                        } else {
                            prev.next = item.next;
                        }
                        item.next = null;
                        break;
                    }
                    prev = item;
                    item = item.next;
                }
            }
            if (item != null) {
                this.decrementEntryCount();
                this.incrementRemovalCount();
            }
            return true;
        }
        catch (NotSerializableException notSerEx) {
            throw notSerEx;
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "[" + this.cacheName + "]: passivateEJB(), Exception caught -> ", ex);
            return false;
        }
    }

    private Object getStateFromStore(Serializable sessionKey, SFSBContainerCallback container) {
        Object object = null;
        try {
            byte[] data;
            SimpleMetadata beanState = (SimpleMetadata)this.backingStore.load(sessionKey, null);
            byte[] byArray = data = beanState != null ? beanState.getState() : null;
            if (data == null) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, this.cacheName + ": Cannot load from " + " BACKUPSTORE FOR Key: <" + sessionKey + ">");
                }
            } else {
                this.incrementLoadFromBackupCount();
                object = EjbContainerUtilImpl.getInstance().getJavaEEIOUtils().deserializeObject(data, true, container.getClassLoader());
            }
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, this.cacheName + ": Exception while " + " loading from backup session: <" + sessionKey + ">", ex);
        }
        catch (Error ex) {
            _logger.log(Level.SEVERE, this.cacheName + ": Error while " + " loading from backup session: <" + sessionKey + ">", ex);
        }
        return object;
    }

    private boolean saveStateToStore(Serializable sessionKey, StatefulEJBContext ctx) throws NotSerializableException, IOException {
        byte[] data = EjbContainerUtilImpl.getInstance().getJavaEEIOUtils().serializeObject((Object)ctx.getSessionContext(), true);
        boolean status = false;
        if (data != null) {
            SimpleMetadata beanState = new SimpleMetadata(ctx.getVersion(), ctx.getLastAccessTime(), (long)this.removalTimeoutInSeconds * 1000L, data);
            beanState.setVersion(ctx.getVersion());
            try {
                this.backingStore.save(sessionKey, (Serializable)beanState, !ctx.existsInStore());
                status = true;
            }
            catch (BackingStoreException sfsbEx) {
                _logger.log(Level.WARNING, "[" + this.cacheName + "]: Exception during " + "backingStore.passivateSave(" + sessionKey + ")", sfsbEx);
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimSelectedVictims(ArrayList victims) {
        int sz = victims.size();
        LruSessionCache lruSessionCache = this;
        synchronized (lruSessionCache) {
            this.trimCount += sz;
        }
        BaseCache.CacheItem item = null;
        for (int i = 0; i < sz; ++i) {
            item = (BaseCache.CacheItem)victims.get(i);
            this.trimItem(item);
        }
    }

    public void setShutdownState() {
        this.currentCacheState = 1;
    }

    public void setUndeployedState() {
        this.currentCacheState = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator values() {
        ArrayList<StatefulEJBContext> valueList = new ArrayList<StatefulEJBContext>();
        LruSessionCache lruSessionCache = this;
        synchronized (lruSessionCache) {
            LruCache.LruCacheItem item = this.tail;
            while (item != null) {
                StatefulEJBContext ctx = (StatefulEJBContext)item.value;
                if (ctx != null) {
                    valueList.add(ctx);
                }
                if (item == this.head && item.lPrev != null) {
                    _logger.log(Level.WARNING, "[" + this.cacheName + "]: Iterator(), resetting head.lPrev");
                    item.lPrev = null;
                }
                item = item.lPrev;
            }
        }
        return valueList.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ArrayList<StatefulEJBContext> valueList = new ArrayList<StatefulEJBContext>();
        LruSessionCache lruSessionCache = this;
        synchronized (lruSessionCache) {
            LruCache.LruCacheItem item = this.tail;
            while (item != null) {
                StatefulEJBContext ctx = (StatefulEJBContext)item.value;
                if (ctx != null) {
                    item.isTrimmed = true;
                    valueList.add(ctx);
                }
                if (item == this.head && item.lPrev != null) {
                    _logger.log(Level.WARNING, "[" + this.cacheName + "]: Iterator(), resetting head.lPrev");
                    item.lPrev = null;
                }
                item = item.lPrev;
            }
        }
        for (StatefulEJBContext ctx : valueList) {
            this.container.passivateEJB(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimTimedoutItems(int maxTrimCount) {
        int count = 0;
        long currentTime = System.currentTimeMillis();
        long idleThresholdTime = currentTime - (long)this.cacheIdleTimeoutInSeconds * 1000L;
        ArrayList<LruCache.LruCacheItem> victimList = new ArrayList<LruCache.LruCacheItem>();
        LruSessionCache lruSessionCache = this;
        synchronized (lruSessionCache) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "[" + this.cacheName + "]: TrimTimedoutBeans started...");
            }
            if (this.tail == null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "[" + this.cacheName + "]: TrimTimedoutBeans " + " finished after removing 0 idle beans");
                }
                this.head = null;
                return;
            }
            LruCache.LruCacheItem item = this.tail;
            while (true) {
                if (this.currentCacheState != 0) {
                    _logger.log(Level.WARNING, "[" + this.cacheName + "]: Exiting TrimTimedoutBeans() because " + "current cache state: " + this.currentCacheState);
                    break;
                }
                StatefulEJBContext ctx = (StatefulEJBContext)item.value;
                if (ctx != null) {
                    if (ctx.getLastAccessTime() > idleThresholdTime || !ctx.canBePassivated()) break;
                    item.isTrimmed = true;
                    victimList.add(item);
                }
                if (item == this.head && item.lPrev != null) {
                    _logger.log(Level.WARNING, "[" + this.cacheName + "]: TrimTimedoutBeans(), resetting head.lPrev");
                    item.lPrev = null;
                }
                if ((item = item.lPrev) == null) break;
                item.lNext.lPrev = null;
                item.lNext.lNext = null;
                item.lNext = null;
            }
            if (item == this.tail) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "[" + this.cacheName + "]: TrimTimedoutBeans " + " finished after removing 0 idle beans");
                }
                return;
            }
            if (item == null) {
                this.head = null;
            }
            this.tail = item;
            count = victimList.size();
            this.listSize -= count;
            this.trimCount += count;
        }
        for (int idx = 0; idx < count; ++idx) {
            this.trimItem((LruCache.LruCacheItem)victimList.get(idx));
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "[" + this.cacheName + "]: TrimTimedoutBeans " + " finished after removing " + count + " idle beans");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimUnSortedTimedoutItems(int maxCount) {
        int maxIndex = this.buckets.length;
        long idleThreshold = System.currentTimeMillis() - this.timeout;
        ArrayList<LruCache.LruCacheItem> victims = new ArrayList<LruCache.LruCacheItem>();
        int sz = 0;
        int totalSize = 0;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "[" + this.cacheName + "]: TrimUnsortedTimedoutBeans started...");
        }
        for (int index = 0; index < maxIndex; ++index) {
            if (this.buckets[index] == null) continue;
            Object object = this.bucketLocks[index];
            synchronized (object) {
                BaseCache.CacheItem item = this.buckets[index];
                while (item != null) {
                    StatefulEJBContext ctx = (StatefulEJBContext)item.value;
                    if (ctx != null && ctx.getLastAccessTime() <= idleThreshold && ctx.canBePassivated()) {
                        LruCache.LruCacheItem litem = (LruCache.LruCacheItem)item;
                        LruSessionCache lruSessionCache = this;
                        synchronized (lruSessionCache) {
                            if (this.currentCacheState != 0) {
                                _logger.log(Level.WARNING, "[" + this.cacheName + "]: Exiting TrimUnSortedTimedoutBeans() " + "because current cache state: " + this.currentCacheState);
                                break;
                            }
                            if (!litem.isTrimmed) {
                                this.itemRemoved(litem);
                                litem.isTrimmed = true;
                                victims.add(litem);
                            }
                        }
                    }
                    item = item.next;
                }
            }
            sz = victims.size();
            if (sz < this.container.getPassivationBatchCount()) continue;
            this.trimSelectedVictims(victims);
            totalSize += sz;
            victims.clear();
        }
        sz = victims.size();
        if (sz > 0) {
            this.trimSelectedVictims(victims);
            totalSize += sz;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "[" + this.cacheName + "]: TrimUnsortedTimedoutBeans " + " finished after removing " + totalSize + " idle beans");
        }
    }

    public int getNumVictimsAccessed() {
        return this.numVictimsAccessed;
    }

    @Override
    protected BaseCache.CacheItem createItem(int hashCode, Object sessionKey, Object value, int size) {
        return new LruSessionCacheItem(hashCode, sessionKey, value, size);
    }

    public void setConfigData(String configData) {
        this.configData = configData;
    }

    @Override
    public void appendStats(StringBuffer sbuf) {
        sbuf.append("[Cache: ").append("Size=").append(this.entryCount).append("; ").append("HitCount=").append(this.hitCount).append("; ").append("MissCount=").append(this.missCount).append("; ").append("Passivations=").append(this.getNumPassivations()).append("; ");
        if (this.configData != null) {
            sbuf.append(this.configData);
        }
        sbuf.append("]");
    }

    @Override
    public int getCacheHits() {
        return this.hitCount;
    }

    @Override
    public int getCacheMisses() {
        return this.missCount;
    }

    @Override
    public int getNumBeansInCache() {
        return this.entryCount;
    }

    @Override
    public int getNumExpiredSessionsRemoved() {
        return 0;
    }

    @Override
    public int getNumPassivationErrors() {
        return 0;
    }

    @Override
    public int getNumPassivations() {
        return 0;
    }

    @Override
    public int getNumPassivationSuccess() {
        return 0;
    }

    public void setMaxCacheSize(int val) {
        this.confMaxCacheSize = val;
    }

    @Override
    public int getMaxCacheSize() {
        return this.confMaxCacheSize;
    }

    protected static class LruSessionCacheItem
    extends LruCache.LruCacheItem {
        protected byte waitCount;
        protected byte cacheItemState = 0;

        protected LruSessionCacheItem(int hashCode, Object key, Object value, int size) {
            super(hashCode, key, value, size);
            this.cacheItemState = 0;
        }

        protected LruSessionCacheItem(int hashCode, Object key, Object value, int size, byte state) {
            super(hashCode, key, value, size);
            this.cacheItemState = state;
        }
    }
}

