/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.debugger;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.Collator;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.AntTargetExecutor;
import org.apache.tools.ant.module.api.support.TargetLister;
import org.netbeans.modules.ant.debugger.AdvancedActionPanel;
import org.netbeans.modules.ant.debugger.DebuggerAntLogger;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.execution.ExecutorTask;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public final class RunTargetsAction
extends SystemAction
implements ContextAwareAction {
    public String getName() {
        return NbBundle.getMessage(RunTargetsAction.class, (String)"LBL_run_targets_action");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void actionPerformed(ActionEvent e) {
        assert (false) : "Action should never be called without a context";
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new ContextAction(actionContext);
    }

    private static JMenu createMenu(AntProjectCookie project) {
        return new LazyMenu(project);
    }

    private static final class AdvancedAction
    extends AbstractAction {
        private final AntProjectCookie project;
        private final Set allTargets;

        public AdvancedAction(AntProjectCookie project, Set allTargets) {
            super(NbBundle.getMessage(RunTargetsAction.class, (String)"LBL_run_advanced"));
            this.project = project;
            this.allTargets = allTargets;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String title = NbBundle.getMessage(RunTargetsAction.class, (String)"TITLE_run_advanced");
            AdvancedActionPanel panel = new AdvancedActionPanel(this.project, this.allTargets);
            DialogDescriptor dd = new DialogDescriptor((Object)panel, title);
            dd.setOptionType(2);
            JButton run = new JButton(NbBundle.getMessage(RunTargetsAction.class, (String)"LBL_run_advanced_run"));
            run.setDefaultCapable(true);
            JButton cancel = new JButton(NbBundle.getMessage(RunTargetsAction.class, (String)"LBL_run_advanced_cancel"));
            dd.setOptions(new Object[]{run, cancel});
            dd.setModal(true);
            Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            if (result.equals(run)) {
                try {
                    panel.run();
                }
                catch (IOException x) {
                    AntModule.err.notify((Throwable)x);
                }
            }
        }
    }

    private static final class ContextAction
    extends AbstractAction
    implements Presenter.Popup {
        private final AntProjectCookie project;

        public ContextAction(Lookup lkp) {
            super(((RunTargetsAction)SystemAction.get(RunTargetsAction.class)).getName());
            Collection apcs = lkp.lookupAll(AntProjectCookie.class);
            AntProjectCookie _project = null;
            if (apcs.size() == 1 && (_project = (AntProjectCookie)apcs.iterator().next()).getParseException() != null) {
                _project = null;
            }
            this.project = _project;
            super.setEnabled(this.project != null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            assert (false) : "Action should not be called directly";
        }

        public JMenuItem getPopupPresenter() {
            if (this.project != null) {
                return RunTargetsAction.createMenu(this.project);
            }
            return new Actions.MenuItem((Action)this, false);
        }

        @Override
        public void setEnabled(boolean b) {
            assert (false) : "No modifications to enablement status permitted";
        }
    }

    private static final class LazyMenu
    extends JMenu {
        private final AntProjectCookie project;
        private boolean initialized = false;

        public LazyMenu(AntProjectCookie project) {
            super(((RunTargetsAction)SystemAction.get(RunTargetsAction.class)).getName());
            this.project = project;
        }

        @Override
        public JPopupMenu getPopupMenu() {
            if (!this.initialized) {
                Set allTargets;
                this.initialized = true;
                try {
                    allTargets = TargetLister.getTargets((AntProjectCookie)this.project);
                }
                catch (IOException e) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)e.getLocalizedMessage()));
                    allTargets = Collections.EMPTY_SET;
                }
                String defaultTarget = null;
                TreeSet<Object> describedTargets = new TreeSet<Object>(Collator.getInstance());
                TreeSet<Object> otherTargets = new TreeSet<Object>(Collator.getInstance());
                for (TargetLister.Target t : allTargets) {
                    if (t.isOverridden() || t.isInternal()) continue;
                    String string = t.getName();
                    if (t.isDefault()) {
                        defaultTarget = string;
                        continue;
                    }
                    if (t.isDescribed()) {
                        describedTargets.add(string);
                        continue;
                    }
                    otherTargets.add(string);
                }
                boolean needsep = false;
                if (defaultTarget != null) {
                    needsep = true;
                    JMenuItem jMenuItem = new JMenuItem(defaultTarget);
                    jMenuItem.addActionListener(new TargetMenuItemHandler(this.project, defaultTarget));
                    this.add(jMenuItem);
                }
                if (needsep) {
                    needsep = false;
                    this.addSeparator();
                }
                if (!describedTargets.isEmpty()) {
                    needsep = true;
                    for (String string : describedTargets) {
                        JMenuItem jMenuItem = new JMenuItem(string);
                        jMenuItem.addActionListener(new TargetMenuItemHandler(this.project, string));
                        this.add(jMenuItem);
                    }
                }
                if (needsep) {
                    needsep = false;
                    this.addSeparator();
                }
                if (!otherTargets.isEmpty()) {
                    needsep = true;
                    JMenu jMenu = new JMenu(NbBundle.getMessage(RunTargetsAction.class, (String)"LBL_run_other_targets"));
                    for (String string : otherTargets) {
                        JMenuItem menuitem = new JMenuItem(string);
                        menuitem.addActionListener(new TargetMenuItemHandler(this.project, string));
                        jMenu.add(menuitem);
                    }
                    this.add(jMenu);
                }
                if (needsep) {
                    needsep = false;
                    this.addSeparator();
                }
                this.add(new AdvancedAction(this.project, allTargets));
            }
            return super.getPopupMenu();
        }
    }

    static final class TargetMenuItemHandler
    implements ActionListener,
    Runnable {
        private final AntProjectCookie project;
        private final String target;

        public TargetMenuItemHandler(AntProjectCookie project, String target) {
            this.project = project;
            this.target = target;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            RequestProcessor.getDefault().post((Runnable)this);
        }

        @Override
        public void run() {
            try {
                DebuggerAntLogger.getDefault().debugFile(this.project.getFile());
                AntTargetExecutor.Env env = new AntTargetExecutor.Env();
                AntTargetExecutor executor = AntTargetExecutor.createTargetExecutor((AntTargetExecutor.Env)env);
                ExecutorTask executorTask = executor.execute(this.project, new String[]{this.target});
                DebuggerAntLogger.getDefault().fileExecutor(this.project.getFile(), executorTask);
            }
            catch (IOException ioe) {
                AntModule.err.notify((Throwable)ioe);
            }
        }
    }
}

