/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.debugger;

import java.io.IOException;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import org.netbeans.modules.ant.debugger.Utils;
import org.openide.awt.StatusDisplayer;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class IOManager {
    protected InputOutput debuggerIO = null;
    private OutputWriter debuggerOut;
    private String name;
    private boolean closed = false;
    private Hashtable lines = new Hashtable();
    private Listener listener = new Listener();
    private final LinkedList buffer = new LinkedList();
    private RequestProcessor.Task task;

    public IOManager(String title) {
        this.debuggerIO = IOProvider.getDefault().getIO(title, true);
        this.debuggerIO.setFocusTaken(false);
        this.debuggerOut = this.debuggerIO.getOut();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String text, Object line) {
        if (text == null) {
            throw new NullPointerException();
        }
        LinkedList linkedList = this.buffer;
        synchronized (linkedList) {
            this.buffer.addLast(new Text(text, line));
        }
        if (this.task == null) {
            this.task = RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    LinkedList linkedList = IOManager.this.buffer;
                    synchronized (linkedList) {
                        int k = IOManager.this.buffer.size();
                        for (int i = 0; i < k; ++i) {
                            Text t = (Text)IOManager.this.buffer.removeFirst();
                            try {
                                if (t.line != null) {
                                    IOManager.this.debuggerOut.println(t.text, (OutputListener)IOManager.this.listener);
                                    IOManager.this.lines.put(t.text, t.line);
                                } else {
                                    IOManager.this.debuggerOut.println(t.text);
                                }
                                IOManager.this.debuggerOut.flush();
                                if (IOManager.this.closed) {
                                    IOManager.this.debuggerOut.close();
                                }
                                StatusDisplayer.getDefault().setStatusText(t.text);
                                continue;
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                }
            }, 100, 1);
        } else {
            this.task.schedule(100);
        }
    }

    void closeStream() {
        this.debuggerOut.close();
        this.closed = true;
        this.close();
    }

    void close() {
        this.debuggerIO.closeInputOutput();
    }

    private class Listener
    implements OutputListener {
        private Listener() {
        }

        public void outputLineSelected(OutputEvent ev) {
        }

        public void outputLineAction(final OutputEvent ev) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String t = ev.getLine();
                    Object a = IOManager.this.lines.get(t);
                    if (a == null) {
                        return;
                    }
                    Utils.showLine(a);
                }
            });
        }

        public void outputLineCleared(OutputEvent ev) {
            IOManager.this.lines = new Hashtable();
        }
    }

    private static class Text {
        private String text;
        private Object line;

        private Text(String text, Object line) {
            this.text = text;
            this.line = line;
        }
    }
}

