/*
 * Decompiled with CFR 0.152.
 */
package br.com.autbank.jndi;

import br.com.autbank.criptografia.AESCripto;
import br.com.autbank.criptografia.ManipulaArquivo;
import java.io.File;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import org.enhydra.jdbc.pool.StandardXAPoolDataSource;
import org.enhydra.jdbc.standard.StandardXADataSource;
import org.enhydra.jdbc.sybase.SybaseXADataSource;
import org.objectweb.jotm.Jotm;
import org.objectweb.transaction.jta.TMService;

public class DataSourceFactory
implements ObjectFactory {
    public static TMService jotm;

    public Object getObjectInstance(Object obj, Name n, Context nameCtx, Hashtable environment) throws Exception {
        String usuario;
        String value;
        Reference ref = (Reference)obj;
        String driverJdbc = (String)ref.get("driverClassName").getContent();
        StandardXAPoolDataSource xads = null;
        Object ds = null;
        String sqlTest = null;
        if (driverJdbc.equals("net.sourceforge.jtds.jdbc.Driver") || driverJdbc.endsWith("net.sourceforge.jtds.jdbcx.JtdsDataSource")) {
            String url = (String)ref.get("url").getContent();
            ds = url.indexOf("sybase") > 0 ? new SybaseXADataSource() : new StandardXADataSource();
            sqlTest = "select 1";
        } else if (driverJdbc.endsWith("SybDriver")) {
            ds = new SybaseXADataSource();
            sqlTest = "select 1";
        } else if (driverJdbc.endsWith("OracleDriver")) {
            ds = new StandardXADataSource();
            sqlTest = "";
        } else {
            ds = new StandardXADataSource();
            sqlTest = "select 1";
        }
        ds.setVerbose(true);
        ds.setDebug(true);
        xads = new StandardXAPoolDataSource((StandardXADataSource)ds);
        xads.setCheckLevelObject(1);
        xads.setJdbcTestStmt(sqlTest);
        xads.setMinSize(0);
        xads.setDebug(true);
        ds.setDriverName(driverJdbc);
        ds.setUrl((String)ref.get("url").getContent());
        try {
            value = (String)ref.get("maxSize").getContent();
            xads.setMaxSize(Integer.parseInt(value));
        }
        catch (Throwable t) {
            xads.setMaxSize(100);
        }
        try {
            if (driverJdbc.endsWith("OracleDriver")) {
                xads.setCheckLevelObject(1);
            } else {
                value = (String)ref.get("checkLevelObject").getContent();
                xads.setCheckLevelObject(Integer.parseInt(value));
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            value = (String)ref.get("setLifeTime").getContent();
            xads.setLifeTime((long)Integer.parseInt(value));
        }
        catch (Throwable t) {
            xads.setLifeTime(300000L);
        }
        try {
            value = (String)ref.get("deadLockMaxWait").getContent();
            xads.setDeadLockMaxWait((long)Integer.parseInt(value));
        }
        catch (Throwable t) {
            xads.setDeadLockMaxWait(180000L);
        }
        String propfile = this.calcularCaminhoArquivoSeguranca();
        String textoCodificado = ManipulaArquivo.consArqSeg(propfile);
        AESCripto aes = new AESCripto();
        String textoDecodificado = aes.decodificaTexto(textoCodificado);
        String sistema = n.toString();
        xads.user = usuario = ManipulaArquivo.consUsuario(textoDecodificado.trim(), sistema);
        ds.setUser(usuario);
        String senha = ManipulaArquivo.consSenha(textoDecodificado.trim(), sistema);
        ds.setPassword(senha);
        xads.password = senha;
        xads.setTransactionManager((TransactionManager)jotm.getTransactionManager());
        xads.setDataSource((XADataSource)ds);
        return xads;
    }

    private String calcularCaminhoArquivoSeguranca() {
        String caminhoArquivo;
        String fileSeparator = System.getProperty("file.separator");
        String cactrlj = "cactrlj.dat";
        if (System.getProperty("autbank.home") != null && this.existeArquivo(caminhoArquivo = System.getProperty("autbank.home") + fileSeparator + cactrlj)) {
            return caminhoArquivo;
        }
        if (System.getProperty("catalina.home") != null && this.existeArquivo(caminhoArquivo = System.getProperty("catalina.home") + fileSeparator + "webapps" + fileSeparator + "autbank" + fileSeparator + cactrlj)) {
            return caminhoArquivo;
        }
        if (this.existeArquivo(cactrlj)) {
            return cactrlj;
        }
        throw new RuntimeException("CA: Arquivo de seguranca nao encontrado.");
    }

    private boolean existeArquivo(String arquivo) {
        File file = new File(arquivo);
        return file.exists();
    }

    static {
        try {
            jotm = new Jotm(true, false);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }
}

