/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.util.LocalStringManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.appclient.client.acc.ACCModulesManager;

public class Util {
    private static Class thisClass = Util.class;
    private static final LocalStringManager localStrings = new LocalStringManagerImpl(thisClass);
    private static final String SLASH_REPLACEMENT = Matcher.quoteReplacement("\\\\");
    private static final String DOLLAR_REPLACEMENT = Matcher.quoteReplacement("\\$");
    private static final Pattern TOKEN_SUBSTITUTION = Pattern.compile("\\$\\{([^\\}]*)\\}");

    public static File verifyFilePath(String filePath) throws FileNotFoundException, IOException {
        File f = new File(filePath);
        if (!f.exists()) {
            throw new FileNotFoundException(f.getAbsolutePath());
        }
        if (!f.canRead()) {
            String msg = localStrings.getLocalString(thisClass, "appclient.notReadable", "{0} is not a readable file", new Object[]{f.getAbsolutePath()});
            throw new IOException(msg);
        }
        return f;
    }

    static File verifyNonDirectoryFilePath(String filePath) throws FileNotFoundException, IOException {
        File f = Util.verifyFilePath(filePath);
        if (!f.isFile()) {
            String msg = localStrings.getLocalString(thisClass, "appclient.isDir", "{0} is a directory; it must be a readable non-directory file", new Object[]{f.getAbsolutePath()});
            throw new IOException(msg);
        }
        return f;
    }

    public static ArchiveFactory getArchiveFactory() {
        return ACCModulesManager.getComponent(ArchiveFactory.class);
    }

    public static ArchivistFactory getArchivistFactory() {
        return ACCModulesManager.getComponent(ArchivistFactory.class);
    }

    public static URI getURI(String s) throws URISyntaxException {
        return Util.getURI(new File(s));
    }

    public static URI getURI(File f) throws URISyntaxException {
        return f.toURI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeTextToTempFile(String content, String prefix, String suffix, boolean retainTempFiles) throws IOException, FileNotFoundException {
        BufferedWriter wtr = null;
        try {
            File result = File.createTempFile(prefix, suffix);
            if (!retainTempFiles) {
                result.deleteOnExit();
            }
            FileOutputStream fos = new FileOutputStream(result);
            wtr = new BufferedWriter(new OutputStreamWriter(fos));
            wtr.write(content);
            wtr.close();
            File file = result;
            return file;
        }
        finally {
            if (wtr != null) {
                wtr.close();
            }
        }
    }

    public static String replaceTokens(String s, Properties values) {
        Matcher m = TOKEN_SUBSTITUTION.matcher(s);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String propertyName = m.group(1);
            String propertyValue = values.getProperty(propertyName);
            if (propertyValue == null) continue;
            String adjustedPropertyValue = propertyValue.replaceAll("\\\\", SLASH_REPLACEMENT).replaceAll("\\$", DOLLAR_REPLACEMENT);
            String x = s.substring(m.start(), m.end());
            try {
                m.appendReplacement(sb, adjustedPropertyValue);
            }
            catch (IllegalArgumentException iae) {
                System.err.println("**** appendReplacement failed: segment is " + x + "; original replacement was " + propertyValue + " and adj. replacement is " + adjustedPropertyValue + "; exc follows");
                throw iae;
            }
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String toXMLEscaped(String content) {
        return content.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;");
    }
}

