/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.metro.model.ui;

import com.sun.xml.ws.runtime.config.TubeFactoryConfig;
import com.sun.xml.ws.runtime.config.TubeFactoryList;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.metro.model.ui.TubesProjectConfigPanel;
import org.netbeans.modules.websvc.wsitconf.ui.ClassDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class TubesConfigPanel
extends JPanel {
    private Project project;
    private TubeFactoryList tubeList;
    private boolean isChanged;
    private boolean client;
    private boolean overrideDefaults;
    private JButton addBtn;
    private JButton downBtn;
    private JScrollPane jScrollPane2;
    private JCheckBox overrideDefChBox;
    private JButton removeBtn;
    private JTable tubeTable;
    private DefaultTableModel tubeTableModel;
    private JButton upBtn;

    public TubesConfigPanel(Project project, TubeFactoryList tubeFactoryList, boolean bl, boolean bl2) {
        this.project = project;
        this.client = bl;
        this.tubeList = tubeFactoryList;
        this.overrideDefaults = bl2;
        this.initComponents();
        this.populateValues();
        this.addBtn.addActionListener(new AddButtonActionListener());
        this.removeBtn.addActionListener(new RemoveButtonActionListener());
        this.isChanged = false;
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public boolean isOverride() {
        return this.overrideDefChBox.isSelected();
    }

    public List<String> getTubeList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.tubeTableModel.getRowCount(); ++i) {
            arrayList.add((String)this.tubeTableModel.getValueAt(i, 0));
        }
        return arrayList;
    }

    private void populateValues() {
        this.overrideDefChBox.setSelected(this.overrideDefaults);
        List<TubeFactoryConfig> list = this.tubeList.getTubeFactoryConfigs();
        for (TubeFactoryConfig tubeFactoryConfig : list) {
            this.tubeTableModel.addRow(new Object[]{tubeFactoryConfig.getClassName()});
        }
        if (this.tubeTableModel.getRowCount() > 0) {
            this.tubeTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.enableDisable();
    }

    private void initComponents() {
        this.addBtn = new JButton();
        this.removeBtn = new JButton();
        this.upBtn = new JButton();
        this.downBtn = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.tubeTable = new TubeTable();
        this.overrideDefChBox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.addBtn, (String)NbBundle.getMessage(TubesConfigPanel.class, (String)"LBL_Add"));
        this.addBtn.setToolTipText(NbBundle.getMessage(TubesConfigPanel.class, (String)"HINT_Add"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeBtn, (String)NbBundle.getMessage(TubesConfigPanel.class, (String)"LBL_Remove"));
        this.removeBtn.setToolTipText(NbBundle.getMessage(TubesConfigPanel.class, (String)"HINT_Remove"));
        Mnemonics.setLocalizedText((AbstractButton)this.upBtn, (String)NbBundle.getMessage(TubesConfigPanel.class, (String)"LBL_Move_Up"));
        this.upBtn.setToolTipText(NbBundle.getMessage(TubesConfigPanel.class, (String)"HINT_Move_Up"));
        this.upBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TubesConfigPanel.this.moveUpHandler(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.downBtn, (String)NbBundle.getMessage(TubesConfigPanel.class, (String)"LBL_Move_Down"));
        this.downBtn.setToolTipText(NbBundle.getMessage(TubesConfigPanel.class, (String)"HINT_Move_Down"));
        this.downBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TubesConfigPanel.this.moveDownHandler(actionEvent);
            }
        });
        this.tubeTableModel = new TubeTableModel(new String[]{NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"HEADING_TUBES")}, 0);
        this.tubeTable.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.tubeTable.setModel(this.tubeTableModel);
        this.jScrollPane2.setViewportView(this.tubeTable);
        this.tubeTable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TubesConfigPanel.class, (String)"ACSD_MessageHandlerTable"));
        this.tubeTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TubesConfigPanel.class, (String)"ACSD_MessageHandlerTable"));
        Mnemonics.setLocalizedText((AbstractButton)this.overrideDefChBox, (String)NbBundle.getMessage(TubesConfigPanel.class, (String)"LBL_OverrideDefaults"));
        this.overrideDefChBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TubesConfigPanel.this.overrideDefChBoxActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jScrollPane2, -1, 332, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addBtn, -1, 190, Short.MAX_VALUE).addComponent(this.upBtn, -1, 190, Short.MAX_VALUE).addComponent(this.removeBtn, -1, 190, Short.MAX_VALUE).addComponent(this.downBtn, -1, 190, Short.MAX_VALUE))).addComponent(this.overrideDefChBox)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.overrideDefChBox).addGap(12, 12, 12).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.addBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeBtn).addGap(23, 23, 23).addComponent(this.upBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downBtn)).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING, -1, 187, Short.MAX_VALUE)).addContainerGap()));
        this.addBtn.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TubesConfigPanel.class, (String)"LBL_Add"));
    }

    private void moveUpHandler(ActionEvent actionEvent) {
        int n = this.getSelectedRow();
        if (n == -1) {
            return;
        }
        int n2 = n - 1;
        this.tubeTableModel.moveRow(n, n, n2);
        this.tubeTable.getSelectionModel().setSelectionInterval(n2, n2);
        this.isChanged = true;
    }

    private void moveDownHandler(ActionEvent actionEvent) {
        int n = this.getSelectedRow();
        if (n == -1) {
            return;
        }
        int n2 = n + 1;
        this.tubeTableModel.moveRow(n, n, n2);
        this.tubeTable.getSelectionModel().setSelectionInterval(n2, n2);
        this.isChanged = true;
    }

    private void overrideDefChBoxActionPerformed(ActionEvent actionEvent) {
        this.isChanged = true;
        this.enableDisable();
    }

    private void enableDisable() {
        boolean bl = this.overrideDefChBox.isSelected();
        this.tubeTable.setEnabled(bl);
        this.tubeTable.setFocusable(bl);
        this.tubeTable.setOpaque(!bl);
        this.addBtn.setEnabled(bl);
        this.downBtn.setEnabled(bl);
        this.jScrollPane2.setEnabled(bl);
        this.removeBtn.setEnabled(bl);
        this.upBtn.setEnabled(bl);
    }

    private int getSelectedRow() {
        ListSelectionModel listSelectionModel = this.tubeTable.getSelectionModel();
        if (listSelectionModel.isSelectionEmpty()) {
            return -1;
        }
        return listSelectionModel.getMinSelectionIndex();
    }

    class AddButtonActionListener
    implements ActionListener {
        DialogDescriptor dlgDesc = null;

        AddButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ClassDialog classDialog = new ClassDialog(TubesConfigPanel.this.project, null);
            classDialog.show();
            int n = 0;
            if (classDialog.okButtonPressed()) {
                Set set = classDialog.getSelectedClasses();
                for (String string : set) {
                    TubesConfigPanel.this.tubeTableModel.addRow(new Object[]{string});
                    n = TubesConfigPanel.this.tubeTableModel.getRowCount() - 1;
                }
            }
            TubesConfigPanel.this.tubeTable.getSelectionModel().setSelectionInterval(n, n);
            TubesConfigPanel.this.isChanged = true;
        }
    }

    class RemoveButtonActionListener
    implements ActionListener {
        RemoveButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = TubesConfigPanel.this.tubeTable.getSelectedRows();
            Arrays.sort(nArray);
            if (nArray == null || nArray.length <= 0) {
                return;
            }
            String string = "";
            for (int n : nArray) {
                string = string + (String)TubesConfigPanel.this.tubeTableModel.getValueAt(n, 0) + ", \n";
            }
            if (this.confirmDeletion(string)) {
                int n;
                for (n = nArray.length - 1; n >= 0; --n) {
                    TubesConfigPanel.this.tubeTableModel.removeRow(n);
                }
                n = nArray[0] - 1;
                TubesConfigPanel.this.tubeTable.getSelectionModel().setSelectionInterval(n, n);
                TubesConfigPanel.this.isChanged = true;
            }
        }

        private boolean confirmDeletion(String string) {
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(TubesConfigPanel.class, (String)"MSG_CONFIRM_DELETE", (Object)string), NbBundle.getMessage(TubesConfigPanel.class, (String)"TTL_CONFIRM_DELETE"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            return confirmation.getValue() == NotifyDescriptor.YES_OPTION;
        }
    }

    class TubeListSelectionListener
    implements ListSelectionListener {
        TubeListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                int n = TubesConfigPanel.this.getSelectedRow();
                if (n == 0) {
                    TubesConfigPanel.this.upBtn.setEnabled(false);
                } else if (!TubesConfigPanel.this.upBtn.isEnabled()) {
                    TubesConfigPanel.this.upBtn.setEnabled(true);
                }
                if (n == TubesConfigPanel.this.tubeTableModel.getRowCount() - 1) {
                    TubesConfigPanel.this.downBtn.setEnabled(false);
                } else if (!TubesConfigPanel.this.downBtn.isEnabled()) {
                    TubesConfigPanel.this.downBtn.setEnabled(true);
                }
            }
        }
    }

    class TubeTable
    extends JTable {
        public TubeTable() {
            JTableHeader jTableHeader = this.getTableHeader();
            jTableHeader.setResizingAllowed(false);
            jTableHeader.setReorderingAllowed(false);
            ListSelectionModel listSelectionModel = this.getSelectionModel();
            listSelectionModel.setSelectionMode(1);
            listSelectionModel.addListSelectionListener(new TubeListSelectionListener());
        }

        @Override
        public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
            Component component = super.prepareRenderer(tableCellRenderer, n, n2);
            this.getTableHeader().setEnabled(this.isEnabled());
            component.setEnabled(this.isEnabled());
            return component;
        }
    }

    class TubeTableModel
    extends DefaultTableModel {
        public TubeTableModel(Object[] objectArray, int n) {
            super(objectArray, n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

