/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.analysis.ui;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.List;
import javax.swing.AbstractAction;
import org.netbeans.modules.analysis.ui.AnalysisResultTopComponent;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.cookies.OpenCookie;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

public class PreviousError
extends AbstractAction
implements PropertyChangeListener {
    private AnalysisResultTopComponent comp;

    public PreviousError(AnalysisResultTopComponent comp) {
        this.comp = comp;
        this.comp.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public boolean isEnabled() {
        boolean enabled;
        Node node = this.getNextMeaningfullNode();
        boolean bl = enabled = node != null;
        if (node != null) {
            this.comp.seenNodes.add(0, node);
        }
        return enabled;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Node node = this.getNextMeaningfullNode();
        this.comp.nodesForNext.add(0, node);
        OpenCookie oc = (OpenCookie)node.getLookup().lookup(OpenCookie.class);
        assert (oc != null);
        try {
            this.comp.getExplorerManager().setSelectedNodes(new Node[]{node});
        }
        catch (PropertyVetoException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        oc.open();
        this.fireEnabledChanged();
    }

    void fireEnabledChanged() {
        this.firePropertyChange("enabled", null, this.isEnabled());
    }

    private Node getNextMeaningfullNode() {
        List<Node> seenNodes = this.comp.seenNodes;
        if (seenNodes == null || seenNodes.isEmpty()) {
            return null;
        }
        while (seenNodes != null && !seenNodes.isEmpty()) {
            Node top = this.comp.seenNodes.remove(0);
            ErrorDescription ed = (ErrorDescription)top.getLookup().lookup(ErrorDescription.class);
            if (ed == null) continue;
            Node[] selected = this.comp.getExplorerManager().getSelectedNodes();
            if (selected.length == 1 && selected[0] == top) {
                this.comp.nodesForNext.add(0, top);
                continue;
            }
            return top;
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.fireEnabledChanged();
    }
}

