/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.analysis.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.modules.analysis.Configuration;
import org.netbeans.modules.analysis.ConfigurationsManager;
import org.netbeans.modules.analysis.RunAnalysisPanel;
import org.netbeans.modules.analysis.SPIAccessor;
import org.netbeans.modules.analysis.spi.Analyzer;
import org.netbeans.modules.analysis.ui.ConfigurationsComboModel;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class AdjustConfigurationPanel
extends JPanel {
    private static final String LBL_NEW = "New...";
    private static final String LBL_DUPLICATE = "Duplicate...";
    private static final String LBL_RENAME = "Rename...";
    private static final String LBL_DELETE = "Delete";
    private final Iterable<? extends Analyzer.AnalyzerFactory> analyzers;
    private Analyzer.CustomizerContext<Object, JComponent> currentContext;
    private final Map<Analyzer.AnalyzerFactory, Analyzer.CustomizerProvider> customizers = new IdentityHashMap<Analyzer.AnalyzerFactory, Analyzer.CustomizerProvider>();
    private final Map<Analyzer.CustomizerProvider, Object> customizerData = new IdentityHashMap<Analyzer.CustomizerProvider, Object>();
    private Preferences currentPreferences;
    private ModifiedPreferences currentPreferencesOverlay;
    private final String preselected;
    private JComboBox analyzerCombo;
    private JPanel analyzerPanel;
    private JComboBox configurationCombo;
    private JLabel configurationLabel;
    private JLabel jLabel2;

    public AdjustConfigurationPanel(Iterable<? extends Analyzer.AnalyzerFactory> analyzers, Analyzer.AnalyzerFactory preselectedAnalyzer, String preselected) {
        this.preselected = preselected;
        this.initComponents();
        if (preselected == null) {
            this.configurationCombo.setModel(new ConfigurationsComboModel(true));
            this.configurationCombo.setRenderer(new RunAnalysisPanel.ConfigurationRenderer(false));
            this.configurationCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AdjustConfigurationPanel.this.configurationCombo.getSelectedItem() instanceof ActionListener) {
                        ((ActionListener)AdjustConfigurationPanel.this.configurationCombo.getSelectedItem()).actionPerformed(e);
                    } else {
                        AdjustConfigurationPanel.this.updateConfiguration();
                    }
                }
            });
        } else {
            this.configurationLabel.setVisible(false);
            this.configurationCombo.setVisible(false);
        }
        this.analyzers = analyzers;
        DefaultComboBoxModel<Analyzer.AnalyzerFactory> analyzerModel = new DefaultComboBoxModel<Analyzer.AnalyzerFactory>();
        for (Analyzer.AnalyzerFactory analyzerFactory : analyzers) {
            Analyzer.CustomizerProvider cp = analyzerFactory.getCustomizerProvider();
            if (cp == null) continue;
            this.customizers.put(analyzerFactory, cp);
            analyzerModel.addElement(analyzerFactory);
        }
        this.analyzerCombo.setModel(analyzerModel);
        if (preselectedAnalyzer != null) {
            this.analyzerCombo.setSelectedItem(preselectedAnalyzer);
        }
        this.analyzerCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdjustConfigurationPanel.this.updateAnalyzer();
            }
        });
        this.analyzerCombo.setRenderer(new AnalyzerRenderer());
        this.updateConfiguration();
    }

    private void updateConfiguration() {
        if (this.currentPreferencesOverlay != null && this.currentPreferences != null) {
            this.currentPreferencesOverlay.store(this.currentPreferences);
        }
        if (this.preselected == null) {
            this.currentPreferences = ((Configuration)this.configurationCombo.getSelectedItem()).getPreferences();
        } else {
            this.currentPreferences = ConfigurationsManager.getDefault().getTemporaryConfiguration().getPreferences();
            try {
                for (String c : this.currentPreferences.childrenNames()) {
                    this.currentPreferences.node(c).removeNode();
                }
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.currentPreferencesOverlay = new ModifiedPreferences(null, "", this.currentPreferences);
        this.updateAnalyzer();
    }

    private void updateAnalyzer() {
        Analyzer.AnalyzerFactory selected = (Analyzer.AnalyzerFactory)this.analyzerCombo.getSelectedItem();
        Analyzer.CustomizerProvider customizer = this.customizers.get(selected);
        if (!this.customizerData.containsKey(customizer)) {
            this.customizerData.put(customizer, customizer.initialize());
        }
        Object data = this.customizerData.get(customizer);
        Preferences settings = this.currentPreferencesOverlay.node(SPIAccessor.ACCESSOR.getAnalyzerId(selected));
        this.analyzerPanel.removeAll();
        this.currentContext = new Analyzer.CustomizerContext<Object, Object>(settings, this.preselected, null, data);
        this.currentContext.setSelectedId(this.preselected);
        this.analyzerPanel.add((Component)customizer.createComponent(this.currentContext), "Center");
        this.analyzerPanel.revalidate();
        this.analyzerPanel.repaint();
    }

    public String getIdToRun() {
        return SPIAccessor.ACCESSOR.getSelectedId(this.currentContext);
    }

    public void save() {
        this.currentPreferencesOverlay.store(this.currentPreferences);
    }

    private void initComponents() {
        this.configurationLabel = new JLabel();
        this.configurationCombo = new JComboBox();
        this.jLabel2 = new JLabel();
        this.analyzerCombo = new JComboBox();
        this.analyzerPanel = new JPanel();
        this.configurationLabel.setText(NbBundle.getMessage(AdjustConfigurationPanel.class, (String)"AdjustConfigurationPanel.configurationLabel.text"));
        this.jLabel2.setText(NbBundle.getMessage(AdjustConfigurationPanel.class, (String)"AdjustConfigurationPanel.jLabel2.text"));
        this.analyzerPanel.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.analyzerPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.configurationLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.configurationCombo, 0, 254, Short.MAX_VALUE).addComponent(this.analyzerCombo, 0, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.configurationLabel).addComponent(this.configurationCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.analyzerCombo, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.analyzerPanel, -1, 198, Short.MAX_VALUE).addContainerGap()));
    }

    private static class AnalyzerRenderer
    extends DefaultListCellRenderer {
        private AnalyzerRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Analyzer.AnalyzerFactory a = (Analyzer.AnalyzerFactory)value;
            return super.getListCellRendererComponent((JList<?>)list, SPIAccessor.ACCESSOR.getAnalyzerDisplayName(a), index, isSelected, cellHasFocus);
        }
    }

    private static class ModifiedPreferences
    extends AbstractPreferences {
        private final Map<String, Object> properties = new HashMap<String, Object>();
        private final Map<String, ModifiedPreferences> subNodes = new HashMap<String, ModifiedPreferences>();

        public ModifiedPreferences(ModifiedPreferences parent, String name) {
            super(parent, name);
        }

        public ModifiedPreferences(ModifiedPreferences parent, String name, Preferences node) {
            this(parent, name);
            try {
                for (String key : node.keys()) {
                    this.put(key, node.get(key, null));
                }
                for (String child : node.childrenNames()) {
                    this.subNodes.put(child, new ModifiedPreferences(this, node.name(), node.node(child)));
                }
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public void store(Preferences target) {
            try {
                for (String key : this.keys()) {
                    target.put(key, this.get(key, null));
                }
                for (String child : this.childrenNames()) {
                    ((ModifiedPreferences)this.node(child)).store(target.node(child));
                }
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        @Override
        protected void putSpi(String key, String value) {
            this.properties.put(key, value);
        }

        @Override
        protected String getSpi(String key) {
            return (String)this.properties.get(key);
        }

        @Override
        protected void removeSpi(String key) {
            this.properties.remove(key);
        }

        @Override
        protected void removeNodeSpi() throws BackingStoreException {
            ((ModifiedPreferences)this.parent()).subNodes.put(this.name(), new ModifiedPreferences(this, this.name()));
        }

        @Override
        protected String[] keysSpi() throws BackingStoreException {
            String[] array = new String[this.properties.keySet().size()];
            return this.properties.keySet().toArray(array);
        }

        @Override
        protected String[] childrenNamesSpi() throws BackingStoreException {
            return this.subNodes.keySet().toArray(new String[0]);
        }

        @Override
        protected AbstractPreferences childSpi(String name) {
            ModifiedPreferences result = this.subNodes.get(name);
            if (result == null) {
                result = new ModifiedPreferences(this, name);
                this.subNodes.put(name, result);
            }
            return result;
        }

        @Override
        protected void syncSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected void flushSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        boolean isEmpty() {
            return this.properties.isEmpty();
        }
    }
}

