/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.renderkit;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.api.UIData;
import org.primefaces.component.paginator.CurrentPageReportRenderer;
import org.primefaces.component.paginator.FirstPageLinkRenderer;
import org.primefaces.component.paginator.JumpToPageDropdownRenderer;
import org.primefaces.component.paginator.LastPageLinkRenderer;
import org.primefaces.component.paginator.NextPageLinkRenderer;
import org.primefaces.component.paginator.PageLinksRenderer;
import org.primefaces.component.paginator.PaginatorElementRenderer;
import org.primefaces.component.paginator.PrevPageLinkRenderer;
import org.primefaces.component.paginator.RowsPerPageDropdownRenderer;
import org.primefaces.renderkit.CoreRenderer;

public class DataRenderer
extends CoreRenderer {
    protected Map<String, PaginatorElementRenderer> paginatorElements = new HashMap<String, PaginatorElementRenderer>();

    public DataRenderer() {
        this.paginatorElements.put("{CurrentPageReport}", new CurrentPageReportRenderer());
        this.paginatorElements.put("{FirstPageLink}", new FirstPageLinkRenderer());
        this.paginatorElements.put("{PreviousPageLink}", new PrevPageLinkRenderer());
        this.paginatorElements.put("{NextPageLink}", new NextPageLinkRenderer());
        this.paginatorElements.put("{LastPageLink}", new LastPageLinkRenderer());
        this.paginatorElements.put("{PageLinks}", new PageLinksRenderer());
        this.paginatorElements.put("{RowsPerPageDropdown}", new RowsPerPageDropdownRenderer());
        this.paginatorElements.put("{JumpToPageDropdown}", new JumpToPageDropdownRenderer());
    }

    protected void encodePaginatorMarkup(FacesContext context, UIData uidata, String position) throws IOException {
        String[] elements;
        if (!uidata.isPaginatorAlwaysVisible() && uidata.getPageCount() <= 1) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        boolean isTop = position.equals("top");
        boolean hidden = !uidata.isPaginatorAlwaysVisible() && uidata.getPageCount() == 1;
        String styleClass = isTop ? "ui-paginator ui-paginator-top ui-widget-header" : "ui-paginator ui-paginator-bottom ui-widget-header";
        String id = uidata.getClientId(context) + "_paginator_" + position;
        if (!isTop && uidata.getFooter() == null) {
            styleClass = styleClass + " ui-corner-bottom";
        } else if (isTop && uidata.getHeader() == null) {
            styleClass = styleClass + " ui-corner-top";
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (hidden) {
            writer.writeAttribute("style", (Object)"display:none", null);
        }
        for (String element : elements = uidata.getPaginatorTemplate().split(" ")) {
            PaginatorElementRenderer renderer = this.paginatorElements.get(element);
            if (renderer != null) {
                renderer.render(context, uidata);
                continue;
            }
            writer.write(element + " ");
        }
        writer.endElement("div");
    }

    protected void encodePaginatorConfig(FacesContext context, UIData uidata) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = uidata.getClientId(context);
        String paginatorPosition = uidata.getPaginatorPosition();
        String paginatorContainers = null;
        String currentPageTemplate = uidata.getCurrentPageReportTemplate();
        paginatorContainers = paginatorPosition.equalsIgnoreCase("both") ? "'" + clientId + "_paginator_top','" + clientId + "_paginator_bottom'" : "'" + clientId + "_paginator_" + paginatorPosition + "'";
        writer.write(",paginator:{");
        writer.write("id:[" + paginatorContainers + "]");
        writer.write(",rows:" + uidata.getRows());
        writer.write(",rowCount:" + uidata.getRowCount());
        writer.write(",page:" + uidata.getPage());
        if (currentPageTemplate != null) {
            writer.write(",currentPageTemplate:'" + currentPageTemplate + "'");
        }
        if (uidata.getPageLinks() != 10) {
            writer.write(",pageLinks:" + uidata.getPageLinks());
        }
        if (!uidata.isPaginatorAlwaysVisible()) {
            writer.write(",alwaysVisible:false");
        }
        writer.write("}");
    }
}

