/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.push;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketServlet;

public final class PushServlet
extends WebSocketServlet {
    private static final long serialVersionUID = 1L;
    private final Map<String, Set<PrimeWebSocket>> connectedClients = new ConcurrentHashMap<String, Set<PrimeWebSocket>>();

    public void init() throws ServletException {
        String[] channels;
        super.init();
        for (String channel : channels = this.getInitParameter("channels").split(",")) {
            this.connectedClients.put(channel, new CopyOnWriteArraySet());
        }
    }

    public WebSocket doWebSocketConnect(HttpServletRequest request, String protocol) {
        String channel = request.getRequestURI().split("/prime-push/")[1];
        return new PrimeWebSocket(channel);
    }

    private class PrimeWebSocket
    implements WebSocket,
    WebSocket.OnTextMessage {
        WebSocket.Connection connection;
        String channel;

        public PrimeWebSocket(String channel) {
            this.channel = channel;
        }

        public void onClose(int closeCode, String message) {
            ((Set)PushServlet.this.connectedClients.get(this.channel)).remove(this);
        }

        public void onOpen(WebSocket.Connection connection) {
            this.connection = connection;
            ((Set)PushServlet.this.connectedClients.get(this.channel)).add(this);
        }

        public void onMessage(String message) {
            try {
                for (PrimeWebSocket ws : (Set)PushServlet.this.connectedClients.get(this.channel)) {
                    ws.connection.sendMessage(message);
                }
            }
            catch (IOException e) {
                System.out.println(e);
            }
        }
    }
}

