/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.faces.model.DataModel;
import org.primefaces.model.SelectableDataModel;
import org.primefaces.model.SortOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LazyDataModel<T>
extends DataModel<T>
implements SelectableDataModel<T>,
Serializable {
    private int rowIndex = -1;
    private int rowCount;
    private int pageSize;
    private List<T> data;

    public boolean isRowAvailable() {
        if (this.data == null) {
            return false;
        }
        return this.rowIndex >= 0 && this.rowIndex < this.data.size();
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public T getRowData() {
        return this.data.get(this.rowIndex);
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex == -1 ? rowIndex : rowIndex % this.pageSize;
    }

    public Object getWrappedData() {
        return this.data;
    }

    public void setWrappedData(Object list) {
        this.data = (List)list;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public abstract List<T> load(int var1, int var2, String var3, SortOrder var4, Map<String, String> var5);

    @Override
    public T getRowData(String rowKey) {
        throw new UnsupportedOperationException("getRowData(String rowKey) must be implemented when basic rowKey algorithm is not used.");
    }

    @Override
    public Object getRowKey(T object) {
        throw new UnsupportedOperationException("getRowKey(T object) must be implemented when basic rowKey algorithm is not used.");
    }
}

