/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.treetable;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.column.Column;
import org.primefaces.component.treetable.TreeTable;
import org.primefaces.model.TreeNode;
import org.primefaces.renderkit.CoreRenderer;

public class TreeTableRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeSelection(context, component);
        this.decodeBehaviors(context, component);
    }

    protected void decodeSelection(FacesContext context, UIComponent component) {
        String selectionValue;
        Map params = context.getExternalContext().getRequestParameterMap();
        TreeTable tt = (TreeTable)component;
        String selectionMode = tt.getSelectionMode();
        if (selectionMode != null && !this.isValueBlank(selectionValue = (String)params.get(tt.getClientId(context) + "_selection"))) {
            if (selectionMode.equals("single")) {
                tt.setRowKey(selectionValue);
                tt.setSelection(tt.getRowNode());
            } else {
                String[] rowKeys = selectionValue.split(",");
                TreeNode[] selection = new TreeNode[rowKeys.length];
                for (int i = 0; i < rowKeys.length; ++i) {
                    tt.setRowKey(rowKeys[i]);
                    selection[i] = tt.getRowNode();
                }
                tt.setSelection(selection);
            }
            tt.setRowKey(null);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        TreeTable tt = (TreeTable)component;
        String clientId = tt.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        String nodeKey = (String)params.get(clientId + "_expand");
        if (nodeKey != null) {
            tt.setRowKey(nodeKey);
            TreeNode node = tt.getRowNode();
            node.setExpanded(true);
            this.encodeNode(context, tt, node, clientId, nodeKey);
        } else {
            this.encodeMarkup(context, tt);
            this.encodeScript(context, tt);
        }
    }

    protected void encodeScript(FacesContext context, TreeTable tt) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = tt.getClientId(context);
        String selectionMode = tt.getSelectionMode();
        this.startScript(writer, clientId);
        writer.write("PrimeFaces.cw('TreeTable','" + tt.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        if (selectionMode != null) {
            writer.write(",selectionMode:'" + selectionMode + "'");
        }
        if (tt.getScrollWidth() != Integer.MIN_VALUE) {
            writer.write(",scrollWidth:" + tt.getScrollWidth());
        }
        this.encodeClientBehaviors(context, tt);
        writer.write("});");
        this.endScript(writer);
    }

    protected void encodeMarkup(FacesContext context, TreeTable tt) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = tt.getClientId(context);
        boolean scrollable = tt.isScrollable();
        String containerClass = "ui-treetable ui-widget";
        containerClass = scrollable ? containerClass + " " + "ui-treetable-scrollable" : containerClass;
        containerClass = tt.getStyleClass() == null ? containerClass : containerClass + " " + tt.getStyleClass();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)containerClass, null);
        if (tt.getStyle() != null) {
            writer.writeAttribute("style", (Object)tt.getStyle(), null);
        }
        if (scrollable) {
            this.encodeScrollableMarkup(context, tt);
        } else {
            this.encodeRegularMarkup(context, tt);
        }
        if (tt.getSelectionMode() != null) {
            this.encodeSelectionHolder(context, tt);
        }
        writer.endElement("div");
    }

    protected void encodeScrollableMarkup(FacesContext context, TreeTable tt) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        int scrollHeight = tt.getScrollHeight();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-widget-header ui-treetable-scrollable-header", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-treetable-scrollable-header-box", null);
        writer.startElement("table", null);
        writer.writeAttribute("role", (Object)"treegrid", null);
        if (tt.getTableStyle() != null) {
            writer.writeAttribute("style", (Object)tt.getTableStyle(), null);
        }
        if (tt.getTableStyleClass() != null) {
            writer.writeAttribute("class", (Object)tt.getTableStyleClass(), null);
        }
        this.encodeThead(context, tt);
        writer.endElement("table");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-treetable-scrollable-body", null);
        if (scrollHeight != Integer.MIN_VALUE) {
            writer.writeAttribute("style", (Object)("height:" + scrollHeight + "px"), null);
        }
        writer.startElement("table", null);
        writer.writeAttribute("role", (Object)"treegrid", null);
        if (tt.getTableStyle() != null) {
            writer.writeAttribute("style", (Object)tt.getTableStyle(), null);
        }
        if (tt.getTableStyleClass() != null) {
            writer.writeAttribute("class", (Object)tt.getTableStyleClass(), null);
        }
        this.encodeTbody(context, tt);
        writer.endElement("table");
        writer.endElement("div");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-widget-header ui-treetable-scrollable-footer", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-treetable-scrollable-footer-box", null);
        writer.startElement("table", null);
        writer.writeAttribute("role", (Object)"treegrid", null);
        if (tt.getTableStyle() != null) {
            writer.writeAttribute("style", (Object)tt.getTableStyle(), null);
        }
        if (tt.getTableStyleClass() != null) {
            writer.writeAttribute("class", (Object)tt.getTableStyleClass(), null);
        }
        this.encodeTfoot(context, tt);
        writer.endElement("table");
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeRegularMarkup(FacesContext context, TreeTable tt) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("table", (UIComponent)tt);
        writer.writeAttribute("role", (Object)"treegrid", null);
        if (tt.getTableStyle() != null) {
            writer.writeAttribute("style", (Object)tt.getTableStyle(), null);
        }
        if (tt.getTableStyleClass() != null) {
            writer.writeAttribute("class", (Object)tt.getTableStyleClass(), null);
        }
        this.encodeThead(context, tt);
        this.encodeTfoot(context, tt);
        this.encodeTbody(context, tt);
        writer.endElement("table");
    }

    protected void encodeThead(FacesContext context, TreeTable tt) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("thead", null);
        this.encodeFacet(context, tt, "header", "ui-treetable-header ui-widget-header", "th");
        writer.startElement("tr", null);
        writer.writeAttribute("role", (Object)"row", null);
        for (int i = 0; i < tt.getChildCount(); ++i) {
            UIComponent kid = (UIComponent)tt.getChildren().get(i);
            if (!(kid instanceof Column) || !kid.isRendered()) continue;
            Column column = (Column)kid;
            UIComponent header = column.getFacet("header");
            String headerText = column.getHeaderText();
            String columnStyleClass = column.getStyleClass() == null ? "ui-state-default" : "ui-state-default " + column.getStyleClass();
            String style = column.getStyle();
            writer.startElement("th", null);
            writer.writeAttribute("id", (Object)column.getClientId(context), null);
            writer.writeAttribute("class", (Object)columnStyleClass, null);
            writer.writeAttribute("role", (Object)"columnheader", null);
            if (style != null) {
                writer.writeAttribute("style", (Object)style, null);
            }
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-tt-c", null);
            if (header != null) {
                header.encodeAll(context);
            } else if (headerText != null) {
                writer.write(headerText);
            }
            writer.endElement("div");
            writer.endElement("th");
        }
        writer.endElement("tr");
        writer.endElement("thead");
    }

    protected void encodeTbody(FacesContext context, TreeTable tt) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        TreeNode root = tt.getValue();
        String clientId = tt.getClientId(context);
        writer.startElement("tbody", null);
        writer.writeAttribute("class", (Object)"ui-treetable-data ui-widget-content", null);
        if (root != null) {
            this.encodeNode(context, tt, root, clientId, null);
        }
        tt.setRowKey(null);
        writer.endElement("tbody");
    }

    protected void encodeNode(FacesContext context, TreeTable tt, TreeNode treeNode, String clientId, String rowKey) throws IOException {
        if (rowKey != null) {
            ResponseWriter writer = context.getResponseWriter();
            tt.setRowKey(rowKey);
            String nodeId = clientId + "_node_" + rowKey;
            String icon = treeNode.isExpanded() ? "ui-treetable-toggler ui-icon ui-icon-triangle-1-s" : "ui-treetable-toggler ui-icon ui-icon-triangle-1-e";
            int depth = rowKey.split("_").length - 1;
            boolean selectionEnabled = tt.getSelectionMode() != null;
            boolean selectable = treeNode.isSelectable() && selectionEnabled;
            boolean selected = treeNode.isSelected();
            String rowStyleClass = selected ? "ui-widget-content ui-state-highlight ui-selected" : "ui-widget-content";
            rowStyleClass = selectable ? rowStyleClass + " " + TreeTable.SELECTABLE_NODE_CLASS : rowStyleClass;
            rowStyleClass = rowStyleClass + " " + treeNode.getType();
            if (selected) {
                tt.getSelectedRowKeys().add(rowKey);
            }
            writer.startElement("tr", null);
            writer.writeAttribute("id", (Object)nodeId, null);
            writer.writeAttribute("class", (Object)rowStyleClass, null);
            writer.writeAttribute("role", (Object)"row", null);
            writer.writeAttribute("aria-expanded", (Object)String.valueOf(treeNode.isExpanded()), null);
            if (selectionEnabled) {
                writer.writeAttribute("aria-selected", (Object)String.valueOf(selected), null);
            }
            for (int i = 0; i < tt.getChildren().size(); ++i) {
                UIComponent kid = (UIComponent)tt.getChildren().get(i);
                if (!(kid instanceof Column) || !kid.isRendered()) continue;
                Column column = (Column)kid;
                writer.startElement("td", null);
                writer.writeAttribute("role", (Object)"gridcell", null);
                if (column.getStyleClass() != null) {
                    writer.writeAttribute("class", (Object)column.getStyleClass(), null);
                }
                if (column.getStyle() != null) {
                    writer.writeAttribute("style", (Object)column.getStyle(), null);
                }
                writer.startElement("div", null);
                writer.writeAttribute("class", (Object)"ui-tt-c", null);
                if (i == 0) {
                    String cellStyle = "padding-left:" + depth * 15 + "px";
                    writer.writeAttribute("style", (Object)cellStyle, null);
                    writer.startElement("span", null);
                    writer.writeAttribute("class", (Object)icon, null);
                    if (treeNode.getChildCount() == 0) {
                        writer.writeAttribute("style", (Object)"visibility:hidden", null);
                    }
                    writer.endElement("span");
                }
                column.encodeAll(context);
                writer.endElement("div");
                writer.endElement("td");
            }
            writer.endElement("tr");
        }
        if (treeNode.isExpanded() || treeNode.getParent() == null) {
            int childIndex = 0;
            Iterator<TreeNode> iterator = treeNode.getChildren().iterator();
            while (iterator.hasNext()) {
                String childRowKey = rowKey == null ? String.valueOf(childIndex) : rowKey + "_" + childIndex;
                this.encodeNode(context, tt, iterator.next(), clientId, childRowKey);
                ++childIndex;
            }
        }
    }

    protected void encodeFacet(FacesContext context, TreeTable tt, String name, String styleClass, String tag) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent facet = tt.getFacet(name);
        if (facet != null) {
            writer.startElement("tr", null);
            writer.startElement(tag, null);
            writer.writeAttribute("colspan", (Object)tt.getColumnsCount(), null);
            writer.writeAttribute("class", (Object)styleClass, null);
            facet.encodeAll(context);
            writer.endElement("td");
            writer.endElement("tr");
        }
    }

    protected void encodeTfoot(FacesContext context, TreeTable tt) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("tfoot", null);
        this.encodeFacet(context, tt, "footer", "ui-treetable-footer ui-widget-header", "td");
        if (tt.hasFooterColumn()) {
            writer.startElement("tr", null);
            for (int i = 0; i < tt.getChildCount(); ++i) {
                UIComponent kid = (UIComponent)tt.getChildren().get(i);
                if (!(kid instanceof Column) || !kid.isRendered()) continue;
                Column column = (Column)kid;
                UIComponent footer = column.getFacet("footer");
                String footerText = column.getHeaderText();
                String columnStyleClass = column.getStyleClass() == null ? "ui-state-default" : "ui-state-default " + column.getStyleClass();
                String style = column.getStyle();
                writer.startElement("td", null);
                writer.writeAttribute("id", (Object)column.getClientId(context), null);
                writer.writeAttribute("class", (Object)columnStyleClass, null);
                if (style != null) {
                    writer.writeAttribute("style", (Object)style, null);
                }
                writer.startElement("div", null);
                writer.writeAttribute("class", (Object)"ui-tt-c", null);
                if (footer != null) {
                    footer.encodeAll(context);
                } else if (footerText != null) {
                    writer.write(footerText);
                }
                writer.endElement("div");
                writer.endElement("td");
            }
            writer.endElement("tr");
        }
        writer.endElement("tfoot");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    private void encodeSelectionHolder(FacesContext context, TreeTable tt) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String name = tt.getClientId(context) + "_selection";
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)name, null);
        writer.writeAttribute("name", (Object)name, null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("value", (Object)tt.getSelectedRowKeysAsString(), null);
        writer.endElement("input");
    }
}

