/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.tree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.primefaces.component.api.UITree;
import org.primefaces.component.api.Widget;
import org.primefaces.component.tree.UITreeNode;
import org.primefaces.event.NodeCollapseEvent;
import org.primefaces.event.NodeExpandEvent;
import org.primefaces.event.NodeSelectEvent;
import org.primefaces.event.NodeUnselectEvent;
import org.primefaces.model.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="primefaces.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="primefaces.js")})
public class Tree
extends UITree
implements Widget,
ClientBehaviorHolder {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Tree";
    public static final String COMPONENT_FAMILY = "org.primefaces.component";
    private static final String DEFAULT_RENDERER = "org.primefaces.component.TreeRenderer";
    private static final String OPTIMIZED_PACKAGE = "org.primefaces.component.";
    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList("select", "unselect", "expand", "collapse"));
    private List<String> selectedRowKeys = new ArrayList<String>();
    private Map<String, UITreeNode> nodes;
    public static String CONTAINER_CLASS = "ui-tree ui-widget ui-widget-content ui-helper-clearfix ui-corner-all";
    public static String SELECTABLE_NODE_CLASS = "ui-tree-selectable-node";
    public static String ROOT_NODES_CLASS = "ui-tree-nodes ui-helper-reset";
    public static String PARENT_CLASS = "ui-tree-parent";
    public static String NODE_CLASS = "ui-tree-node ui-state-default";
    public static String NODES_CLASS = "ui-tree-nodes ui-helper-reset ui-tree-child";
    public static String LEAF_CLASS = "ui-tree-item";
    public static String NODE_CONTENT_CLASS = "ui-helper-clearfix ui-tree-node-content ui-corner-all";
    public static String NODE_LABEL_CLASS = "ui-tree-node-label";
    public static String EXPANDED_ICON_CLASS = "ui-tree-icon ui-icon ui-icon-triangle-1-s";
    public static String COLLAPSED_ICON_CLASS = "ui-tree-icon ui-icon ui-icon-triangle-1-e";
    public static String CHECKBOX_CLASS = "ui-tree-checkbox ui-widget";
    public static String CHECKBOX_BOX_CLASS = "ui-tree-checkbox-box ui-widget ui-corner-all ui-state-default";
    public static String CHECKBOX_ICON_CLASS = "ui-tree-checkbox-icon";
    public static String CHECKBOX_ICON_CHECKED_CLASS = "ui-tree-checkbox-icon ui-icon ui-icon-check";
    public static String CHECKBOX_ICON_MINUS_CLASS = "ui-tree-checkbox-icon ui-icon ui-icon-minus";

    public Tree() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String _widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)_widgetVar);
        this.handleAttribute("widgetVar", _widgetVar);
    }

    public boolean isDynamic() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.dynamic), (Object)false);
    }

    public void setDynamic(boolean _dynamic) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.dynamic), (Object)_dynamic);
        this.handleAttribute("dynamic", _dynamic);
    }

    public boolean isCache() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.cache), (Object)true);
    }

    public void setCache(boolean _cache) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.cache), (Object)_cache);
        this.handleAttribute("cache", _cache);
    }

    public String getOnNodeClick() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onNodeClick), null);
    }

    public void setOnNodeClick(String _onNodeClick) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onNodeClick), (Object)_onNodeClick);
        this.handleAttribute("onNodeClick", _onNodeClick);
    }

    public Object getSelection() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.selection), null);
    }

    public void setSelection(Object _selection) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.selection), _selection);
        this.handleAttribute("selection", _selection);
    }

    public String getStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.style), null);
    }

    public void setStyle(String _style) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.style), (Object)_style);
        this.handleAttribute("style", _style);
    }

    public String getStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClass), null);
    }

    public void setStyleClass(String _styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClass), (Object)_styleClass);
        this.handleAttribute("styleClass", _styleClass);
    }

    public String getSelectionMode() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.selectionMode), null);
    }

    public void setSelectionMode(String _selectionMode) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.selectionMode), (Object)_selectionMode);
        this.handleAttribute("selectionMode", _selectionMode);
    }

    public UITreeNode getUITreeNodeByType(String type) {
        UITreeNode node = this.getTreeNodes().get(type);
        if (node == null) {
            throw new FacesException("Unsupported tree node type:" + type);
        }
        return node;
    }

    private boolean isRequestSource(FacesContext context) {
        return this.getClientId(context).equals(context.getExternalContext().getRequestParameterMap().get("javax.faces.source"));
    }

    @Override
    public void processUpdates(FacesContext context) {
        super.processUpdates(context);
        String selectionMode = this.getSelectionMode();
        ValueExpression selectionVE = this.getValueExpression("selection");
        if (selectionMode != null && selectionVE != null) {
            Object selection = this.getLocalSelectedNodes();
            Object previousSelection = selectionVE.getValue(context.getELContext());
            if (selectionMode.equals("single")) {
                if (previousSelection != null) {
                    ((TreeNode)previousSelection).setSelected(false);
                }
                if (selection != null) {
                    ((TreeNode)selection).setSelected(true);
                }
            } else {
                TreeNode[] previousSelections = (TreeNode[])previousSelection;
                TreeNode[] selections = (TreeNode[])selection;
                if (previousSelections != null) {
                    for (TreeNode node : previousSelections) {
                        node.setSelected(false);
                    }
                }
                if (selections != null) {
                    for (TreeNode node : selections) {
                        node.setSelected(true);
                    }
                }
            }
            selectionVE.setValue(context.getELContext(), selection);
            this.setSelection(null);
        }
    }

    public boolean isNodeExpandRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_expandNode");
    }

    public Object getLocalSelectedNodes() {
        return this.getStateHelper().get((Serializable)((Object)PropertyKeys.selection));
    }

    public Map<String, UITreeNode> getTreeNodes() {
        if (this.nodes == null) {
            this.nodes = new HashMap<String, UITreeNode>();
            for (UIComponent child : this.getChildren()) {
                UITreeNode node = (UITreeNode)child;
                this.nodes.put(node.getType(), node);
            }
        }
        return this.nodes;
    }

    public List<String> getSelectedRowKeys() {
        return this.selectedRowKeys;
    }

    public String getSelectedRowKeysAsString() {
        StringBuilder builder = new StringBuilder();
        Iterator<String> iter = this.selectedRowKeys.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) continue;
            builder.append(',');
        }
        return builder.toString();
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    @Override
    public void queueEvent(FacesEvent event) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (this.isRequestSource(context)) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            String clientId = this.getClientId(context);
            AjaxBehaviorEvent wrapperEvent = null;
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            if (eventName.equals("expand")) {
                this.setRowKey((String)params.get(clientId + "_expandNode"));
                wrapperEvent = new NodeExpandEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getRowNode());
                wrapperEvent.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else if (eventName.equals("collapse")) {
                this.setRowKey((String)params.get(clientId + "_collapseNode"));
                TreeNode collapsedNode = this.getRowNode();
                collapsedNode.setExpanded(false);
                wrapperEvent = new NodeCollapseEvent((UIComponent)this, behaviorEvent.getBehavior(), collapsedNode);
                wrapperEvent.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else if (eventName.equals("select")) {
                this.setRowKey((String)params.get(clientId + "_instantSelection"));
                wrapperEvent = new NodeSelectEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getRowNode());
                wrapperEvent.setPhaseId(behaviorEvent.getPhaseId());
            } else if (eventName.equals("unselect")) {
                this.setRowKey((String)params.get(clientId + "_instantUnselection"));
                wrapperEvent = new NodeUnselectEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getRowNode());
                wrapperEvent.setPhaseId(behaviorEvent.getPhaseId());
            }
            super.queueEvent((FacesEvent)wrapperEvent);
            this.setRowKey(null);
        } else {
            super.queueEvent(event);
        }
    }

    private boolean isToggleRequest(FacesContext context) {
        String clientId;
        Map params = context.getExternalContext().getRequestParameterMap();
        return params.get((clientId = this.getClientId(context)) + "_expandNode") != null || params.get(clientId + "_collapseNode") != null;
    }

    @Override
    public void processDecodes(FacesContext context) {
        if (this.isToggleRequest(context)) {
            this.decode(context);
            context.renderResponse();
        } else {
            super.processDecodes(context);
        }
    }

    public boolean isCheckboxSelection() {
        String selectionMode = this.getSelectionMode();
        return selectionMode != null && selectionMode.equals("checkbox");
    }

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    @Override
    public String resolveWidgetVar() {
        FacesContext context = FacesContext.getCurrentInstance();
        String userWidgetVar = (String)this.getAttributes().get("widgetVar");
        if (userWidgetVar != null) {
            return userWidgetVar;
        }
        return "widget_" + this.getClientId(context).replaceAll("-|" + UINamingContainer.getSeparatorChar((FacesContext)context), "_");
    }

    public void handleAttribute(String name, Object value) {
        String cname;
        ArrayList<String> setAttributes = (ArrayList<String>)this.getAttributes().get("javax.faces.component.UIComponentBase.attributesThatAreSet");
        if (setAttributes == null && (cname = this.getClass().getName()) != null && cname.startsWith(OPTIMIZED_PACKAGE)) {
            setAttributes = new ArrayList<String>(6);
            this.getAttributes().put("javax.faces.component.UIComponentBase.attributesThatAreSet", setAttributes);
        }
        if (setAttributes != null && value == null) {
            ValueExpression ve = this.getValueExpression(name);
            if (ve == null) {
                setAttributes.remove(name);
            } else if (!setAttributes.contains(name)) {
                setAttributes.add(name);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyKeys {
        widgetVar,
        dynamic,
        cache,
        onNodeClick,
        selection,
        style,
        styleClass,
        selectionMode;

        String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

