/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.splitbutton;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.commandbutton.CommandButtonRenderer;
import org.primefaces.component.menuitem.MenuItem;
import org.primefaces.component.separator.Separator;
import org.primefaces.component.splitbutton.SplitButton;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;

public class SplitButtonRenderer
extends CommandButtonRenderer {
    public void decode(FacesContext context, UIComponent component) {
        SplitButton button = (SplitButton)component;
        if (button.isDisabled()) {
            return;
        }
        String param = component.getClientId(context);
        if (context.getExternalContext().getRequestParameterMap().containsKey(param)) {
            component.queueEvent((FacesEvent)new ActionEvent(component));
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        SplitButton button = (SplitButton)component;
        this.encodeMarkup(context, button);
        this.encodeScript(context, button);
    }

    protected void encodeMarkup(FacesContext context, SplitButton button) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = button.getClientId(context);
        String menuId = clientId + "_menu";
        String menuButtonId = clientId + "_menuButton";
        String buttonId = clientId + "_button";
        String styleClass = button.getStyleClass();
        styleClass = styleClass == null ? "ui-splitbutton ui-buttonset ui-widget" : "ui-splitbutton ui-buttonset ui-widget " + styleClass;
        writer.startElement("div", (UIComponent)button);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "id");
        if (button.getStyle() != null) {
            writer.writeAttribute("style", (Object)button.getStyle(), "id");
        }
        this.encodeDefaultButton(context, button, buttonId);
        this.encodeMenuIcon(context, button, menuButtonId);
        this.encodeMenu(context, button, menuId);
        writer.endElement("div");
    }

    protected void encodeDefaultButton(FacesContext context, SplitButton button, String id) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String value = (String)button.getValue();
        String icon = button.getIcon();
        String onclick = this.buildOnclick(context, button);
        writer.startElement("button", (UIComponent)button);
        writer.writeAttribute("id", (Object)id, "id");
        writer.writeAttribute("name", (Object)id, "name");
        writer.writeAttribute("class", (Object)button.resolveStyleClass(), "styleClass");
        if (onclick.length() > 0) {
            writer.writeAttribute("onclick", (Object)onclick.toString(), "onclick");
        }
        this.renderPassThruAttributes(context, (UIComponent)button, HTML.BUTTON_ATTRS, HTML.CLICK_EVENT);
        if (button.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        if (icon != null) {
            String defaultIconClass = button.getIconPos().equals("left") ? "ui-button-icon-left ui-icon" : "ui-button-icon-right ui-icon";
            String iconClass = defaultIconClass + " " + icon;
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)iconClass, null);
            writer.endElement("span");
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text", null);
        if (value == null) {
            writer.write("ui-button");
        } else {
            writer.writeText((Object)value, "value");
        }
        writer.endElement("span");
        writer.endElement("button");
    }

    protected void encodeMenuIcon(FacesContext context, SplitButton button, String id) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("button", (UIComponent)button);
        writer.writeAttribute("id", (Object)id, "id");
        writer.writeAttribute("name", (Object)id, "name");
        writer.writeAttribute("type", (Object)"button", "name");
        writer.writeAttribute("class", (Object)"ui-splitbutton-menubutton  ui-button ui-widget ui-state-default ui-corner-right ui-button-icon-only ui-corner-right", "styleClass");
        if (button.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-icon-left ui-icon ui-icon-triangle-1-s", null);
        writer.endElement("span");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text", null);
        writer.write("ui-button");
        writer.endElement("span");
        writer.endElement("button");
    }

    protected void encodeScript(FacesContext context, SplitButton button) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = button.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("$(function(){");
        writer.write("PrimeFaces.cw('SplitButton','" + button.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write("});});");
        this.endScript(writer);
    }

    protected String buildOnclick(FacesContext context, SplitButton button) throws IOException {
        UIComponent form;
        StringBuilder onclick = new StringBuilder();
        if (button.getOnclick() != null) {
            onclick.append(button.getOnclick()).append(";");
        }
        if ((form = ComponentUtils.findParentForm(context, (UIComponent)button)) == null) {
            throw new FacesException("SplitButton : \"" + button.getClientId(context) + "\" must be inside a form element");
        }
        String formClientId = form.getClientId(context);
        String request = button.isAjax() ? this.buildAjaxRequest(context, button) : this.buildNonAjaxRequest(context, (UIComponent)button, formClientId);
        onclick.append(request);
        String onclickBehaviors = this.getOnclickBehaviors(context, (ClientBehaviorHolder)button);
        if (onclickBehaviors != null) {
            onclick.append(onclickBehaviors).append(";");
        }
        return onclick.toString();
    }

    protected void encodeMenu(FacesContext context, SplitButton button, String menuId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)menuId, null);
        writer.writeAttribute("class", (Object)"ui-menu ui-menu-dynamic ui-widget ui-widget-content ui-corner-all ui-helper-clearfix ui-shadow", "styleClass");
        writer.writeAttribute("role", (Object)"menu", null);
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)"ui-menu-list ui-helper-reset", "styleClass");
        for (UIComponent child : button.getChildren()) {
            if (!child.isRendered()) continue;
            if (child instanceof MenuItem) {
                MenuItem item = (MenuItem)child;
                writer.startElement("li", (UIComponent)item);
                writer.writeAttribute("class", (Object)"ui-menuitem ui-widget ui-corner-all", null);
                writer.writeAttribute("role", (Object)"menuitem", null);
                this.encodeMenuItem(context, item);
                writer.endElement("li");
                continue;
            }
            if (!(child instanceof Separator)) continue;
            this.encodeSeparator(context, (Separator)child);
        }
        writer.endElement("ul");
        writer.endElement("div");
    }

    protected void encodeMenuItem(FacesContext context, MenuItem menuItem) throws IOException {
        String clientId = menuItem.getClientId(context);
        ResponseWriter writer = context.getResponseWriter();
        String icon = menuItem.getIcon();
        if (menuItem.shouldRenderChildren()) {
            this.renderChildren(context, (UIComponent)menuItem);
        } else {
            boolean disabled = menuItem.isDisabled();
            String onclick = menuItem.getOnclick();
            writer.startElement("a", null);
            writer.writeAttribute("id", (Object)menuItem.getClientId(context), null);
            String styleClass = menuItem.getStyleClass();
            styleClass = styleClass == null ? "ui-menuitem-link ui-corner-all" : "ui-menuitem-link ui-corner-all " + styleClass;
            styleClass = disabled ? styleClass + " ui-state-disabled" : styleClass;
            writer.writeAttribute("class", (Object)styleClass, null);
            if (menuItem.getStyle() != null) {
                writer.writeAttribute("style", (Object)menuItem.getStyle(), null);
            }
            if (menuItem.getUrl() != null) {
                String href = disabled ? "#" : this.getResourceURL(context, menuItem.getUrl());
                writer.writeAttribute("href", (Object)href, null);
                if (menuItem.getTarget() != null) {
                    writer.writeAttribute("target", (Object)menuItem.getTarget(), null);
                }
            } else {
                writer.writeAttribute("href", (Object)"#", null);
                UIComponent form = ComponentUtils.findParentForm(context, (UIComponent)menuItem);
                if (form == null) {
                    throw new FacesException("Menubar must be inside a form element");
                }
                String command = menuItem.isAjax() ? this.buildAjaxRequest(context, menuItem) : this.buildNonAjaxRequest(context, (UIComponent)menuItem, form.getClientId(context), clientId);
                String string = onclick = onclick == null ? command : onclick + ";" + command;
            }
            if (onclick != null && !disabled) {
                writer.writeAttribute("onclick", (Object)onclick, null);
            }
            if (icon != null) {
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)("ui-menuitem-icon ui-icon " + icon), null);
                writer.endElement("span");
            }
            if (menuItem.getValue() != null) {
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)"ui-menuitem-text", null);
                writer.writeText((Object)((String)menuItem.getValue()), "value");
                writer.endElement("span");
            }
            writer.endElement("a");
        }
    }

    protected void encodeSeparator(FacesContext context, Separator separator) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String style = separator.getStyle();
        String styleClass = separator.getStyleClass();
        styleClass = styleClass == null ? "ui-separator ui-state-default" : "ui-separator ui-state-default " + styleClass;
        writer.startElement("li", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.endElement("li");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

