/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.sheet;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.model.ListDataModel;
import org.primefaces.component.column.Column;
import org.primefaces.component.sheet.Sheet;
import org.primefaces.model.BeanPropertyComparator;
import org.primefaces.model.SortOrder;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class SheetRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Sheet sheet = (Sheet)component;
        if (sheet.isSortingRequest(context)) {
            this.sort(context, sheet);
            this.encodeBody(context, sheet);
        } else {
            this.encodeMarkup(context, sheet);
            this.encodeScript(context, sheet);
        }
    }

    protected void encodeMarkup(FacesContext context, Sheet sheet) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = sheet.getClientId(context);
        String styleClass = sheet.getStyleClass();
        styleClass = styleClass == null ? "ui-sheet ui-widget" : "ui-sheet ui-widget " + styleClass;
        writer.startElement("div", (UIComponent)sheet);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "id");
        if (sheet.getStyle() != null) {
            writer.writeAttribute("style", (Object)sheet.getStyle(), "style");
        }
        this.encodeCaption(context, sheet);
        this.encodeEditorBar(context, sheet);
        this.encodeContent(context, sheet);
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, Sheet sheet) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = sheet.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("PrimeFaces.cw('Sheet','" + sheet.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write("},'sheet');");
        this.endScript(writer);
    }

    protected void encodeCaption(FacesContext context, Sheet sheet) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent caption = sheet.getFacet("caption");
        if (caption != null) {
            writer.startElement("div", (UIComponent)sheet);
            writer.writeAttribute("class", (Object)"ui-widget-header ui-sheet-caption ui-corner-tl ui-corner-tr", null);
            caption.encodeAll(context);
            writer.endElement("div");
        }
    }

    protected void encodeEditorBar(FacesContext context, Sheet sheet) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", (UIComponent)sheet);
        writer.writeAttribute("class", (Object)"ui-sheet-editor-bar ui-widget-header", null);
        writer.startElement("table", null);
        writer.startElement("tbody", null);
        writer.startElement("tr", null);
        writer.startElement("td", null);
        writer.writeAttribute("class", (Object)"ui-sheet-cell-info", null);
        writer.endElement("td");
        writer.startElement("td", null);
        writer.startElement("input", null);
        writer.writeAttribute("class", (Object)"ui-sheet-editor", null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.endElement("input");
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("tbody");
        writer.endElement("table");
        writer.endElement("div");
    }

    protected void encodeContent(FacesContext context, Sheet sheet) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        int scrollHeight = sheet.getScrollHeight();
        int scrollWidth = sheet.getScrollWidth();
        boolean hasScrollWidth = scrollWidth != Integer.MIN_VALUE;
        StringBuilder style = new StringBuilder();
        if (scrollHeight != Integer.MIN_VALUE) {
            style.append("height:").append(scrollHeight).append("px;");
        }
        if (hasScrollWidth) {
            style.append("width:").append(scrollWidth).append("px;");
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-widget-header ui-sheet-header", null);
        if (hasScrollWidth) {
            writer.writeAttribute("style", (Object)("width:" + scrollWidth + "px"), null);
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-sheet-header-box", null);
        writer.startElement("table", null);
        this.encodeHeader(context, sheet);
        writer.endElement("table");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-sheet-body", null);
        if (style.length() > 0) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.startElement("table", null);
        this.encodeBody(context, sheet);
        writer.endElement("table");
        writer.endElement("div");
    }

    public void encodeHeader(FacesContext context, Sheet sheet) throws IOException {
        Column column;
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("thead", null);
        writer.startElement("tr", null);
        writer.startElement("th", null);
        writer.writeAttribute("class", (Object)"ui-state-default", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-sheet-index-cell ui-sh-c", null);
        writer.endElement("div");
        writer.endElement("th");
        int columnIndex = 0;
        for (UIComponent child : sheet.getChildren()) {
            if (!(child instanceof Column) || !child.isRendered()) continue;
            column = (Column)child;
            boolean sortable = column.getValueExpression("sortBy") != null;
            String style = column.getStyle();
            String styleClass = column.getStyleClass();
            styleClass = styleClass == null ? "ui-sh-c" : "ui-sh-c " + styleClass;
            String columnHeaderClass = sortable ? "ui-state-default ui-sortable-column" : "ui-state-default";
            writer.startElement("th", null);
            writer.writeAttribute("id", (Object)column.getClientId(context), style);
            writer.writeAttribute("class", (Object)columnHeaderClass, null);
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)styleClass, null);
            if (style != null) {
                writer.writeAttribute("style", (Object)style, null);
            }
            if (sortable) {
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)"ui-sortable-column-icon ui-icon ui-icon-carat-2-n-s", null);
                writer.endElement("span");
            }
            writer.write(this.getColumnCode(columnIndex));
            writer.endElement("th");
            ++columnIndex;
        }
        writer.endElement("tr");
        writer.endElement("thead");
        writer.startElement("tbody", null);
        writer.startElement("tr", null);
        writer.writeAttribute("class", (Object)"ui-widget-content", null);
        writer.startElement("td", null);
        writer.writeAttribute("class", (Object)"ui-state-default", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-sheet-index-cell ui-sh-c", null);
        writer.write("1");
        writer.endElement("div");
        writer.endElement("td");
        for (UIComponent child : sheet.getChildren()) {
            if (!(child instanceof Column) || !child.isRendered()) continue;
            column = (Column)child;
            String style = column.getStyle();
            String styleClass = column.getStyleClass();
            styleClass = styleClass == null ? "ui-sh-c" : "ui-sh-c " + styleClass;
            writer.startElement("td", null);
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)styleClass, null);
            if (style != null) {
                writer.writeAttribute("style", (Object)style, null);
            }
            if (column.getHeader() != null) {
                column.getHeader().encodeAll(context);
            } else if (column.getHeaderText() != null) {
                writer.write(column.getHeaderText());
            }
            writer.endElement("div");
            writer.endElement("td");
        }
        writer.endElement("tr");
        writer.endElement("tbody");
    }

    public void encodeBody(FacesContext context, Sheet sheet) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        int rows = sheet.getRows();
        int first = sheet.getFirst();
        int rowCount = sheet.getRowCount();
        int rowCountToRender = rows == 0 ? rowCount : rows;
        boolean hasData = rowCount > 0;
        writer.startElement("tbody", null);
        if (hasData) {
            for (int i = first; i < first + rowCountToRender; ++i) {
                this.encodeRow(context, sheet, i);
            }
        }
        writer.endElement("tbody");
        sheet.setRowIndex(-1);
    }

    protected void encodeRow(FacesContext context, Sheet sheet, int rowIndex) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = sheet.getClientId(context);
        sheet.setRowIndex(rowIndex);
        writer.startElement("tr", null);
        writer.writeAttribute("id", (Object)(clientId + "_row_" + rowIndex), null);
        writer.writeAttribute("class", (Object)"ui-widget-content", null);
        writer.startElement("td", null);
        writer.writeAttribute("class", (Object)"ui-state-default", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-sheet-index-cell ui-sh-c", null);
        writer.write(String.valueOf(rowIndex + 2));
        writer.endElement("div");
        writer.endElement("td");
        for (UIComponent child : sheet.getChildren()) {
            if (!(child instanceof Column) || !child.isRendered()) continue;
            Column column = (Column)child;
            String style = column.getStyle();
            String styleClass = column.getStyleClass();
            styleClass = styleClass == null ? "ui-sh-c" : "ui-sh-c " + styleClass;
            writer.startElement("td", null);
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)styleClass, null);
            if (style != null) {
                writer.writeAttribute("style", (Object)style, null);
            }
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-sh-c-d", null);
            String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)child.getChildren().get(0));
            if (valueToRender != null) {
                writer.write(valueToRender);
            }
            writer.endElement("div");
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-sh-c-e", null);
            child.encodeAll(context);
            writer.endElement("div");
            writer.endElement("td");
        }
        writer.endElement("tr");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void sort(FacesContext context, Sheet sheet) {
        Map params = context.getExternalContext().getRequestParameterMap();
        Object value = sheet.getValue();
        List list = null;
        String clientId = sheet.getClientId(context);
        Column sortColumn = sheet.findColumn((String)params.get(clientId + "_sortKey"));
        ValueExpression sortByVE = sortColumn.getValueExpression("sortBy");
        SortOrder sortOrder = SortOrder.valueOf((String)params.get(clientId + "_sortDir"));
        if (value instanceof List) {
            list = (List)value;
        } else if (value instanceof ListDataModel) {
            list = (List)((ListDataModel)value).getWrappedData();
        } else {
            throw new FacesException("Data type should be java.util.List or javax.faces.model.ListDataModel instance to be sortable.");
        }
        Collections.sort(list, new BeanPropertyComparator(sortByVE, sheet.getVar(), sortOrder, null));
    }

    protected String getColumnCode(int index) {
        if (index >= 26) {
            return this.getColumnCode(index / 26 - 1) + Sheet.LETTERS[index % 26];
        }
        return Sheet.LETTERS[index];
    }
}

