/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.selectoneradio;

import java.io.IOException;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UISelectOne;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import org.primefaces.component.radiobutton.RadioButton;
import org.primefaces.component.selectoneradio.SelectOneRadio;
import org.primefaces.renderkit.SelectOneRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectOneRadioRenderer
extends SelectOneRenderer {
    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        return context.getRenderKit().getRenderer("javax.faces.SelectOne", "javax.faces.Radio").getConvertedValue(context, component, submittedValue);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        boolean custom;
        SelectOneRadio radio = (SelectOneRadio)component;
        String layout = radio.getLayout();
        boolean bl = custom = layout != null && layout.equals("custom");
        if (!custom) {
            this.encodeMarkup(context, radio);
            this.encodeScript(context, radio);
        } else {
            radio.setSelectItems(this.getSelectItems(context, (UIInput)radio));
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("span", (UIComponent)radio);
            writer.writeAttribute("id", (Object)radio.getClientId(context), "id");
            writer.endElement("span");
        }
    }

    protected void encodeMarkup(FacesContext context, SelectOneRadio radio) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = radio.getClientId(context);
        String style = radio.getStyle();
        String styleClass = radio.getStyleClass();
        styleClass = styleClass == null ? "ui-selectoneradio ui-widget" : "ui-selectoneradio ui-widget " + styleClass;
        String layout = radio.getLayout();
        List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)radio);
        writer.startElement("table", (UIComponent)radio);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeSelectItems(context, radio, selectItems, layout);
        writer.endElement("table");
    }

    protected void encodeScript(FacesContext context, SelectOneRadio radio) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = radio.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("PrimeFaces.cw('SelectOneRadio','" + radio.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)radio);
        writer.write("});");
        this.endScript(writer);
    }

    protected void encodeSelectItems(FacesContext context, SelectOneRadio radio, List<SelectItem> selectItems, String layout) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Converter converter = this.getConverter(context, (UIInput)radio);
        String name = radio.getClientId(context);
        boolean pageDirection = layout != null && layout.equals("pageDirection");
        Object value = radio.getSubmittedValue();
        if (value == null) {
            value = radio.getValue();
        }
        Class type = value == null ? String.class : value.getClass();
        int idx = -1;
        for (SelectItem selectItem : selectItems) {
            boolean selected;
            boolean disabled = selectItem.isDisabled() || radio.isDisabled();
            String id = name + UINamingContainer.getSeparatorChar((FacesContext)context) + ++idx;
            Object coercedItemValue = this.coerceToModelType(context, selectItem.getValue(), type);
            boolean bl = selected = coercedItemValue != null && coercedItemValue.equals(value);
            if (pageDirection) {
                writer.startElement("tr", null);
            }
            this.encodeOption(context, radio, selectItem, id, name, converter, selected, disabled);
            if (!pageDirection) continue;
            writer.endElement("tr");
        }
    }

    protected void encodeOption(FacesContext context, SelectOneRadio radio, SelectItem option, String id, String name, Converter converter, boolean selected, boolean disabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String itemValueAsString = this.getOptionAsString(context, (UIComponent)radio, converter, option.getValue());
        writer.startElement("td", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-radiobutton ui-widget", null);
        this.encodeOptionInput(context, radio, id, name, selected, disabled, itemValueAsString);
        this.encodeOptionOutput(context, radio, selected, disabled);
        writer.endElement("div");
        writer.endElement("td");
        writer.startElement("td", null);
        this.encodeOptionLabel(context, radio, id, option, disabled);
        writer.endElement("td");
    }

    protected void encodeOptionInput(FacesContext context, SelectOneRadio radio, String id, String name, boolean checked, boolean disabled, String value) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)name, null);
        writer.writeAttribute("type", (Object)"radio", null);
        writer.writeAttribute("value", (Object)value, null);
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (radio.getOnchange() != null) {
            writer.writeAttribute("onchange", (Object)radio.getOnchange(), null);
        }
        writer.endElement("input");
        writer.endElement("div");
    }

    protected void encodeOptionLabel(FacesContext context, SelectOneRadio radio, String containerClientId, SelectItem option, boolean disabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("label", null);
        writer.writeAttribute("for", (Object)containerClientId, null);
        if (disabled) {
            writer.writeAttribute("class", (Object)"ui-state-disabled", null);
        }
        if (option.isEscape()) {
            writer.writeText((Object)option.getLabel(), null);
        } else {
            writer.write(option.getLabel());
        }
        writer.endElement("label");
    }

    protected void encodeOptionOutput(FacesContext context, SelectOneRadio radio, boolean selected, boolean disabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String boxClass = "ui-radiobutton-box ui-widget ui-corner-all ui-radiobutton-relative ui-state-default";
        boxClass = selected ? boxClass + " ui-state-active" : boxClass;
        boxClass = disabled ? boxClass + " ui-state-disabled" : boxClass;
        boxClass = !radio.isValid() ? boxClass + " ui-state-error" : boxClass;
        String iconClass = "ui-radiobutton-icon";
        iconClass = selected ? iconClass + " " + "ui-icon ui-icon-bullet" : iconClass;
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)boxClass, null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)iconClass, null);
        writer.endElement("span");
        writer.endElement("div");
    }

    protected void encodeRadioButton(FacesContext context, SelectOneRadio radio, RadioButton button) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
    }

    protected Class getValueType(FacesContext context, UIInput input) {
        ValueExpression ve = input.getValueExpression("value");
        Class type = ve == null ? String.class : ve.getType(context.getELContext());
        return type == null ? String.class : type;
    }

    @Override
    protected String getSubmitParam(FacesContext context, UISelectOne selectOne) {
        return selectOne.getClientId(context);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

