/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.selectonemenu;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectOne;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import org.primefaces.component.column.Column;
import org.primefaces.component.selectonemenu.SelectOneMenu;
import org.primefaces.renderkit.SelectOneRenderer;
import org.primefaces.util.ComponentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectOneMenuRenderer
extends SelectOneRenderer {
    @Override
    public void decode(FacesContext context, UIComponent component) {
        if (!SelectOneMenuRenderer.shouldDecode(component)) {
            return;
        }
        SelectOneMenu menu = (SelectOneMenu)component;
        if (menu.isEditable()) {
            Map params = context.getExternalContext().getRequestParameterMap();
            this.decodeBehaviors(context, (UIComponent)menu);
            menu.setSubmittedValue(params.get(menu.getClientId(context) + "_editableInput"));
        } else {
            super.decode(context, component);
        }
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        return context.getRenderKit().getRenderer("javax.faces.SelectOne", "javax.faces.Menu").getConvertedValue(context, component, submittedValue);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        SelectOneMenu menu = (SelectOneMenu)component;
        this.encodeMarkup(context, menu);
        this.encodeScript(context, menu);
    }

    protected void encodeMarkup(FacesContext context, SelectOneMenu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)menu);
        String clientId = menu.getClientId(context);
        Converter converter = this.getConverter(context, (UIInput)menu);
        Object values = this.getValues((UISelectOne)menu);
        Object submittedValues = this.getSubmittedValues((UIComponent)menu);
        boolean valid = menu.isValid();
        String style = menu.getStyle();
        String styleClass = menu.getStyleClass();
        styleClass = styleClass == null ? "ui-selectonemenu ui-widget ui-state-default ui-corner-all ui-helper-clearfix" : "ui-selectonemenu ui-widget ui-state-default ui-corner-all ui-helper-clearfix " + styleClass;
        styleClass = !valid ? styleClass + " ui-state-error" : styleClass;
        styleClass = menu.isDisabled() ? styleClass + " ui-state-disabled" : styleClass;
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleclass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeInput(context, menu, clientId, selectItems, values, submittedValues, converter);
        this.encodeLabel(context, menu, selectItems);
        this.encodeMenuIcon(context, menu, valid);
        this.encodePanel(context, menu, selectItems);
        writer.endElement("div");
    }

    protected void encodeInput(FacesContext context, SelectOneMenu menu, String clientId, List<SelectItem> selectItems, Object values, Object submittedValues, Converter converter) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputId = clientId + "_input";
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.startElement("select", (UIComponent)menu);
        writer.writeAttribute("id", (Object)inputId, "id");
        writer.writeAttribute("name", (Object)inputId, null);
        if (menu.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (menu.getStyle() != null) {
            writer.writeAttribute("style", (Object)menu.getStyle(), null);
        }
        if (menu.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)menu.getStyleClass(), null);
        }
        if (menu.getTabindex() != null) {
            writer.writeAttribute("tabindex", (Object)menu.getTabindex(), null);
        }
        this.encodeSelectItems(context, menu, selectItems, values, submittedValues, converter);
        writer.endElement("select");
        writer.endElement("div");
    }

    protected void encodeLabel(FacesContext context, SelectOneMenu menu, List<SelectItem> selectItems) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)menu);
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("name", (Object)(menu.getClientId() + "_editableInput"), null);
        writer.writeAttribute("class", (Object)"ui-selectonemenu-label ui-inputfield ui-corner-all", null);
        writer.writeAttribute("tabindex", (Object)-1, null);
        if (menu.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (valueToRender != null) {
            writer.writeAttribute("value", (Object)valueToRender, null);
        }
        writer.endElement("input");
    }

    protected void encodeMenuIcon(FacesContext context, SelectOneMenu menu, boolean valid) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String iconClass = valid ? "ui-selectonemenu-trigger ui-state-default ui-corner-right" : "ui-selectonemenu-trigger ui-state-default ui-corner-right ui-state-error";
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("class", (Object)iconClass, null);
        writer.startElement("span", (UIComponent)menu);
        writer.writeAttribute("class", (Object)"ui-icon ui-icon-triangle-1-s", null);
        writer.endElement("span");
        writer.endElement("div");
    }

    protected void encodePanel(FacesContext context, SelectOneMenu menu, List<SelectItem> selectItems) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean customContent = menu.getVar() != null;
        int height = this.calculatePanelHeight(menu, selectItems.size());
        String panelStyle = menu.getPanelStyle() != null ? menu.getPanelStyle() : "";
        String panelStyleClass = menu.getPanelStyleClass();
        String string = panelStyleClass = panelStyleClass == null ? "ui-selectonemenu-panel ui-widget-content ui-corner-all ui-helper-hidden ui-shadow" : "ui-selectonemenu-panel ui-widget-content ui-corner-all ui-helper-hidden ui-shadow " + panelStyleClass;
        if (height != -1) {
            panelStyle = panelStyle + ";height:" + height + "px";
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(menu.getClientId(context) + "_panel"), null);
        writer.writeAttribute("class", (Object)panelStyleClass, null);
        if (!this.isValueEmpty(panelStyle)) {
            writer.writeAttribute("style", (Object)panelStyle, null);
        }
        if (customContent) {
            writer.startElement("table", (UIComponent)menu);
            writer.writeAttribute("class", (Object)"ui-selectonemenu-items ui-selectonemenu-table ui-widget-content ui-widget ui-corner-all ui-helper-reset", null);
            writer.startElement("tbody", (UIComponent)menu);
            this.encodeOptionsAsTable(context, menu, selectItems);
            writer.endElement("tbody");
            writer.endElement("table");
        } else {
            writer.startElement("ul", (UIComponent)menu);
            writer.writeAttribute("class", (Object)"ui-selectonemenu-items ui-selectonemenu-list ui-widget-content ui-widget ui-corner-all ui-helper-reset", null);
            this.encodeOptionsAsList(context, menu, selectItems);
            writer.endElement("ul");
        }
        writer.endElement("div");
    }

    protected void encodeOptionsAsTable(FacesContext context, SelectOneMenu menu, List<SelectItem> selectItems) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String var = menu.getVar();
        List<Column> columns = menu.getColums();
        Object value = menu.getValue();
        for (SelectItem selectItem : selectItems) {
            Object itemValue = selectItem.getValue();
            context.getExternalContext().getRequestMap().put(var, selectItem.getValue());
            writer.startElement("tr", null);
            writer.writeAttribute("class", (Object)"ui-selectonemenu-item ui-selectonemenu-row ui-widget-content", null);
            if (selectItem.getDescription() != null) {
                writer.writeAttribute("title", (Object)selectItem.getDescription(), null);
            }
            if (itemValue instanceof String) {
                writer.startElement("td", null);
                writer.writeAttribute("colspan", (Object)columns.size(), null);
                writer.writeText((Object)selectItem.getLabel(), null);
                writer.endElement("td");
            } else {
                for (Column column : columns) {
                    writer.startElement("td", null);
                    column.encodeAll(context);
                    writer.endElement("td");
                }
            }
            writer.endElement("tr");
        }
        context.getExternalContext().getRequestMap().put(var, null);
    }

    protected void encodeOptionsAsList(FacesContext context, SelectOneMenu menu, List<SelectItem> selectItems) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Object value = menu.getValue();
        for (int i = 0; i < selectItems.size(); ++i) {
            SelectItem selectItem = selectItems.get(i);
            String itemLabel = selectItem.getLabel();
            itemLabel = this.isValueBlank(itemLabel) ? "&nbsp;" : itemLabel;
            writer.startElement("li", null);
            writer.writeAttribute("class", (Object)"ui-selectonemenu-item ui-selectonemenu-list-item ui-corner-all", null);
            if (selectItem.getDescription() != null) {
                writer.writeAttribute("title", (Object)selectItem.getDescription(), null);
            }
            if (itemLabel.equals("&nbsp;")) {
                writer.write(itemLabel);
            } else if (selectItem.isEscape()) {
                writer.writeText((Object)itemLabel, "value");
            } else {
                writer.write(itemLabel);
            }
            writer.endElement("li");
        }
    }

    protected void encodeScript(FacesContext context, SelectOneMenu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = menu.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("$(function(){");
        writer.write("PrimeFaces.cw('SelectOneMenu','" + menu.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",effect:'" + menu.getEffect() + "'");
        if (menu.getEffectDuration() != 400) {
            writer.write(",effectDuration:" + menu.getEffectDuration());
        }
        if (menu.getOnchange() != null) {
            writer.write(",onchange:function() {" + menu.getOnchange() + ";}");
        }
        if (menu.isEditable()) {
            writer.write(",editable:true");
        }
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)menu);
        writer.write("});});");
        this.endScript(writer);
    }

    protected void encodeSelectItems(FacesContext context, SelectOneMenu menu, List<SelectItem> selectItems, Object values, Object submittedValues, Converter converter) throws IOException {
        for (SelectItem selectItem : selectItems) {
            this.encodeOption(context, menu, selectItem, values, submittedValues, converter);
        }
    }

    protected void encodeOption(FacesContext context, SelectOneMenu menu, SelectItem option, Object values, Object submittedValues, Converter converter) throws IOException {
        Object itemValue;
        Object valuesArray;
        boolean disabled;
        ResponseWriter writer = context.getResponseWriter();
        String itemValueAsString = this.getOptionAsString(context, (UIComponent)menu, converter, option.getValue());
        boolean bl = disabled = option.isDisabled() || menu.isDisabled();
        if (submittedValues != null) {
            valuesArray = submittedValues;
            itemValue = itemValueAsString;
        } else {
            valuesArray = values;
            itemValue = option.getValue();
        }
        boolean selected = this.isSelected(context, (UIComponent)menu, itemValue, valuesArray, converter);
        if (option.isNoSelectionOption() && values != null && !selected) {
            return;
        }
        writer.startElement("option", null);
        writer.writeAttribute("value", (Object)itemValueAsString, null);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (selected) {
            writer.writeAttribute("selected", (Object)"selected", null);
        }
        if (option.isEscape()) {
            writer.writeText((Object)option.getLabel(), "value");
        } else {
            writer.write(option.getLabel());
        }
        writer.endElement("option");
    }

    protected int calculatePanelHeight(SelectOneMenu menu, int itemSize) {
        int height = menu.getHeight();
        if (height != Integer.MAX_VALUE) {
            return height;
        }
        if (itemSize > 10) {
            return 200;
        }
        return -1;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    protected String getSubmitParam(FacesContext context, UISelectOne selectOne) {
        return selectOne.getClientId(context) + "_input";
    }
}

