/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.selectmanymenu;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectMany;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import org.primefaces.component.selectmanymenu.SelectManyMenu;
import org.primefaces.renderkit.SelectManyRenderer;

public class SelectManyMenuRenderer
extends SelectManyRenderer {
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        return context.getRenderKit().getRenderer("javax.faces.SelectMany", "javax.faces.Menu").getConvertedValue(context, component, submittedValue);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        SelectManyMenu menu = (SelectManyMenu)component;
        this.encodeMarkup(context, menu);
        this.encodeScript(context, menu);
    }

    protected void encodeMarkup(FacesContext context, SelectManyMenu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = menu.getClientId(context);
        String style = menu.getStyle();
        String styleClass = menu.getStyleClass();
        styleClass = styleClass == null ? "ui-selectmanymenu ui-inputfield ui-widget ui-widget-content ui-corner-all" : "ui-selectmanymenu ui-inputfield ui-widget ui-widget-content ui-corner-all " + styleClass;
        styleClass = menu.isDisabled() ? styleClass + " ui-state-disabled" : styleClass;
        styleClass = !menu.isValid() ? styleClass + " ui-state-error" : styleClass;
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeInput(context, menu, clientId);
        this.encodeList(context, menu);
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, SelectManyMenu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = menu.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("PrimeFaces.cw('SelectListbox','" + menu.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",selection:'multiple'");
        if (menu.isDisabled()) {
            writer.write(",disabled:true");
        }
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)menu);
        writer.write("});");
        this.endScript(writer);
    }

    protected void encodeInput(FacesContext context, SelectManyMenu menu, String clientId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputid = clientId + "_input";
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.startElement("select", (UIComponent)menu);
        writer.writeAttribute("id", (Object)inputid, "id");
        writer.writeAttribute("name", (Object)inputid, null);
        writer.writeAttribute("multiple", (Object)"multiple", null);
        writer.writeAttribute("size", (Object)"2", null);
        if (menu.getTabindex() != null) {
            writer.writeAttribute("tabindex", (Object)menu.getTabindex(), null);
        }
        if (menu.getOnchange() != null) {
            writer.writeAttribute("onchange", (Object)menu.getOnchange(), null);
        }
        this.encodeSelectItems(context, menu);
        writer.endElement("select");
        writer.endElement("div");
    }

    protected void encodeList(FacesContext context, SelectManyMenu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("ul", null);
        writer.endElement("ul");
    }

    protected void encodeSelectItems(FacesContext context, SelectManyMenu menu) throws IOException {
        List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)menu);
        Converter converter = this.getConverter(context, (UIInput)menu);
        Object values = this.getValues((UIComponent)menu);
        Object submittedValues = this.getSubmittedValues((UIComponent)menu);
        for (SelectItem selectItem : selectItems) {
            this.encodeOption(context, menu, values, submittedValues, converter, selectItem);
        }
    }

    protected void encodeOption(FacesContext context, SelectManyMenu menu, Object values, Object submittedValues, Converter converter, SelectItem option) throws IOException {
        Object itemValue;
        Object valuesArray;
        boolean disabled;
        ResponseWriter writer = context.getResponseWriter();
        String itemValueAsString = this.getOptionAsString(context, (UIComponent)menu, converter, option.getValue());
        boolean bl = disabled = option.isDisabled() || menu.isDisabled();
        if (submittedValues != null) {
            valuesArray = submittedValues;
            itemValue = itemValueAsString;
        } else {
            valuesArray = values;
            itemValue = option.getValue();
        }
        boolean selected = this.isSelected(context, (UIComponent)menu, itemValue, valuesArray, converter);
        if (option.isNoSelectionOption() && values != null && !selected) {
            return;
        }
        writer.startElement("option", null);
        writer.writeAttribute("value", (Object)itemValueAsString, null);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (selected) {
            writer.writeAttribute("selected", (Object)"selected", null);
        }
        writer.write(option.getLabel());
        writer.endElement("option");
    }

    protected String getSubmitParam(FacesContext context, UISelectMany selectMany) {
        return selectMany.getClientId(context) + "_input";
    }
}

