/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.ring;

import java.io.IOException;
import java.util.Collection;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.ring.Ring;
import org.primefaces.renderkit.CoreRenderer;

public class RingRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Ring ring = (Ring)component;
        this.encodeMarkup(context, ring);
        this.encodeScript(context, ring);
    }

    public void encodeMarkup(FacesContext context, Ring ring) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Collection value = (Collection)ring.getValue();
        String var = ring.getVar();
        String style = ring.getStyle();
        String styleClass = ring.getStyleClass();
        styleClass = styleClass == null ? "ui-ring ui-widget" : "ui-ring ui-widget " + ring.getStyleClass();
        writer.startElement("ul", (UIComponent)ring);
        writer.writeAttribute("id", (Object)ring.getClientId(context), null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        for (int rowIndex = 0; rowIndex < ring.getRowCount(); ++rowIndex) {
            ring.setRowIndex(rowIndex);
            writer.startElement("li", (UIComponent)ring);
            writer.writeAttribute("class", (Object)"ui-state-default ui-corner-all", null);
            for (UIComponent child : ring.getChildren()) {
                child.encodeAll(context);
            }
            writer.endElement("li");
        }
        ring.setRowIndex(-1);
        writer.endElement("ul");
    }

    public void encodeScript(FacesContext context, Ring ring) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = ring.getClientId(context);
        String easing = ring.getEasing();
        this.startScript(writer, clientId);
        writer.write("$(function() {");
        writer.write("PrimeFaces.cw('Ring','" + ring.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",startingChild:" + ring.getFirst());
        if (easing != null) {
            writer.write(",easing:'" + easing + "'");
        }
        writer.write("},'ring');});");
        this.endScript(writer);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

