/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.resizable;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIGraphic;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.resizable.Resizable;
import org.primefaces.renderkit.CoreRenderer;

public class ResizableRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Resizable resizable = (Resizable)component;
        String clientId = resizable.getClientId(context);
        UIComponent target = this.findTarget(context, resizable);
        String targetId = target.getClientId(context);
        this.startScript(writer, clientId);
        if (target instanceof UIGraphic) {
            writer.write("$(PrimeFaces.escapeClientId('" + targetId + "')).load(function(){");
        } else {
            writer.write("$(function(){");
        }
        writer.write("PrimeFaces.cw('Resizable','" + resizable.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",target:'" + targetId + "'");
        if (resizable.getMinWidth() != Integer.MIN_VALUE) {
            writer.write(",minWidth:" + resizable.getMinWidth());
        }
        if (resizable.getMaxWidth() != Integer.MAX_VALUE) {
            writer.write(",maxWidth:" + resizable.getMaxWidth());
        }
        if (resizable.getMinHeight() != Integer.MIN_VALUE) {
            writer.write(",minHeight:" + resizable.getMinHeight());
        }
        if (resizable.getMaxHeight() != Integer.MAX_VALUE) {
            writer.write(",maxHeight:" + resizable.getMaxHeight());
        }
        if (resizable.isAnimate()) {
            writer.write(",animate:true");
            writer.write(",animateEasing:'" + resizable.getEffect() + "'");
            writer.write(",animateDuration:'" + resizable.getEffectDuration() + "'");
        }
        if (resizable.isProxy()) {
            writer.write(",helper:'ui-resizable-proxy'");
        }
        if (resizable.getHandles() != null) {
            writer.write(",handles:'" + resizable.getHandles() + "'");
        }
        if (resizable.getGrid() != 1) {
            writer.write(",grid:" + resizable.getGrid());
        }
        if (resizable.isAspectRatio()) {
            writer.write(",aspectRatio:true");
        }
        if (resizable.isGhost()) {
            writer.write(",ghost:true");
        }
        if (resizable.isContainment()) {
            writer.write(",containment:PrimeFaces.escapeClientId('" + resizable.getParent().getClientId(context) + "')");
        }
        if (resizable.getOnStart() != null) {
            writer.write(",onStart:function(event, ui) {" + resizable.getOnStart() + "}");
        }
        if (resizable.getOnResize() != null) {
            writer.write(",onResize:function(event, ui) {" + resizable.getOnResize() + "}");
        }
        if (resizable.getOnStop() != null) {
            writer.write(",onStop:function(event, ui) {" + resizable.getOnStop() + "}");
        }
        this.encodeClientBehaviors(context, resizable);
        writer.write("});});");
        this.endScript(writer);
    }

    protected UIComponent findTarget(FacesContext context, Resizable resizable) {
        String _for = resizable.getFor();
        if (_for != null) {
            UIComponent component = resizable.findComponent(_for);
            if (component == null) {
                throw new FacesException("Cannot find component \"" + _for + "\" in view.");
            }
            return component;
        }
        return resizable.getParent();
    }
}

