/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.remotecommand;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.primefaces.component.api.AjaxSource;
import org.primefaces.component.remotecommand.RemoteCommand;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class RemoteCommandRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        RemoteCommand command = (RemoteCommand)component;
        if (context.getExternalContext().getRequestParameterMap().containsKey(command.getClientId(context))) {
            ActionEvent event = new ActionEvent((UIComponent)command);
            if (command.isImmediate()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
            command.queueEvent((FacesEvent)event);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        RemoteCommand command = (RemoteCommand)component;
        String name = command.getName();
        writer.startElement("script", (UIComponent)command);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(name + " = function() {");
        writer.write(this.buildAjaxRequest(context, command));
        writer.write("}\n");
        if (command.isAutoRun()) {
            writer.write("$(function() {");
            writer.write(name + "();");
            writer.write("});");
        }
        writer.endElement("script");
    }

    protected String buildAjaxRequest(FacesContext context, AjaxSource source) {
        UIComponent component = (UIComponent)source;
        String clientId = component.getClientId(context);
        UIComponent form = ComponentUtils.findParentForm(context, component);
        if (form == null) {
            throw new FacesException("Component " + component.getClientId(context) + " must be enclosed in a form.");
        }
        StringBuilder req = new StringBuilder();
        req.append("PrimeFaces.ab(");
        req.append("{formId:").append("'").append(form.getClientId(context)).append("'");
        req.append(",source:").append("'").append(clientId).append("'");
        String process = source.getProcess();
        if (process == null) {
            process = "@all";
        } else if ((process = ComponentUtils.findClientIds(context, component, process)).indexOf(clientId) == -1) {
            process = process + " " + clientId;
        }
        req.append(",process:'").append(process).append("'");
        if (source.getUpdate() != null) {
            req.append(",update:'").append(ComponentUtils.findClientIds(context, component, source.getUpdate())).append("'");
        }
        if (source.isAsync()) {
            req.append(",async:true");
        }
        if (!source.isGlobal()) {
            req.append(",global:false");
        }
        if (source.getOnstart() != null) {
            req.append(",onstart:function(){").append(source.getOnstart()).append(";}");
        }
        if (source.getOnerror() != null) {
            req.append(",onerror:function(xhr, status, error){").append(source.getOnerror()).append(";}");
        }
        if (source.getOnsuccess() != null) {
            req.append(",onsuccess:function(data, status, xhr){").append(source.getOnsuccess()).append(";}");
        }
        if (source.getOncomplete() != null) {
            req.append(",oncomplete:function(xhr, status, args){").append(source.getOncomplete()).append(";}");
        }
        req.append(",params:arguments[0]");
        req.append("});");
        return req.toString();
    }
}

