/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.rating;

import java.io.IOException;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.primefaces.component.rating.Rating;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class RatingRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Rating rating = (Rating)component;
        if (rating.isDisabled()) {
            return;
        }
        String clientId = rating.getClientId();
        String value = (String)context.getExternalContext().getRequestParameterMap().get(clientId + "_input");
        String submittedValue = value == null ? "0" : value;
        rating.setSubmittedValue(submittedValue);
        this.decodeBehaviors(context, (UIComponent)rating);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Rating rating = (Rating)component;
        this.encodeMarkup(context, rating);
        this.encodeScript(context, rating);
    }

    private void encodeScript(FacesContext context, Rating rating) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = rating.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("$(function() {");
        writer.write("PrimeFaces.cw('Rating','" + rating.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        if (rating.getOnRate() != null) {
            writer.write(",onRate:function(value) {" + rating.getOnRate() + ";}");
        }
        this.encodeClientBehaviors(context, rating);
        writer.write("},'rating');});");
        this.endScript(writer);
    }

    private void encodeMarkup(FacesContext context, Rating rating) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = rating.getClientId(context);
        String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)rating);
        Double value = this.isValueBlank(valueToRender) ? null : Double.valueOf(valueToRender);
        writer.startElement("span", (UIComponent)rating);
        writer.writeAttribute("id", (Object)clientId, "id");
        for (int i = 1; i <= rating.getStars(); ++i) {
            writer.startElement("input", null);
            writer.writeAttribute("name", (Object)(clientId + "_input"), null);
            writer.writeAttribute("type", (Object)"radio", null);
            writer.writeAttribute("value", (Object)i, null);
            if (value != null && value.intValue() == i) {
                writer.writeAttribute("checked", (Object)"checked", null);
            }
            if (rating.isDisabled()) {
                writer.writeAttribute("disabled", (Object)"disabled", null);
            }
            writer.endElement("input");
        }
        writer.endElement("span");
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        String value = (String)submittedValue;
        Rating rating = (Rating)component;
        Converter converter = rating.getConverter();
        if (converter != null) {
            return converter.getAsObject(context, (UIComponent)rating, value);
        }
        ValueExpression ve = rating.getValueExpression("value");
        if (ve != null) {
            Class valueType = ve.getType(context.getELContext());
            Converter converterForType = context.getApplication().createConverter(valueType);
            if (converterForType != null) {
                return converterForType.getAsObject(context, (UIComponent)rating, value);
            }
        }
        if (value == null) {
            return null;
        }
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException exception) {
            FacesMessage msg = new FacesMessage(FacesMessage.SEVERITY_ERROR, "Conversion error", submittedValue + " is not a valid value for " + component.getClientId(context));
            throw new ConverterException(msg);
        }
    }
}

