/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.radiobutton;

import java.io.IOException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import org.primefaces.component.radiobutton.RadioButton;
import org.primefaces.component.selectoneradio.SelectOneRadio;
import org.primefaces.renderkit.InputRenderer;

public class RadioButtonRenderer
extends InputRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        RadioButton radioButton = (RadioButton)component;
        SelectOneRadio selectOneRadio = this.findSelectOneRadio(radioButton);
        this.encodeMarkup(context, radioButton, selectOneRadio);
        this.encodeScript(context, radioButton, selectOneRadio);
    }

    protected void encodeMarkup(FacesContext context, RadioButton radio, SelectOneRadio selectOneRadio) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String masterClientId = selectOneRadio.getClientId(context);
        String inputId = selectOneRadio.getRadioButtonId(context);
        String clientId = radio.getClientId(context);
        boolean disabled = radio.isDisabled() || selectOneRadio.isDisabled();
        Converter converter = this.getConverter(context, selectOneRadio);
        SelectItem selecItem = selectOneRadio.getSelectItems().get(radio.getItemIndex());
        Object itemValue = selecItem.getValue();
        String itemValueAsString = this.getOptionAsString(context, (UIComponent)radio, converter, itemValue);
        Object value = selectOneRadio.getSubmittedValue();
        if (value == null) {
            value = selectOneRadio.getValue();
        }
        Class type = value == null ? String.class : value.getClass();
        Object coercedItemValue = this.coerceToModelType(context, itemValue, type);
        boolean selected = coercedItemValue != null && coercedItemValue.equals(value);
        String style = radio.getStyle();
        String styleClass = radio.getStyleClass();
        styleClass = styleClass == null ? "ui-radiobutton ui-widget" : "ui-radiobutton ui-widget " + styleClass;
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        this.encodeOptionInput(context, selectOneRadio, radio, inputId, masterClientId, selected, disabled, itemValueAsString);
        this.encodeOptionOutput(context, selected, disabled);
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, RadioButton radioButton, SelectOneRadio selectOneRadio) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = radioButton.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("$(function() {");
        writer.write("PrimeFaces.cw('RadioButton','" + radioButton.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)selectOneRadio);
        writer.write("});});");
        this.endScript(writer);
    }

    protected void encodeOptionInput(FacesContext context, SelectOneRadio radio, RadioButton button, String id, String name, boolean checked, boolean disabled, String value) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)name, null);
        writer.writeAttribute("type", (Object)"radio", null);
        writer.writeAttribute("value", (Object)value, null);
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        StringBuilder onchangeBuilder = new StringBuilder();
        if (radio.getOnchange() != null) {
            onchangeBuilder.append(radio.getOnchange()).append(";");
        }
        if (button.getOnchange() != null) {
            onchangeBuilder.append(button.getOnchange()).append(";");
        }
        if (onchangeBuilder.length() > 0) {
            writer.writeAttribute("onchange", (Object)onchangeBuilder.toString(), null);
        }
        writer.endElement("input");
        writer.endElement("div");
    }

    protected void encodeOptionOutput(FacesContext context, boolean selected, boolean disabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String boxClass = "ui-radiobutton-box ui-widget ui-corner-all ui-radiobutton-relative ui-state-default";
        boxClass = selected ? boxClass + " ui-state-active" : boxClass;
        boxClass = disabled ? boxClass + " ui-state-disabled" : boxClass;
        String iconClass = "ui-radiobutton-icon";
        iconClass = selected ? iconClass + " " + "ui-icon ui-icon-bullet" : iconClass;
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)boxClass, null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)iconClass, null);
        writer.endElement("span");
        writer.endElement("div");
    }

    public SelectOneRadio findSelectOneRadio(RadioButton radioButton) {
        UIComponent target = radioButton.findComponent(radioButton.getFor());
        if (target == null) {
            throw new FacesException("Cannot find component '" + radioButton.getFor() + "' in view.");
        }
        return (SelectOneRadio)target;
    }

    protected Converter getConverter(FacesContext context, SelectOneRadio selectOneRadio) {
        Class valueType;
        Converter converter = selectOneRadio.getConverter();
        if (converter != null) {
            return converter;
        }
        ValueExpression ve = selectOneRadio.getValueExpression("value");
        if (ve != null && (valueType = ve.getType(context.getELContext())) != null) {
            return context.getApplication().createConverter(valueType);
        }
        return null;
    }
}

