/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.poll;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.primefaces.component.poll.Poll;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class PollRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Poll poll = (Poll)component;
        if (context.getExternalContext().getRequestParameterMap().containsKey(poll.getClientId(context))) {
            ActionEvent event = new ActionEvent((UIComponent)poll);
            if (poll.isImmediate()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
            poll.queueEvent((FacesEvent)event);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Poll poll = (Poll)component;
        String clientId = poll.getClientId(context);
        String widgetVar = poll.resolveWidgetVar();
        UIComponent form = ComponentUtils.findParentForm(context, (UIComponent)poll);
        if (form == null) {
            throw new FacesException("Poll:" + clientId + " needs to be enclosed in a form component");
        }
        if (poll.getValueExpression("stop") != null) {
            String userOncomplete = poll.getOncomplete();
            String defaultOncomplete = widgetVar + ".handleComplete(xhr, status, args);";
            String oncomplete = userOncomplete == null ? defaultOncomplete : userOncomplete + ";" + defaultOncomplete;
            poll.setOncomplete(oncomplete);
        }
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("$(function() {");
        writer.write(widgetVar + "= new PrimeFaces.widget.Poll('" + clientId + "', {");
        writer.write("frequency:" + poll.getInterval());
        writer.write(",autoStart:" + poll.isAutoStart());
        writer.write(",fn: function() {");
        writer.write(this.buildAjaxRequest(context, poll));
        writer.write("}});});");
        writer.endElement("script");
    }
}

