/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.picklist;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.primefaces.component.column.Column;
import org.primefaces.component.picklist.PickList;
import org.primefaces.model.DualListModel;
import org.primefaces.renderkit.CoreRenderer;

public class PickListRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        PickList pickList = (PickList)component;
        String clientId = pickList.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterValuesMap();
        String sourceParamKey = clientId + "_source";
        String targetParamKey = clientId + "_target";
        String[] sourceParam = params.containsKey(sourceParamKey) ? (String[])params.get(sourceParamKey) : new String[]{};
        String[] targetParam = params.containsKey(targetParamKey) ? (String[])params.get(targetParamKey) : new String[]{};
        pickList.setSubmittedValue(new String[][]{sourceParam, targetParam});
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        PickList pickList = (PickList)component;
        this.encodeMarkup(facesContext, pickList);
        this.encodeScript(facesContext, pickList);
    }

    protected void encodeMarkup(FacesContext context, PickList pickList) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = pickList.getClientId(context);
        DualListModel model = (DualListModel)pickList.getValue();
        String styleClass = pickList.getStyleClass();
        styleClass = styleClass == null ? "ui-picklist ui-widget" : "ui-picklist ui-widget " + styleClass;
        writer.startElement("table", (UIComponent)pickList);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, null);
        if (pickList.getStyle() != null) {
            writer.writeAttribute("style", (Object)pickList.getStyle(), null);
        }
        writer.startElement("tbody", null);
        writer.startElement("tr", null);
        if (pickList.isShowSourceControls()) {
            this.encodeListControls(context, pickList, "ui-picklist-source-controls");
        }
        this.encodeList(context, pickList, clientId + "_source", "ui-widget-content ui-picklist-list ui-picklist-source", model.getSource(), pickList.getFacet("sourceCaption"));
        writer.startElement("td", null);
        this.encodeButton(context, pickList.getAddLabel(), "ui-picklist-button-add", "ui-icon ui-icon-arrow-1-e");
        this.encodeButton(context, pickList.getAddAllLabel(), "ui-picklist-button-add-all", "ui-icon ui-icon-arrowstop-1-e");
        this.encodeButton(context, pickList.getRemoveLabel(), "ui-picklist-button-remove", "ui-icon ui-icon-arrow-1-w");
        this.encodeButton(context, pickList.getRemoveAllLabel(), "ui-picklist-button-remove-all", "ui-icon ui-icon-arrowstop-1-w");
        writer.endElement("td");
        this.encodeList(context, pickList, clientId + "_target", "ui-widget-content ui-picklist-list ui-picklist-target", model.getTarget(), pickList.getFacet("targetCaption"));
        if (pickList.isShowTargetControls()) {
            this.encodeListControls(context, pickList, "ui-picklist-target-controls");
        }
        writer.endElement("tr");
        writer.endElement("tbody");
        writer.endElement("table");
    }

    protected void encodeScript(FacesContext context, PickList pickList) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = pickList.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("PrimeFaces.cw('PickList','" + pickList.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",effect:'" + pickList.getEffect() + "'");
        writer.write(",effectSpeed:'" + pickList.getEffectSpeed() + "'");
        if (pickList.isShowSourceControls()) {
            writer.write(",showSourceControls:true");
        }
        if (pickList.isShowTargetControls()) {
            writer.write(",showTargetControls:true");
        }
        if (pickList.isDisabled()) {
            writer.write(",disabled:true");
        }
        if (pickList.getOnTransfer() != null) {
            writer.write(",onTransfer:function(e) {" + pickList.getOnTransfer() + ";}");
        }
        writer.write("});");
        this.endScript(writer);
    }

    protected void encodeListControls(FacesContext context, PickList pickList, String styleClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("td", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        this.encodeButton(context, pickList.getMoveUpLabel(), "ui-picklist-button-move-up", "ui-icon ui-icon-arrow-1-n");
        this.encodeButton(context, pickList.getMoveTopLabel(), "ui-picklist-button-move-top", "ui-icon ui-icon-arrowstop-1-n");
        this.encodeButton(context, pickList.getMoveDownLabel(), "ui-picklist-button-move-down", "ui-icon ui-icon-arrow-1-s");
        this.encodeButton(context, pickList.getMoveBottomLabel(), "ui-picklist-button-move-bottom", "ui-icon ui-icon-arrowstop-1-s");
        writer.endElement("td");
    }

    protected void encodeCaption(FacesContext context, UIComponent caption) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-picklist-caption ui-widget-header ui-corner-tl ui-corner-tr", null);
        caption.encodeAll(context);
        writer.endElement("div");
    }

    protected void encodeButton(FacesContext context, String title, String styleClass, String icon) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("button", null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)("ui-button ui-widget ui-state-default ui-corner-all ui-button-icon-only " + styleClass), null);
        writer.writeAttribute("title", (Object)title, null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)("ui-button-icon-left ui-icon " + icon), null);
        writer.endElement("span");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text", null);
        writer.write("ui-button");
        writer.endElement("span");
        writer.endElement("button");
    }

    protected void encodeList(FacesContext context, PickList pickList, String listId, String styleClass, List model, UIComponent caption) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("td", null);
        if (caption != null) {
            this.encodeCaption(context, caption);
            styleClass = styleClass + " ui-corner-bottom";
        } else {
            styleClass = styleClass + " ui-corner-all";
        }
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        this.encodeOptions(context, pickList, model);
        writer.endElement("ul");
        this.encodeListInput(context, listId);
        writer.endElement("td");
    }

    protected void encodeListInput(FacesContext context, String clientId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("select", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("multiple", (Object)"true", null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden", null);
        writer.endElement("select");
    }

    protected void encodeOptions(FacesContext context, PickList pickList, List model) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String var = pickList.getVar();
        Converter converter = pickList.getConverter();
        for (Object item : model) {
            context.getExternalContext().getRequestMap().put(var, item);
            String value = converter != null ? converter.getAsString(context, (UIComponent)pickList, pickList.getItemValue()) : pickList.getItemValue().toString();
            String itemClass = pickList.isItemDisabled() ? "ui-picklist-item ui-corner-all ui-state-disabled" : "ui-picklist-item ui-corner-all";
            writer.startElement("li", null);
            writer.writeAttribute("class", (Object)itemClass, null);
            writer.writeAttribute("data-item-value", (Object)value, null);
            if (pickList.getChildCount() > 0) {
                writer.startElement("table", null);
                writer.startElement("tbody", null);
                writer.startElement("tr", null);
                for (UIComponent kid : pickList.getChildren()) {
                    if (!(kid instanceof Column) || !kid.isRendered()) continue;
                    Column column = (Column)kid;
                    writer.startElement("td", null);
                    if (column.getStyle() != null) {
                        writer.writeAttribute("style", (Object)column.getStyle(), null);
                    }
                    if (column.getStyleClass() != null) {
                        writer.writeAttribute("class", (Object)column.getStyleClass(), null);
                    }
                    kid.encodeAll(context);
                    writer.endElement("td");
                }
                writer.endElement("tr");
                writer.endElement("tbody");
                writer.endElement("table");
            } else {
                writer.writeText((Object)pickList.getItemLabel(), null);
            }
            writer.endElement("li");
        }
        context.getExternalContext().getRequestMap().remove(var);
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        try {
            PickList pickList = (PickList)component;
            String[][] value = (String[][])submittedValue;
            String[] sourceValue = value[0];
            String[] targetValue = value[1];
            DualListModel model = new DualListModel();
            this.doConvertValue(context, pickList, sourceValue, model.getSource());
            this.doConvertValue(context, pickList, targetValue, model.getTarget());
            return model;
        }
        catch (Exception exception) {
            throw new ConverterException((Throwable)exception);
        }
    }

    protected void doConvertValue(FacesContext context, PickList pickList, String[] values, List model) {
        Converter converter = pickList.getConverter();
        for (String item : values) {
            String convertedValue;
            if (this.isValueBlank(item)) continue;
            String string = convertedValue = converter != null ? converter.getAsObject(context, (UIComponent)pickList, item) : item;
            if (convertedValue == null) continue;
            model.add(convertedValue);
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

