/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.panelgrid;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.column.Column;
import org.primefaces.component.panelgrid.PanelGrid;
import org.primefaces.component.row.Row;
import org.primefaces.renderkit.CoreRenderer;

public class PanelGridRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        PanelGrid grid = (PanelGrid)component;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = grid.getClientId(context);
        int columns = grid.getColumns();
        String style = grid.getStyle();
        String styleClass = grid.getStyleClass();
        styleClass = styleClass == null ? "ui-panelgrid ui-widget" : "ui-panelgrid ui-widget " + styleClass;
        writer.startElement("table", (UIComponent)grid);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.writeAttribute("role", (Object)"grid", null);
        this.encodeFacet(context, grid, columns, "header", "thead", "ui-panelgrid-header");
        this.encodeFacet(context, grid, columns, "footer", "tfoot", "ui-panelgrid-footer");
        this.encodeBody(context, grid, columns);
        writer.endElement("table");
    }

    public void encodeBody(FacesContext context, PanelGrid grid, int columns) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("tbody", (UIComponent)grid);
        if (columns > 0) {
            this.encodeDynamicBody(context, grid, grid.getColumns());
        } else {
            this.encodeStaticBody(context, grid);
        }
        writer.endElement("tbody");
    }

    public void encodeDynamicBody(FacesContext context, PanelGrid grid, int columns) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String columnClassesValue = grid.getColumnClasses();
        String[] columnClasses = columnClassesValue == null ? new String[]{} : columnClassesValue.split(",");
        int i = 0;
        for (UIComponent child : grid.getChildren()) {
            int colMod = i % columns;
            if (colMod == 0) {
                writer.startElement("tr", null);
                writer.writeAttribute("class", (Object)"ui-widget-content", null);
                writer.writeAttribute("role", (Object)"row", null);
            }
            if (child.isRendered()) {
                writer.startElement("td", null);
                writer.writeAttribute("role", (Object)"gridcell", null);
                if (colMod < columnClasses.length) {
                    writer.writeAttribute("class", (Object)columnClasses[colMod].trim(), null);
                }
                child.encodeAll(context);
                writer.endElement("td");
                colMod = ++i % columns;
            }
            if (colMod != 0) continue;
            writer.endElement("tr");
        }
    }

    public void encodeStaticBody(FacesContext context, PanelGrid grid) throws IOException {
        for (UIComponent child : grid.getChildren()) {
            if (!(child instanceof Row) || !child.isRendered()) continue;
            this.encodeRow(context, (Row)child, "gridcell", "ui-widget-content", null);
        }
    }

    public void encodeRow(FacesContext context, Row row, String columnRole, String rowClass, String columnClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("tr", null);
        writer.writeAttribute("class", (Object)rowClass, null);
        writer.writeAttribute("role", (Object)"row", null);
        for (UIComponent child : row.getChildren()) {
            if (!(child instanceof Column) || !child.isRendered()) continue;
            Column column = (Column)child;
            String styleClass = null;
            String userStyleClass = column.getStyleClass();
            if (userStyleClass != null && columnClass != null) {
                styleClass = columnClass + " " + userStyleClass;
            } else if (userStyleClass != null && columnClass == null) {
                styleClass = userStyleClass;
            } else if (userStyleClass == null && columnClass != null) {
                styleClass = columnClass;
            }
            writer.startElement("td", null);
            writer.writeAttribute("role", (Object)columnRole, null);
            if (column.getStyle() != null) {
                writer.writeAttribute("style", (Object)column.getStyle(), null);
            }
            if (styleClass != null) {
                writer.writeAttribute("class", (Object)styleClass, null);
            }
            if (column.getColspan() > 1) {
                writer.writeAttribute("colspan", (Object)column.getColspan(), null);
            }
            if (column.getRowspan() > 1) {
                writer.writeAttribute("rowspan", (Object)column.getRowspan(), null);
            }
            column.encodeAll(context);
            writer.endElement("td");
        }
        writer.endElement("tr");
    }

    public void encodeFacet(FacesContext context, PanelGrid grid, int columns, String facet, String tag, String styleClass) throws IOException {
        UIComponent component = grid.getFacet(facet);
        if (component != null && component.isRendered()) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement(tag, null);
            writer.writeAttribute("class", (Object)styleClass, null);
            if (columns > 0) {
                writer.startElement("tr", null);
                writer.writeAttribute("class", (Object)"ui-widget-header", null);
                writer.writeAttribute("role", (Object)"row", null);
                writer.startElement("td", null);
                writer.writeAttribute("colspan", (Object)columns, null);
                writer.writeAttribute("role", (Object)"columnheader", null);
                component.encodeAll(context);
                writer.endElement("td");
                writer.endElement("tr");
            } else if (component instanceof Row) {
                this.encodeRow(context, (Row)component, "columnheader", "ui-widget-header", "ui-widget-header");
            } else if (component instanceof UIPanel) {
                for (UIComponent row : component.getChildren()) {
                    if (!(row instanceof Row) || !row.isRendered()) continue;
                    this.encodeRow(context, (Row)row, "columnheader", "ui-widget-header", "ui-widget-header");
                }
            }
            writer.endElement(tag);
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

