/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.notificationbar;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.notificationbar.NotificationBar;
import org.primefaces.renderkit.CoreRenderer;

public class NotificationBarRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        NotificationBar bar = (NotificationBar)component;
        this.encodeMarkup(context, bar);
        this.encodeScript(context, bar);
    }

    protected void encodeMarkup(FacesContext context, NotificationBar bar) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String styleClass = bar.getStyleClass();
        styleClass = styleClass == null ? "ui-notificationbar ui-widget ui-widget-content" : "ui-notificationbar ui-widget ui-widget-content " + styleClass;
        writer.startElement("div", (UIComponent)bar);
        writer.writeAttribute("id", (Object)bar.getClientId(context), null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (bar.getStyle() != null) {
            writer.writeAttribute("style", (Object)bar.getStyle(), null);
        }
        this.renderChildren(context, (UIComponent)bar);
        writer.endElement("div");
    }

    private void encodeScript(FacesContext facesContext, NotificationBar bar) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = bar.getClientId(facesContext);
        this.startScript(writer, clientId);
        writer.write("$(function() {");
        writer.write("PrimeFaces.cw('NotificationBar','" + bar.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",position:'" + bar.getPosition() + "'");
        writer.write(",effect:'" + bar.getEffect() + "'");
        writer.write(",effectSpeed:'" + bar.getEffectSpeed() + "'");
        if (bar.isAutoDisplay()) {
            writer.write(",autoDisplay:true");
        }
        writer.write("});});");
        this.endScript(writer);
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

