/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.menubar;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.menu.BaseMenuRenderer;
import org.primefaces.component.menubar.Menubar;
import org.primefaces.component.submenu.Submenu;

public class MenubarRenderer
extends BaseMenuRenderer {
    protected void encodeScript(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Menubar menubar = (Menubar)abstractMenu;
        String clientId = menubar.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("PrimeFaces.cw('Menubar','" + menubar.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",autoDisplay:" + menubar.isAutoDisplay());
        writer.write("});");
        this.endScript(writer);
    }

    protected void encodeMarkup(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Menubar menubar = (Menubar)abstractMenu;
        String clientId = menubar.getClientId(context);
        String style = menubar.getStyle();
        String styleClass = menubar.getStyleClass();
        styleClass = styleClass == null ? "ui-menu ui-menubar ui-widget ui-widget-content ui-corner-all ui-helper-clearfix" : "ui-menu ui-menubar ui-widget ui-widget-content ui-corner-all ui-helper-clearfix " + styleClass;
        writer.startElement("div", (UIComponent)menubar);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.writeAttribute("role", (Object)"menubar", null);
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)"ui-menu-list ui-helper-reset", null);
        this.encodeTieredMenuContent(context, (UIComponent)menubar);
        writer.endElement("ul");
        writer.endElement("div");
    }

    protected void encodeTieredSubmenuIcon(FacesContext context, Submenu submenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String icon = submenu.getParent() instanceof Menubar ? "ui-icon ui-icon-triangle-1-s" : "ui-icon ui-icon-triangle-1-e";
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)icon, null);
        writer.endElement("span");
    }
}

