/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.menu;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.menu.BaseMenuRenderer;
import org.primefaces.component.menu.Menu;
import org.primefaces.component.menuitem.MenuItem;
import org.primefaces.component.separator.Separator;
import org.primefaces.component.submenu.Submenu;

public class MenuRenderer
extends BaseMenuRenderer {
    protected void encodeScript(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Menu menu = (Menu)abstractMenu;
        String clientId = menu.getClientId(context);
        String widgetVar = menu.resolveWidgetVar();
        String position = menu.getPosition();
        this.startScript(writer, clientId);
        writer.write("$(function() {");
        writer.write("PrimeFaces.cw('Menu','" + widgetVar + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",position:'" + position + "'");
        writer.write(",type:'" + menu.getType() + "'");
        if (menu.getEasing() != null) {
            writer.write(",easing:'" + menu.getEasing() + "'");
        }
        if (position.equalsIgnoreCase("dynamic")) {
            writer.write(",my:'" + menu.getMy() + "'");
            writer.write(",at:'" + menu.getAt() + "'");
            UIComponent trigger = menu.findComponent(menu.getTrigger());
            String triggerClientId = trigger == null ? menu.getTrigger() : trigger.getClientId(context);
            writer.write(",trigger:'" + triggerClientId + "'");
            writer.write(",triggerEvent:'" + menu.getTriggerEvent() + "'");
        }
        writer.write("});});");
        this.endScript(writer);
    }

    protected void encodeMarkup(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Menu menu = (Menu)abstractMenu;
        String clientId = menu.getClientId(context);
        boolean tiered = !menu.getType().equalsIgnoreCase("plain");
        boolean sliding = menu.getType().equalsIgnoreCase("sliding");
        boolean dynamic = menu.getPosition().equals("dynamic");
        String style = menu.getStyle();
        String styleClass = menu.getStyleClass();
        String defaultStyleClass = dynamic ? "ui-menu ui-menu-dynamic ui-widget ui-widget-content ui-corner-all ui-helper-clearfix ui-shadow" : "ui-menu ui-widget ui-widget-content ui-corner-all ui-helper-clearfix";
        styleClass = styleClass == null ? defaultStyleClass : defaultStyleClass + " " + styleClass;
        styleClass = sliding ? styleClass + " " + "ui-menu-sliding ui-widget-content" : styleClass;
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.writeAttribute("role", (Object)"menu", null);
        if (sliding) {
            this.encodeSlidingMenuBegin(context, menu);
        }
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)"ui-menu-list ui-helper-reset", null);
        if (tiered) {
            this.encodeTieredMenuContent(context, (UIComponent)menu);
        } else {
            this.encodePlainMenuContent(context, (UIComponent)menu);
        }
        writer.endElement("ul");
        if (sliding) {
            this.encodeSlidingMenuEnd(context, menu);
        }
        writer.endElement("div");
    }

    protected void encodePlainMenuContent(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        for (UIComponent child : component.getChildren()) {
            if (!child.isRendered()) continue;
            if (child instanceof MenuItem) {
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)"ui-menuitem ui-widget ui-corner-all", null);
                writer.writeAttribute("role", (Object)"menuitem", null);
                this.encodeMenuItem(context, (MenuItem)child);
                writer.endElement("li");
                continue;
            }
            if (child instanceof Submenu) {
                this.encodePlainSubmenu(context, (Submenu)child);
                continue;
            }
            if (!(child instanceof Separator)) continue;
            this.encodeSeparator(context, (Separator)child);
        }
    }

    protected void encodePlainSubmenu(FacesContext context, Submenu submenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String label = submenu.getLabel();
        String style = submenu.getStyle();
        String styleClass = submenu.getStyleClass();
        styleClass = styleClass == null ? "ui-widget-header ui-corner-all" : "ui-widget-header ui-corner-all " + styleClass;
        writer.startElement("li", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.startElement("h3", null);
        if (label != null) {
            writer.writeText((Object)label, "value");
        }
        writer.endElement("h3");
        writer.endElement("li");
        this.encodePlainMenuContent(context, (UIComponent)submenu);
    }

    protected void encodeSlidingMenuBegin(FacesContext context, Menu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("class", (Object)"ui-menu-sliding-scroll ui-widget ui-widget-content ui-corner-all", null);
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("class", (Object)"ui-menu-sliding-state", "state");
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("class", (Object)"ui-menu-sliding-wrapper", "wrapper");
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("class", (Object)"ui-menu-sliding-content", "sliding_content");
        writer.startElement("div", (UIComponent)menu);
    }

    protected void encodeSlidingMenuEnd(FacesContext context, Menu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("class", (Object)"ui-menu-backward ui-helper-clearfix", null);
        writer.startElement("span", (UIComponent)menu);
        writer.writeAttribute("class", (Object)"ui-icon ui-icon-triangle-1-w", null);
        writer.endElement("span");
        writer.write(menu.getBackLabel());
        writer.endElement("div");
    }
}

