/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.menu;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.menuitem.MenuItem;
import org.primefaces.component.separator.Separator;
import org.primefaces.component.submenu.Submenu;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public abstract class BaseMenuRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        AbstractMenu menu = (AbstractMenu)component;
        if (menu.isDynamic()) {
            menu.buildMenuFromModel();
        }
        this.encodeMarkup(context, menu);
        this.encodeScript(context, menu);
    }

    protected abstract void encodeMarkup(FacesContext var1, AbstractMenu var2) throws IOException;

    protected abstract void encodeScript(FacesContext var1, AbstractMenu var2) throws IOException;

    protected void encodeMenuItem(FacesContext context, MenuItem menuItem) throws IOException {
        String clientId = menuItem.getClientId(context);
        ResponseWriter writer = context.getResponseWriter();
        String icon = menuItem.getIcon();
        if (menuItem.shouldRenderChildren()) {
            this.renderChildren(context, (UIComponent)menuItem);
        } else {
            boolean disabled = menuItem.isDisabled();
            String onclick = menuItem.getOnclick();
            writer.startElement("a", null);
            writer.writeAttribute("id", (Object)menuItem.getClientId(context), null);
            String styleClass = menuItem.getStyleClass();
            styleClass = styleClass == null ? "ui-menuitem-link ui-corner-all" : "ui-menuitem-link ui-corner-all " + styleClass;
            styleClass = disabled ? styleClass + " ui-state-disabled" : styleClass;
            writer.writeAttribute("class", (Object)styleClass, null);
            if (menuItem.getStyle() != null) {
                writer.writeAttribute("style", (Object)menuItem.getStyle(), null);
            }
            if (menuItem.getUrl() != null) {
                String href = disabled ? "#" : this.getResourceURL(context, menuItem.getUrl());
                writer.writeAttribute("href", (Object)href, null);
                if (menuItem.getTarget() != null) {
                    writer.writeAttribute("target", (Object)menuItem.getTarget(), null);
                }
            } else {
                writer.writeAttribute("href", (Object)"#", null);
                UIComponent form = ComponentUtils.findParentForm(context, (UIComponent)menuItem);
                if (form == null) {
                    throw new FacesException("Menubar must be inside a form element");
                }
                String command = menuItem.isAjax() ? this.buildAjaxRequest(context, menuItem) : this.buildNonAjaxRequest(context, (UIComponent)menuItem, form.getClientId(context), clientId);
                String string = onclick = onclick == null ? command : onclick + ";" + command;
            }
            if (onclick != null && !disabled) {
                writer.writeAttribute("onclick", (Object)onclick, null);
            }
            if (icon != null) {
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)("ui-menuitem-icon ui-icon " + icon), null);
                writer.endElement("span");
            }
            if (menuItem.getValue() != null) {
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)"ui-menuitem-text", null);
                writer.writeText((Object)((String)menuItem.getValue()), "value");
                writer.endElement("span");
            }
            writer.endElement("a");
        }
    }

    protected void encodeTieredMenuContent(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        for (UIComponent child : component.getChildren()) {
            if (!child.isRendered()) continue;
            if (child instanceof MenuItem) {
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)"ui-menuitem ui-widget ui-corner-all", null);
                writer.writeAttribute("role", (Object)"menuitem", null);
                this.encodeMenuItem(context, (MenuItem)child);
                writer.endElement("li");
                continue;
            }
            if (child instanceof Submenu) {
                Submenu submenu = (Submenu)child;
                String style = submenu.getStyle();
                String styleClass = submenu.getStyleClass();
                styleClass = styleClass == null ? "ui-widget ui-menuitem ui-corner-all ui-menu-parent" : "ui-widget ui-menuitem ui-corner-all ui-menu-parent " + styleClass;
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)styleClass, null);
                if (style != null) {
                    writer.writeAttribute("style", (Object)style, null);
                }
                writer.writeAttribute("role", (Object)"menuitem", null);
                writer.writeAttribute("aria-haspopup", (Object)"true", null);
                this.encodeTieredSubmenu(context, (Submenu)child);
                writer.endElement("li");
                continue;
            }
            if (!(child instanceof Separator)) continue;
            this.encodeSeparator(context, (Separator)child);
        }
    }

    protected void encodeTieredSubmenu(FacesContext context, Submenu submenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String icon = submenu.getIcon();
        String label = submenu.getLabel();
        writer.startElement("a", null);
        writer.writeAttribute("href", (Object)"javascript:void(0)", null);
        writer.writeAttribute("class", (Object)"ui-menuitem-link ui-corner-all", null);
        if (icon != null) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)("ui-menuitem-icon ui-icon " + icon), null);
            writer.endElement("span");
        }
        if (label != null) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)"ui-menuitem-text", null);
            writer.writeText((Object)submenu.getLabel(), "value");
            writer.endElement("span");
        }
        this.encodeTieredSubmenuIcon(context, submenu);
        writer.endElement("a");
        if (submenu.getChildCount() > 0) {
            writer.startElement("ul", null);
            writer.writeAttribute("class", (Object)"ui-widget-content ui-menu-list ui-corner-all ui-helper-clearfix ui-menu-child ui-shadow", null);
            writer.writeAttribute("role", (Object)"menu", null);
            this.encodeTieredMenuContent(context, (UIComponent)submenu);
            writer.endElement("ul");
        }
    }

    protected void encodeTieredSubmenuIcon(FacesContext context, Submenu submenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-icon ui-icon-triangle-1-e", null);
        writer.endElement("span");
    }

    protected void encodeSeparator(FacesContext context, Separator separator) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String style = separator.getStyle();
        String styleClass = separator.getStyleClass();
        styleClass = styleClass == null ? "ui-separator ui-state-default" : "ui-separator ui-state-default " + styleClass;
        writer.startElement("li", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.endElement("li");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

