/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.media;

import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.media.Media;
import org.primefaces.component.media.player.MediaPlayer;
import org.primefaces.component.media.player.MediaPlayerFactory;
import org.primefaces.model.StreamedContent;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.AgentUtils;
import org.primefaces.util.HTML;

public class MediaRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Media media = (Media)component;
        MediaPlayer player = this.resolvePlayer(context, media);
        if (AgentUtils.isIE(context)) {
            this.encodeObjectTag(context, media, player);
        } else {
            this.encodeEmbedTag(context, media, player);
        }
    }

    private void encodeObjectTag(FacesContext context, Media media, MediaPlayer player) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String src = this.getMediaSrc(context, media);
        writer.startElement("object", (UIComponent)media);
        writer.writeAttribute("classid", (Object)player.getClassId(), null);
        if (player.getCodebase() != null) {
            writer.writeAttribute("codebase", (Object)player.getCodebase(), null);
        }
        if (media.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)media.getStyleClass(), null);
        }
        this.renderPassThruAttributes(context, (UIComponent)media, HTML.MEDIA_ATTRS);
        this.encodeParam(writer, player.getSourceParam(), src, false);
        for (UIComponent child : media.getChildren()) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter param = (UIParameter)child;
            this.encodeParam(writer, param.getName(), param.getValue(), false);
        }
        writer.endElement("object");
    }

    private void encodeEmbedTag(FacesContext context, Media media, MediaPlayer player) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String src = this.getMediaSrc(context, media);
        writer.startElement("embed", (UIComponent)media);
        writer.writeAttribute("pluginspage", (Object)player.getPlugingPage(), null);
        writer.writeAttribute("src", (Object)src, null);
        if (media.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)media.getStyleClass(), null);
        }
        if (player.getType() != null) {
            writer.writeAttribute("type", (Object)player.getType(), null);
        }
        this.renderPassThruAttributes(context, (UIComponent)media, HTML.MEDIA_ATTRS);
        for (UIComponent child : media.getChildren()) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter param = (UIParameter)child;
            this.encodeParam(writer, param.getName(), param.getValue(), true);
        }
        writer.endElement("embed");
    }

    private void encodeParam(ResponseWriter writer, String name, Object value, boolean asAttribute) throws IOException {
        if (value == null) {
            return;
        }
        if (asAttribute) {
            writer.writeAttribute(name, value, null);
        } else {
            writer.startElement("param", null);
            writer.writeAttribute("name", (Object)name, null);
            writer.writeAttribute("value", (Object)value.toString(), null);
            writer.endElement("param");
        }
    }

    private MediaPlayer resolvePlayer(FacesContext context, Media media) {
        if (media.getPlayer() != null) {
            return MediaPlayerFactory.getPlayer(media.getPlayer());
        }
        if (media.getValue() instanceof String) {
            Map<String, MediaPlayer> players = MediaPlayerFactory.getPlayers();
            String[] tokens = ((String)media.getValue()).split("\\.");
            String type = tokens[tokens.length - 1];
            for (MediaPlayer mp : players.values()) {
                if (!mp.isAppropriatePlayer(type)) continue;
                return mp;
            }
        }
        throw new IllegalArgumentException("Cannot resolve mediaplayer for media component '" + media.getClientId(context) + "', cannot play source:" + media.getValue());
    }

    protected String getMediaSrc(FacesContext context, Media media) {
        String src = null;
        Object value = media.getValue();
        if (value == null) {
            src = "";
        } else if (value instanceof StreamedContent) {
            StreamedContent streamedContent = (StreamedContent)value;
            Resource resource = context.getApplication().getResourceHandler().createResource("dynamiccontent", "primefaces", streamedContent.getContentType());
            String resourcePath = resource.getRequestPath();
            String rid = this.createUniqueContentId(context);
            StringBuilder builder = new StringBuilder(resourcePath);
            builder.append("&").append("pfdrid").append("=").append(rid);
            for (UIComponent kid : media.getChildren()) {
                if (!(kid instanceof UIParameter)) continue;
                UIParameter param = (UIParameter)kid;
                builder.append("&").append(param.getName()).append("=").append(param.getValue());
            }
            src = builder.toString();
            context.getExternalContext().getSessionMap().put(rid, media.getValueExpression("value").getExpressionString());
        } else {
            src = this.getResourceURL(context, (String)value);
        }
        return src;
    }

    protected String createUniqueContentId(FacesContext context) {
        Map session = context.getExternalContext().getSessionMap();
        String key = this.generateKey();
        while (session.containsKey(key)) {
            key = this.generateKey();
        }
        return key;
    }

    protected String generateKey() {
        StringBuilder builder = new StringBuilder();
        return builder.append("pfdrid").append("_").append(UUID.randomUUID().toString()).toString();
    }
}

