/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.lightbox;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.lightbox.LightBox;
import org.primefaces.renderkit.CoreRenderer;

public class LightBoxRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        LightBox lb = (LightBox)component;
        this.encodeScript(context, (UIComponent)lb);
        this.encodeMarkup(context, (UIComponent)lb);
    }

    public void encodeMarkup(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        LightBox lb = (LightBox)component;
        String clientId = lb.getClientId(context);
        UIComponent inline = lb.getFacet("inline");
        writer.startElement("div", (UIComponent)lb);
        writer.writeAttribute("id", (Object)clientId, "id");
        if (lb.getStyle() != null) {
            writer.writeAttribute("style", (Object)lb.getStyle(), null);
        }
        if (lb.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)lb.getStyleClass(), null);
        }
        this.renderChildren(context, (UIComponent)lb);
        if (inline != null) {
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-lightbox-inline ui-helper-hidden", null);
            inline.encodeAll(context);
            writer.endElement("div");
        }
        writer.endElement("div");
    }

    public void encodeScript(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        LightBox lb = (LightBox)component;
        String clientId = lb.getClientId(context);
        String mode = "image";
        if (lb.getFacet("inline") != null) {
            mode = "inline";
        } else if (lb.isIframe()) {
            mode = "iframe";
        }
        this.startScript(writer, clientId);
        writer.write("$(function() {");
        writer.write("PrimeFaces.cw('LightBox','" + lb.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",mode:'" + mode + "'");
        if (lb.getWidth() != null) {
            writer.write(",width:'" + lb.getWidth() + "'");
        }
        if (lb.getHeight() != null) {
            writer.write(",height:'" + lb.getHeight() + "'");
        }
        if (lb.isVisible()) {
            writer.write(",visible:true");
        }
        if (lb.getOnShow() != null) {
            writer.write(",onShow:function(){" + lb.getOnShow() + "}");
        }
        if (lb.getOnHide() != null) {
            writer.write(",onHide:function(){" + lb.getOnHide() + "}");
        }
        writer.write("});});");
        this.endScript(writer);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

