/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.inputtextarea;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.inputtextarea.InputTextarea;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;

public class InputTextareaRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        InputTextarea inputTextarea = (InputTextarea)component;
        if (inputTextarea.isDisabled() || inputTextarea.isReadonly()) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)inputTextarea);
        String clientId = inputTextarea.getClientId(context);
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(clientId);
        inputTextarea.setSubmittedValue(submittedValue);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        InputTextarea inputTextarea = (InputTextarea)component;
        this.encodeMarkup(context, inputTextarea);
        this.encodeScript(context, inputTextarea);
    }

    protected void encodeScript(FacesContext context, InputTextarea inputTextarea) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inputTextarea.getClientId(context);
        boolean autoResize = inputTextarea.isAutoResize();
        this.startScript(writer, clientId);
        writer.write("PrimeFaces.cw('InputTextarea','" + inputTextarea.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",autoResize:" + autoResize);
        if (inputTextarea.getMaxlength() != Integer.MAX_VALUE) {
            writer.write(",maxlength:" + inputTextarea.getMaxlength());
        }
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)inputTextarea);
        writer.write("});");
        this.endScript(writer);
    }

    protected void encodeMarkup(FacesContext context, InputTextarea inputTextarea) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inputTextarea.getClientId(context);
        writer.startElement("textarea", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        this.renderPassThruAttributes(context, (UIComponent)inputTextarea, HTML.INPUT_TEXTAREA_ATTRS);
        if (inputTextarea.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (inputTextarea.isReadonly()) {
            writer.writeAttribute("readonly", (Object)"readonly", null);
        }
        if (inputTextarea.getStyle() != null) {
            writer.writeAttribute("style", (Object)inputTextarea.getStyle(), null);
        }
        writer.writeAttribute("class", (Object)this.createStyleClass(inputTextarea), "styleClass");
        String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)inputTextarea);
        if (valueToRender != null) {
            writer.writeText((Object)valueToRender, "value");
        }
        writer.endElement("textarea");
    }

    protected String createStyleClass(InputTextarea inputTextarea) {
        String defaultClass = "ui-inputfield ui-inputtextarea ui-widget ui-state-default ui-corner-all";
        defaultClass = inputTextarea.isValid() ? defaultClass : defaultClass + " ui-state-error";
        defaultClass = !inputTextarea.isDisabled() ? defaultClass : defaultClass + " ui-state-disabled";
        String styleClass = inputTextarea.getStyleClass();
        String string = styleClass = styleClass == null ? defaultClass : defaultClass + " " + styleClass;
        if (inputTextarea.isAutoResize()) {
            styleClass = styleClass + " ui-inputtextarea-resizable";
        }
        return styleClass;
    }
}

