/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.growl;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.growl.Growl;
import org.primefaces.renderkit.CoreRenderer;

public class GrowlRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Growl growl = (Growl)component;
        String clientId = growl.getClientId(context);
        String widgetVar = growl.resolveWidgetVar();
        writer.startElement("span", (UIComponent)growl);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.endElement("span");
        this.startScript(writer, clientId);
        writer.write("$(function(){");
        writer.write("PrimeFaces.cw('Growl','" + widgetVar + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",sticky:" + growl.isSticky());
        writer.write(",life:" + growl.getLife());
        writer.write(",msgs:");
        this.encodeMessages(context, growl);
        writer.write("});});");
        this.endScript(writer);
    }

    protected void encodeMessages(FacesContext context, Growl growl) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Iterator messages = growl.isGlobalOnly() ? context.getMessages(null) : context.getMessages();
        writer.write("[");
        while (messages.hasNext()) {
            FacesMessage message = (FacesMessage)messages.next();
            if (message.isRendered() && !growl.isRedisplay()) continue;
            String summary = this.escapeText(message.getSummary());
            String detail = this.escapeText(message.getDetail());
            int ordinal = message.getSeverity().getOrdinal();
            String severity = null;
            writer.write("{");
            if (growl.isShowSummary() && growl.isShowDetail()) {
                writer.writeText((Object)("summary:\"" + summary + "\",detail:\"" + detail + "\""), null);
            } else if (growl.isShowSummary() && !growl.isShowDetail()) {
                writer.writeText((Object)("summary:\"" + summary + "\",detail:\"\""), null);
            } else if (!growl.isShowSummary() && growl.isShowDetail()) {
                writer.writeText((Object)("summary:\"\",detail:\"" + detail + "\""), null);
            }
            if (ordinal == FacesMessage.SEVERITY_INFO.getOrdinal()) {
                severity = "info";
            } else if (ordinal == FacesMessage.SEVERITY_ERROR.getOrdinal()) {
                severity = "error";
            } else if (ordinal == FacesMessage.SEVERITY_WARN.getOrdinal()) {
                severity = "warn";
            } else if (ordinal == FacesMessage.SEVERITY_FATAL.getOrdinal()) {
                severity = "fatal";
            }
            writer.write(",severity:'" + severity + "'");
            writer.write("}");
            if (messages.hasNext()) {
                writer.write(",");
            }
            message.rendered();
        }
        writer.write("]");
    }
}

