/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.fileupload;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.ServletRequestWrapper;
import org.apache.commons.fileupload.FileItem;
import org.primefaces.component.fileupload.FileUpload;
import org.primefaces.event.FileUploadEvent;
import org.primefaces.model.DefaultUploadedFile;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.webapp.MultipartRequest;

public class FileUploadRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        FileUpload fileUpload = (FileUpload)component;
        String clientId = fileUpload.getClientId(context);
        MultipartRequest multipartRequest = this.getMultiPartRequestInChain(context);
        if (multipartRequest != null) {
            FileItem file = multipartRequest.getFileItem(clientId);
            if (fileUpload.getMode().equals("simple")) {
                this.decodeSimple(context, fileUpload, file);
            } else {
                this.decodeAdvanced(context, fileUpload, file);
            }
        }
    }

    public void decodeSimple(FacesContext context, FileUpload fileUpload, FileItem file) {
        if (file.getName().equals("")) {
            fileUpload.setSubmittedValue("");
        } else {
            fileUpload.setSubmittedValue(new DefaultUploadedFile(file));
        }
    }

    public void decodeAdvanced(FacesContext context, FileUpload fileUpload, FileItem file) {
        if (file != null) {
            fileUpload.queueEvent(new FileUploadEvent((UIComponent)fileUpload, new DefaultUploadedFile(file)));
        }
    }

    private MultipartRequest getMultiPartRequestInChain(FacesContext facesContext) {
        Object request = facesContext.getExternalContext().getRequest();
        while (request instanceof ServletRequestWrapper) {
            if (request instanceof MultipartRequest) {
                return (MultipartRequest)((Object)request);
            }
            request = ((ServletRequestWrapper)request).getRequest();
        }
        return null;
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        FileUpload fileUpload = (FileUpload)component;
        this.encodeMarkup(context, fileUpload);
        this.encodeScript(context, fileUpload);
    }

    protected void encodeScript(FacesContext context, FileUpload fileUpload) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = fileUpload.getClientId(context);
        String mode = fileUpload.getMode();
        this.startScript(writer, clientId);
        writer.write("$(function(){");
        writer.write("PrimeFaces.cw('FileUpload','" + fileUpload.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",mode:'" + mode + "'");
        if (!mode.equals("simple")) {
            String update = fileUpload.getUpdate();
            String process = fileUpload.getProcess();
            writer.write(",autoUpload:" + fileUpload.isAuto());
            writer.write(",dnd:" + fileUpload.isDragDropSupport());
            if (update != null) {
                writer.write(",update:'" + ComponentUtils.findClientIds(context, (UIComponent)fileUpload, update) + "'");
            }
            if (process != null) {
                writer.write(",process:'" + ComponentUtils.findClientIds(context, (UIComponent)fileUpload, process) + "'");
            }
            if (fileUpload.getOnstart() != null) {
                writer.write(",onstart:function() {" + fileUpload.getOnstart() + ";}");
            }
            if (fileUpload.getOncomplete() != null) {
                writer.write(",oncomplete:function() {" + fileUpload.getOncomplete() + ";}");
            }
            if (fileUpload.getAllowTypes() != null) {
                writer.write(",acceptFileTypes:" + fileUpload.getAllowTypes());
            }
            if (fileUpload.getSizeLimit() != Integer.MAX_VALUE) {
                writer.write(",maxFileSize:" + fileUpload.getSizeLimit());
            }
            if (fileUpload.getInvalidFileMessage() != null) {
                writer.write(",invalidFileMessage:'" + fileUpload.getInvalidFileMessage() + "'");
            }
            if (fileUpload.getInvalidSizeMessage() != null) {
                writer.write(",invalidSizeMessage:'" + fileUpload.getInvalidSizeMessage() + "'");
            }
        }
        writer.write("},'fileupload');});");
        this.endScript(writer);
    }

    protected void encodeMarkup(FacesContext context, FileUpload fileUpload) throws IOException {
        if (fileUpload.getMode().equals("simple")) {
            this.encodeSimpleMarkup(context, fileUpload);
        } else {
            this.encodeAdvancedMarkup(context, fileUpload);
        }
    }

    protected void encodeAdvancedMarkup(FacesContext context, FileUpload fileUpload) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = fileUpload.getClientId(context);
        String styleClass = fileUpload.getStyleClass();
        styleClass = styleClass == null ? "ui-fileupload ui-widget" : "ui-fileupload ui-widget " + styleClass;
        writer.startElement("div", (UIComponent)fileUpload);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "id");
        if (fileUpload.getStyle() != null) {
            writer.writeAttribute("style", (Object)fileUpload.getStyle(), "style");
        }
        writer.startElement("div", (UIComponent)fileUpload);
        writer.writeAttribute("class", (Object)"fileupload-buttonbar ui-widget-header ui-corner-top", "styleClass");
        this.encodeChooseButton(context, fileUpload);
        if (fileUpload.isShowButtons() && !fileUpload.isAuto()) {
            this.encodeButton(context, fileUpload.getUploadLabel(), "start", "ui-icon-arrowreturnthick-1-n");
            this.encodeButton(context, fileUpload.getCancelLabel(), "cancel", "ui-icon-cancel");
        }
        writer.endElement("div");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"fileupload-content ui-widget-content ui-corner-bottom", null);
        writer.startElement("table", null);
        writer.writeAttribute("class", (Object)"files", null);
        writer.endElement("table");
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeSimpleMarkup(FacesContext context, FileUpload fileUpload) throws IOException {
        this.encodeInputField(context, fileUpload, fileUpload.getClientId(context));
    }

    protected void encodeChooseButton(FacesContext context, FileUpload fileUpload) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = fileUpload.getClientId(context);
        writer.startElement("label", null);
        writer.writeAttribute("class", (Object)"ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-left fileinput-button", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-icon-left ui-icon ui-icon-plusthick", null);
        writer.endElement("span");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text", null);
        writer.writeText((Object)fileUpload.getLabel(), "value");
        writer.endElement("span");
        this.encodeInputField(context, fileUpload, clientId + "_input");
        writer.endElement("label");
    }

    protected void encodeInputField(FacesContext context, FileUpload fileUpload, String clientId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"file", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        if (fileUpload.isMultiple()) {
            writer.writeAttribute("multiple", (Object)"multiple", null);
        }
        if (fileUpload.getStyle() != null) {
            writer.writeAttribute("style", (Object)fileUpload.getStyle(), "style");
        }
        if (fileUpload.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)fileUpload.getStyleClass(), "styleClass");
        }
        if (fileUpload.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        writer.endElement("input");
    }

    protected void encodeButton(FacesContext context, String label, String styleClass, String icon) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("button", null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)("ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-left " + styleClass), null);
        String iconClass = "ui-button-icon-left ui-icon";
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)(iconClass + " " + icon), null);
        writer.endElement("span");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text", null);
        writer.writeText((Object)label, "value");
        writer.endElement("span");
        writer.endElement("button");
    }
}

