/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.filedownload;

import java.io.IOException;
import java.io.InputStream;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.primefaces.model.StreamedContent;

public class FileDownloadActionListener
implements ActionListener,
StateHolder {
    private ValueExpression value;
    private ValueExpression contentDisposition;

    public FileDownloadActionListener() {
    }

    public FileDownloadActionListener(ValueExpression value, ValueExpression contentDisposition) {
        this.value = value;
        this.contentDisposition = contentDisposition;
    }

    public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ELContext elContext = facesContext.getELContext();
        StreamedContent content = (StreamedContent)this.value.getValue(elContext);
        if (content == null) {
            return;
        }
        HttpServletResponse response = (HttpServletResponse)facesContext.getExternalContext().getResponse();
        String contentDispositionValue = this.contentDisposition != null ? (String)this.contentDisposition.getValue(elContext) : "attachment";
        try {
            int length;
            response.setContentType(content.getContentType());
            response.setHeader("Content-Disposition", contentDispositionValue + ";filename=\"" + content.getName() + "\"");
            response.addCookie(new Cookie("primefaces.download", "true"));
            byte[] buffer = new byte[2048];
            InputStream inputStream = content.getStream();
            ServletOutputStream outputStream = response.getOutputStream();
            while ((length = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, length);
            }
            response.setStatus(200);
            response.getOutputStream().flush();
            content.getStream().close();
            facesContext.responseComplete();
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public boolean isTransient() {
        return false;
    }

    public void restoreState(FacesContext facesContext, Object state) {
        Object[] values = (Object[])state;
        this.value = (ValueExpression)values[0];
        this.contentDisposition = (ValueExpression)values[1];
    }

    public Object saveState(FacesContext facesContext) {
        Object[] values = new Object[]{this.value, this.contentDisposition};
        return values;
    }

    public void setTransient(boolean value) {
    }
}

