/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.fieldset;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.fieldset.Fieldset;
import org.primefaces.renderkit.CoreRenderer;

public class FieldsetRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        String clientId;
        String toggleStateParam;
        Fieldset fieldset = (Fieldset)component;
        Map params = context.getExternalContext().getRequestParameterMap();
        if (params.containsKey(toggleStateParam = (clientId = fieldset.getClientId()) + "_collapsed")) {
            fieldset.setCollapsed(Boolean.valueOf((String)params.get(toggleStateParam)));
        }
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Fieldset fieldset = (Fieldset)component;
        this.encodeMarkup(context, fieldset);
        this.encodeScript(context, fieldset);
    }

    protected void encodeMarkup(FacesContext context, Fieldset fieldset) throws IOException {
        String styleClass;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = fieldset.getClientId(context);
        boolean toggleable = fieldset.isToggleable();
        String string = styleClass = toggleable ? "ui-fieldset ui-widget ui-widget-content ui-corner-all ui-fieldset-toggleable" : "ui-fieldset ui-widget ui-widget-content ui-corner-all";
        if (fieldset.getStyleClass() != null) {
            styleClass = styleClass + " " + fieldset.getStyleClass();
        }
        writer.startElement("fieldset", (UIComponent)fieldset);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (fieldset.getStyle() != null) {
            writer.writeAttribute("style", (Object)fieldset.getStyle(), "style");
        }
        this.encodeLegend(context, fieldset);
        this.encodeContent(context, fieldset);
        if (toggleable) {
            this.encodeStateHolder(context, fieldset);
        }
        writer.endElement("fieldset");
    }

    protected void encodeContent(FacesContext context, Fieldset fieldset) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-fieldset-content", null);
        if (fieldset.isCollapsed()) {
            writer.writeAttribute("style", (Object)"display:none", null);
        }
        this.renderChildren(context, (UIComponent)fieldset);
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, Fieldset fieldset) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = fieldset.getClientId(context);
        boolean toggleable = fieldset.isToggleable();
        this.startScript(writer, clientId);
        writer.write("PrimeFaces.cw('Fieldset','" + fieldset.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        if (toggleable) {
            writer.write(",toggleable:true");
            writer.write(",collapsed:" + fieldset.isCollapsed());
            writer.write(",toggleSpeed:" + fieldset.getToggleSpeed());
        }
        this.encodeClientBehaviors(context, fieldset);
        writer.write("});");
        this.endScript(writer);
    }

    protected void encodeLegend(FacesContext context, Fieldset fieldset) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String legendText = fieldset.getLegend();
        UIComponent legend = fieldset.getFacet("legend");
        if (legendText != null || legend != null) {
            writer.startElement("legend", null);
            writer.writeAttribute("class", (Object)"ui-fieldset-legend ui-corner-all ui-state-default", null);
            if (fieldset.isToggleable()) {
                String togglerClass = fieldset.isCollapsed() ? "ui-fieldset-toggler ui-icon ui-icon-plusthick" : "ui-fieldset-toggler ui-icon ui-icon-minusthick";
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)togglerClass, null);
                writer.endElement("span");
            }
            if (legend != null) {
                legend.encodeAll(context);
            } else {
                writer.write(fieldset.getLegend());
            }
            writer.endElement("legend");
        }
    }

    protected void encodeStateHolder(FacesContext context, Fieldset fieldset) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String name = fieldset.getClientId(context) + "_collapsed";
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)name, null);
        writer.writeAttribute("name", (Object)name, null);
        writer.writeAttribute("value", (Object)String.valueOf(fieldset.isCollapsed()), null);
        writer.endElement("input");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

