/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import javax.el.MethodExpression;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.export.Exporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLExporter
extends Exporter {
    @Override
    public void export(FacesContext context, DataTable table, String filename, boolean pageOnly, boolean selectionOnly, int[] excludeColumns, String encodingType, MethodExpression preProcessor, MethodExpression postProcessor) throws IOException {
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        response.setContentType("text/xml");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        response.setHeader("Pragma", "public");
        response.setHeader("Content-disposition", "attachment;filename=" + filename + ".xml");
        response.addCookie(new Cookie("primefaces.download", "true"));
        ServletOutputStream os = response.getOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, encodingType);
        PrintWriter writer = new PrintWriter(osw);
        List<UIColumn> columns = this.getColumnsToExport(table, excludeColumns);
        List<String> headers = this.getFacetTexts(table, Exporter.ColumnType.HEADER);
        List<String> footers = this.getFacetTexts(table, Exporter.ColumnType.FOOTER);
        String var = table.getVar().toLowerCase();
        String rowIndexVar = table.getRowIndexVar();
        writer.write("<?xml version=\"1.0\"?>\n");
        writer.write("<" + table.getId() + ">\n");
        if (pageOnly) {
            this.exportPageOnly(context, table, columns, headers, writer);
        } else if (selectionOnly) {
            this.exportSelectionOnly(context, table, columns, headers, writer);
        } else {
            this.exportAll(context, table, columns, headers, writer);
        }
        if (this.hasColumnFooter(columns)) {
            writer.write("\t<footers>\n");
            this.addFooterValues(writer, footers, headers);
            writer.write("\t</footers>\n");
        }
        writer.write("</" + table.getId() + ">");
        table.setRowIndex(-1);
        if (rowIndexVar != null) {
            context.getExternalContext().getRequestMap().remove(rowIndexVar);
        }
        writer.flush();
        writer.close();
        response.getOutputStream().flush();
    }

    public void exportPageOnly(FacesContext context, DataTable table, List<UIColumn> columns, List<String> headers, PrintWriter writer) throws IOException {
        int first = table.getFirst();
        int size = first + table.getRows();
        String rowIndexVar = table.getRowIndexVar();
        String var = table.getVar().toLowerCase();
        for (int i = first; i < size; ++i) {
            table.setRowIndex(i);
            if (!table.isRowAvailable()) break;
            if (rowIndexVar != null) {
                context.getExternalContext().getRequestMap().put(rowIndexVar, i);
            }
            writer.write("\t<" + var + ">\n");
            this.addColumnValues(writer, columns, headers);
            writer.write("\t</" + var + ">\n");
        }
    }

    public void exportSelectionOnly(FacesContext context, DataTable table, List<UIColumn> columns, List<String> headers, PrintWriter writer) throws IOException {
        Object selection = table.getSelection();
        boolean single = table.isSingleSelectionMode();
        int size = selection == null ? 0 : (single ? 1 : Array.getLength(selection));
        String var = table.getVar().toLowerCase();
        for (int i = 0; i < size; ++i) {
            context.getExternalContext().getRequestMap().put(table.getVar(), single ? selection : Array.get(selection, i));
            writer.write("\t<" + var + ">\n");
            this.addColumnValues(writer, columns, headers);
            writer.write("\t</" + var + ">\n");
        }
    }

    public void exportAll(FacesContext context, DataTable table, List<UIColumn> columns, List<String> headers, PrintWriter writer) throws IOException {
        String var = table.getVar().toLowerCase();
        String rowIndexVar = table.getRowIndexVar();
        int first = table.getFirst();
        int rowCount = table.getRowCount();
        int rows = table.getRows();
        boolean lazy = table.isLazy();
        if (lazy) {
            for (int i = 0; i < rowCount; ++i) {
                if (i % rows == 0) {
                    table.setFirst(i);
                    table.loadLazyData();
                }
                table.setRowIndex(i);
                if (!table.isRowAvailable()) break;
                if (rowIndexVar != null) {
                    context.getExternalContext().getRequestMap().put(rowIndexVar, i);
                }
                writer.write("\t<" + var + ">\n");
                this.addColumnValues(writer, columns, headers);
                writer.write("\t</" + var + ">\n");
            }
            table.setFirst(first);
            table.loadLazyData();
        } else {
            for (int i = 0; i < rowCount; ++i) {
                table.setRowIndex(i);
                if (!table.isRowAvailable()) break;
                if (rowIndexVar != null) {
                    context.getExternalContext().getRequestMap().put(rowIndexVar, i);
                }
                writer.write("\t<" + var + ">\n");
                this.addColumnValues(writer, columns, headers);
                writer.write("\t</" + var + ">\n");
            }
            table.setFirst(first);
        }
    }

    private void addColumnValues(PrintWriter writer, List<UIColumn> columns, List<String> headers) throws IOException {
        for (int i = 0; i < columns.size(); ++i) {
            this.addColumnValue(writer, columns.get(i).getChildren(), headers.get(i));
        }
    }

    private void addFooterValues(PrintWriter writer, List<String> footers, List<String> headers) throws IOException {
        for (int i = 0; i < footers.size(); ++i) {
            String footer = footers.get(i);
            if (footer.isEmpty()) continue;
            this.addColumnValue(writer, footer, headers.get(i));
        }
    }

    private List<String> getFacetTexts(UIData data, Exporter.ColumnType columnType) {
        ArrayList<String> facets = new ArrayList<String>();
        for (int i = 0; i < data.getChildCount(); ++i) {
            UIComponent child = (UIComponent)data.getChildren().get(i);
            if (!(child instanceof UIColumn) || !child.isRendered()) continue;
            UIColumn column = (UIColumn)child;
            UIComponent facet = column.getFacet(columnType.facet());
            if (facet != null && facet.isRendered()) {
                String value = this.exportValue(FacesContext.getCurrentInstance(), facet);
                facets.add(value);
                continue;
            }
            facets.add("");
        }
        return facets;
    }

    private void addColumnValue(PrintWriter writer, List<UIComponent> components, String header) throws IOException {
        StringBuilder builder = new StringBuilder();
        String tag = header.toLowerCase();
        writer.write("\t\t<" + tag + ">");
        for (UIComponent component : components) {
            if (!component.isRendered()) continue;
            String value = this.exportValue(FacesContext.getCurrentInstance(), component);
            builder.append(value);
        }
        writer.write(builder.toString());
        writer.write("</" + tag + ">\n");
    }

    private void addColumnValue(PrintWriter writer, String footer, String header) throws IOException {
        String tag = header.toLowerCase();
        writer.write("\t\t<" + tag + ">");
        writer.write(footer.toLowerCase());
        writer.write("</" + tag + ">\n");
    }
}

