/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.List;
import javax.el.MethodExpression;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.export.Exporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFExporter
extends Exporter {
    @Override
    public void export(FacesContext context, DataTable table, String filename, boolean pageOnly, boolean selectionOnly, int[] excludeColumns, String encodingType, MethodExpression preProcessor, MethodExpression postProcessor) throws IOException {
        try {
            Document document = new Document();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PdfWriter.getInstance((Document)document, (OutputStream)baos);
            if (preProcessor != null) {
                preProcessor.invoke(context.getELContext(), new Object[]{document});
            }
            if (!document.isOpen()) {
                document.open();
            }
            PdfPTable pdfTable = this.exportPDFTable(context, table, pageOnly, selectionOnly, excludeColumns, encodingType);
            document.add((Element)pdfTable);
            if (postProcessor != null) {
                postProcessor.invoke(context.getELContext(), new Object[]{document});
            }
            document.close();
            this.writePDFToResponse((HttpServletResponse)context.getExternalContext().getResponse(), baos, filename);
        }
        catch (DocumentException e) {
            throw new IOException(e.getMessage());
        }
    }

    private PdfPTable exportPDFTable(FacesContext context, DataTable table, boolean pageOnly, boolean selectionOnly, int[] excludeColumns, String encoding) {
        List<UIColumn> columns = this.getColumnsToExport(table, excludeColumns);
        int numberOfColumns = columns.size();
        PdfPTable pdfTable = new PdfPTable(numberOfColumns);
        Font font = FontFactory.getFont((String)"Times", (String)encoding);
        Font headerFont = FontFactory.getFont((String)"Times", (String)encoding, (float)12.0f, (int)1);
        String rowIndexVar = table.getRowIndexVar();
        this.addFacetColumns(pdfTable, columns, headerFont, Exporter.ColumnType.HEADER);
        if (pageOnly) {
            this.exportPageOnly(context, table, columns, pdfTable, font);
        } else if (selectionOnly) {
            this.exportSelectionOnly(context, table, columns, pdfTable, font);
        } else {
            this.exportAll(context, table, columns, pdfTable, font);
        }
        if (this.hasColumnFooter(columns)) {
            this.addFacetColumns(pdfTable, columns, headerFont, Exporter.ColumnType.FOOTER);
        }
        table.setRowIndex(-1);
        if (rowIndexVar != null) {
            context.getExternalContext().getRequestMap().remove(rowIndexVar);
        }
        return pdfTable;
    }

    private void exportPageOnly(FacesContext context, DataTable table, List<UIColumn> columns, PdfPTable pdfTable, Font font) {
        String rowIndexVar = table.getRowIndexVar();
        int numberOfColumns = columns.size();
        int first = table.getFirst();
        int size = first + table.getRows();
        for (int i = first; i < size; ++i) {
            table.setRowIndex(i);
            if (!table.isRowAvailable()) break;
            if (rowIndexVar != null) {
                context.getExternalContext().getRequestMap().put(rowIndexVar, i);
            }
            for (int j = 0; j < numberOfColumns; ++j) {
                this.addColumnValue(pdfTable, columns.get(j).getChildren(), j, font);
            }
        }
    }

    private void exportSelectionOnly(FacesContext context, DataTable table, List<UIColumn> columns, PdfPTable pdfTable, Font font) {
        int numberOfColumns = columns.size();
        Object selection = table.getSelection();
        boolean single = table.isSingleSelectionMode();
        int size = selection == null ? 0 : (single ? 1 : Array.getLength(selection));
        for (int i = 0; i < size; ++i) {
            context.getExternalContext().getRequestMap().put(table.getVar(), single ? selection : Array.get(selection, i));
            for (int j = 0; j < numberOfColumns; ++j) {
                this.addColumnValue(pdfTable, columns.get(j).getChildren(), j, font);
            }
        }
    }

    private void exportAll(FacesContext context, DataTable table, List<UIColumn> columns, PdfPTable pdfTable, Font font) {
        String rowIndexVar = table.getRowIndexVar();
        int numberOfColumns = columns.size();
        int first = table.getFirst();
        int rowCount = table.getRowCount();
        int rows = table.getRows();
        boolean lazy = table.isLazy();
        if (lazy) {
            for (int i = 0; i < rowCount; ++i) {
                if (i % rows == 0) {
                    table.setFirst(i);
                    table.loadLazyData();
                }
                table.setRowIndex(i);
                if (!table.isRowAvailable()) break;
                if (rowIndexVar != null) {
                    context.getExternalContext().getRequestMap().put(rowIndexVar, i);
                }
                for (int j = 0; j < numberOfColumns; ++j) {
                    this.addColumnValue(pdfTable, columns.get(j).getChildren(), j, font);
                }
            }
            table.setFirst(first);
            table.loadLazyData();
        } else {
            for (int i = 0; i < rowCount; ++i) {
                table.setRowIndex(i);
                if (!table.isRowAvailable()) break;
                if (rowIndexVar != null) {
                    context.getExternalContext().getRequestMap().put(rowIndexVar, i);
                }
                for (int j = 0; j < numberOfColumns; ++j) {
                    this.addColumnValue(pdfTable, columns.get(j).getChildren(), j, font);
                }
            }
            table.setFirst(first);
        }
    }

    private void addFacetColumns(PdfPTable pdfTable, List<UIColumn> columns, Font font, Exporter.ColumnType columnType) {
        for (int i = 0; i < columns.size(); ++i) {
            UIColumn column = columns.get(i);
            this.addColumnValue(pdfTable, column.getFacet(columnType.facet()), font);
        }
    }

    private void addColumnValue(PdfPTable pdfTable, UIComponent component, Font font) {
        String value = component == null ? "" : this.exportValue(FacesContext.getCurrentInstance(), component);
        pdfTable.addCell((Phrase)new Paragraph(value, font));
    }

    private void addColumnValue(PdfPTable pdfTable, List<UIComponent> components, int index, Font font) {
        StringBuilder builder = new StringBuilder();
        for (UIComponent component : components) {
            String value;
            if (!component.isRendered() || (value = this.exportValue(FacesContext.getCurrentInstance(), component)) == null) continue;
            builder.append(value);
        }
        pdfTable.addCell((Phrase)new Paragraph(builder.toString(), font));
    }

    private void writePDFToResponse(HttpServletResponse response, ByteArrayOutputStream baos, String fileName) throws IOException, DocumentException {
        response.setContentType("application/pdf");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        response.setHeader("Pragma", "public");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".pdf");
        response.setContentLength(baos.size());
        response.addCookie(new Cookie("primefaces.download", "true"));
        ServletOutputStream out = response.getOutputStream();
        baos.writeTo((OutputStream)out);
        out.flush();
    }
}

